/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.propagation;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.ContextKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class PassThroughPropagator
implements TextMapPropagator {
    private static final ContextKey<List<String>> EXTRACTED_KEY_VALUES = ContextKey.named("passthroughpropagator-keyvalues");
    private final List<String> fields;

    private PassThroughPropagator(List<String> fields) {
        this.fields = Collections.unmodifiableList(fields);
    }

    public static TextMapPropagator create(String ... fields) {
        Objects.requireNonNull(fields, "fields");
        return PassThroughPropagator.create(Arrays.asList(fields));
    }

    public static TextMapPropagator create(Iterable<String> fields) {
        Objects.requireNonNull(fields, "fields");
        List<String> fieldsList = StreamSupport.stream(fields.spliterator(), false).map(field -> Objects.requireNonNull(field, "field")).collect(Collectors.toList());
        if (fieldsList.isEmpty()) {
            return TextMapPropagator.noop();
        }
        return new PassThroughPropagator(fieldsList);
    }

    @Override
    public Collection<String> fields() {
        return this.fields;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        List<String> extracted = context.get(EXTRACTED_KEY_VALUES);
        if (extracted != null) {
            for (int i = 0; i < extracted.size(); i += 2) {
                setter.set(carrier, extracted.get(i), extracted.get(i + 1));
            }
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        ArrayList<String> extracted = null;
        for (String field : this.fields) {
            String value = getter.get(carrier, field);
            if (value == null) continue;
            if (extracted == null) {
                extracted = new ArrayList<String>();
            }
            extracted.add(field);
            extracted.add(value);
        }
        return extracted != null ? context.with(EXTRACTED_KEY_VALUES, extracted) : context;
    }

    public String toString() {
        return "PassThroughPropagator{fields=" + this.fields + "}";
    }
}

