/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Value;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.logs.Severity;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public interface LogRecordBuilder {
    public LogRecordBuilder setTimestamp(long var1, TimeUnit var3);

    public LogRecordBuilder setTimestamp(Instant var1);

    public LogRecordBuilder setObservedTimestamp(long var1, TimeUnit var3);

    public LogRecordBuilder setObservedTimestamp(Instant var1);

    public LogRecordBuilder setContext(Context var1);

    public LogRecordBuilder setSeverity(Severity var1);

    public LogRecordBuilder setSeverityText(String var1);

    public LogRecordBuilder setBody(String var1);

    default public LogRecordBuilder setBody(Value<?> body) {
        this.setBody(body.asString());
        return this;
    }

    default public LogRecordBuilder setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach((attributeKey, value) -> this.setAttribute((AttributeKey)attributeKey, (Object)value));
        return this;
    }

    public <T> LogRecordBuilder setAttribute(AttributeKey<T> var1, @Nullable T var2);

    default public LogRecordBuilder setAttribute(String key, @Nullable String value) {
        return this.setAttribute(AttributeKey.stringKey(key), value);
    }

    default public LogRecordBuilder setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey(key), Long.valueOf(value));
    }

    default public LogRecordBuilder setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    default public LogRecordBuilder setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    default public LogRecordBuilder setAttribute(String key, int value) {
        return this.setAttribute(key, (long)value);
    }

    default public LogRecordBuilder setEventName(String eventName) {
        return this;
    }

    public void emit();
}

