/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

final class MultiTextMapPropagator
implements TextMapPropagator {
    private final TextMapPropagator[] textMapPropagators;
    private final Collection<String> allFields;

    MultiTextMapPropagator(TextMapPropagator ... textMapPropagators) {
        this(Arrays.asList(textMapPropagators));
    }

    MultiTextMapPropagator(List<TextMapPropagator> textMapPropagators) {
        this.textMapPropagators = new TextMapPropagator[textMapPropagators.size()];
        textMapPropagators.toArray(this.textMapPropagators);
        this.allFields = Collections.unmodifiableList(MultiTextMapPropagator.getAllFields(this.textMapPropagators));
    }

    @Override
    public Collection<String> fields() {
        return this.allFields;
    }

    private static List<String> getAllFields(TextMapPropagator[] textPropagators) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (TextMapPropagator textPropagator : textPropagators) {
            fields.addAll(textPropagator.fields());
        }
        return new ArrayList<String>(fields);
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        for (TextMapPropagator textPropagator : this.textMapPropagators) {
            textPropagator.inject(context, carrier, setter);
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        for (TextMapPropagator textPropagator : this.textMapPropagators) {
            context = textPropagator.extract(context, carrier, getter);
        }
        return context;
    }

    public String toString() {
        return "MultiTextMapPropagator{textMapPropagators=" + Arrays.toString(this.textMapPropagators) + '}';
    }
}

