/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ExtendedAttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ExtendedAttributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.internal.InternalExtendedAttributeKeyImpl;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.ArrayAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.ExtendedAttributeKeyValueStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.IntAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.KeyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.StringAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.proto.logs.v1.internal.LogRecord;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.data.internal.ExtendedLogRecordData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;

public class IncubatingUtil {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final KeyValueMarshaler[] EMPTY_REPEATED = new KeyValueMarshaler[0];

    private IncubatingUtil() {
    }

    public static KeyValueMarshaler[] createdExtendedAttributesMarhsalers(LogRecordData logRecordData) {
        return IncubatingUtil.createForExtendedAttributes(IncubatingUtil.getExtendedAttributes(logRecordData));
    }

    public static int extendedAttributesSize(LogRecordData logRecordData) {
        return IncubatingUtil.getExtendedAttributes(logRecordData).size();
    }

    private static KeyValueMarshaler[] createForExtendedAttributes(ExtendedAttributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final KeyValueMarshaler[] marshalers = new KeyValueMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<ExtendedAttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(ExtendedAttributeKey<?> attributeKey, Object o) {
                marshalers[this.index++] = IncubatingUtil.create(attributeKey, o);
            }
        });
        return marshalers;
    }

    private static KeyValueMarshaler create(ExtendedAttributeKey<?> attributeKey, Object value) {
        byte[] keyUtf8 = attributeKey.getKey().isEmpty() ? EMPTY_BYTES : (attributeKey instanceof InternalExtendedAttributeKeyImpl ? ((InternalExtendedAttributeKeyImpl)attributeKey).getKeyUtf8() : attributeKey.getKey().getBytes(StandardCharsets.UTF_8));
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueMarshaler(keyUtf8, StringAnyValueMarshaler.create((String)value));
            }
            case LONG: {
                return new KeyValueMarshaler(keyUtf8, IntAnyValueMarshaler.create((Long)value));
            }
            case BOOLEAN: {
                return new KeyValueMarshaler(keyUtf8, BoolAnyValueMarshaler.create((Boolean)value));
            }
            case DOUBLE: {
                return new KeyValueMarshaler(keyUtf8, DoubleAnyValueMarshaler.create((Double)value));
            }
            case STRING_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createString((List)value));
            }
            case LONG_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createInt((List)value));
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createBool((List)value));
            }
            case DOUBLE_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createDouble((List)value));
            }
            case EXTENDED_ATTRIBUTES: {
                return new KeyValueMarshaler(keyUtf8, new KeyValueListAnyValueMarshaler(new KeyValueListAnyValueMarshaler.KeyValueListMarshaler(IncubatingUtil.createForExtendedAttributes((ExtendedAttributes)value))));
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    public static int sizeExtendedAttributes(LogRecordData log, MarshalerContext context) {
        return ExtendedAttributeKeyValueStatelessMarshaler.sizeExtendedAttributes(LogRecord.ATTRIBUTES, IncubatingUtil.getExtendedAttributes(log), context);
    }

    public static void serializeExtendedAttributes(Serializer output, LogRecordData log, MarshalerContext context) throws IOException {
        ExtendedAttributeKeyValueStatelessMarshaler.serializeExtendedAttributes(output, LogRecord.ATTRIBUTES, IncubatingUtil.getExtendedAttributes(log), context);
    }

    private static ExtendedAttributes getExtendedAttributes(LogRecordData logRecordData) {
        if (!(logRecordData instanceof ExtendedLogRecordData)) {
            throw new IllegalArgumentException("logRecordData must be ExtendedLogRecordData");
        }
        return ((ExtendedLogRecordData)logRecordData).getExtendedAttributes();
    }
}

