/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.StatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.StatelessMarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.metrics.ExemplarStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.proto.metrics.v1.internal.HistogramDataPoint;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.HistogramPointData;
import java.io.IOException;

final class HistogramDataPointStatelessMarshaler
implements StatelessMarshaler<HistogramPointData> {
    static final HistogramDataPointStatelessMarshaler INSTANCE = new HistogramDataPointStatelessMarshaler();

    private HistogramDataPointStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, HistogramPointData point, MarshalerContext context) throws IOException {
        output.serializeFixed64(HistogramDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        output.serializeFixed64(HistogramDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        output.serializeFixed64(HistogramDataPoint.COUNT, point.getCount());
        output.serializeDoubleOptional(HistogramDataPoint.SUM, point.getSum());
        if (point.hasMin()) {
            output.serializeDoubleOptional(HistogramDataPoint.MIN, point.getMin());
        }
        if (point.hasMax()) {
            output.serializeDoubleOptional(HistogramDataPoint.MAX, point.getMax());
        }
        output.serializeRepeatedFixed64(HistogramDataPoint.BUCKET_COUNTS, point.getCounts());
        output.serializeRepeatedDouble(HistogramDataPoint.EXPLICIT_BOUNDS, point.getBoundaries());
        output.serializeRepeatedMessageWithContext(HistogramDataPoint.EXEMPLARS, point.getExemplars(), ExemplarStatelessMarshaler.INSTANCE, context);
        output.serializeRepeatedMessageWithContext(HistogramDataPoint.ATTRIBUTES, point.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }

    @Override
    public int getBinarySerializedSize(HistogramPointData point, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(HistogramDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64(HistogramDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        size += MarshalerUtil.sizeFixed64(HistogramDataPoint.COUNT, point.getCount());
        size += MarshalerUtil.sizeDoubleOptional(HistogramDataPoint.SUM, point.getSum());
        if (point.hasMin()) {
            size += MarshalerUtil.sizeDoubleOptional(HistogramDataPoint.MIN, point.getMin());
        }
        if (point.hasMax()) {
            size += MarshalerUtil.sizeDoubleOptional(HistogramDataPoint.MAX, point.getMax());
        }
        size += MarshalerUtil.sizeRepeatedFixed64(HistogramDataPoint.BUCKET_COUNTS, point.getCounts());
        size += MarshalerUtil.sizeRepeatedDouble(HistogramDataPoint.EXPLICIT_BOUNDS, point.getBoundaries());
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(HistogramDataPoint.EXEMPLARS, point.getExemplars(), ExemplarStatelessMarshaler.INSTANCE, context);
        return size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(HistogramDataPoint.ATTRIBUTES, point.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }
}

