/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.trace.TraceFlags;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.trace.TraceState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.KeyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.traces.SpanFlags;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.traces.SpanMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.proto.trace.v1.internal.Span;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.data.LinkData;
import java.io.IOException;
import java.util.List;

final class SpanLinkMarshaler
extends MarshalerWithSize {
    private static final SpanLinkMarshaler[] EMPTY = new SpanLinkMarshaler[0];
    private final String traceId;
    private final String spanId;
    private final byte[] traceStateUtf8;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;
    private final TraceFlags traceFlags;
    private final boolean isLinkContextRemote;

    static SpanLinkMarshaler[] createRepeated(List<LinkData> links) {
        if (links.isEmpty()) {
            return EMPTY;
        }
        SpanLinkMarshaler[] result = new SpanLinkMarshaler[links.size()];
        int pos = 0;
        for (LinkData link : links) {
            result[pos++] = SpanLinkMarshaler.create(link);
        }
        return result;
    }

    static SpanLinkMarshaler create(LinkData link) {
        byte[] traceStateUtf8 = SpanLinkMarshaler.encodeSpanLinkTraceState(link);
        return new SpanLinkMarshaler(link.getSpanContext().getTraceId(), link.getSpanContext().getSpanId(), link.getSpanContext().getTraceFlags(), traceStateUtf8, KeyValueMarshaler.createForAttributes(link.getAttributes()), link.getTotalAttributeCount() - link.getAttributes().size(), link.getSpanContext().isRemote());
    }

    private SpanLinkMarshaler(String traceId, String spanId, TraceFlags traceFlags, byte[] traceStateUtf8, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount, boolean isLinkContextRemote) {
        super(SpanLinkMarshaler.calculateSize(traceId, spanId, traceFlags, traceStateUtf8, attributeMarshalers, droppedAttributesCount, isLinkContextRemote));
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceFlags = traceFlags;
        this.traceStateUtf8 = traceStateUtf8;
        this.attributeMarshalers = attributeMarshalers;
        this.droppedAttributesCount = droppedAttributesCount;
        this.isLinkContextRemote = isLinkContextRemote;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeTraceId(Span.Link.TRACE_ID, this.traceId);
        output.serializeSpanId(Span.Link.SPAN_ID, this.spanId);
        output.serializeString(Span.Link.TRACE_STATE, this.traceStateUtf8);
        output.serializeRepeatedMessage(Span.Link.ATTRIBUTES, this.attributeMarshalers);
        output.serializeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
        output.serializeFixed32(Span.Link.FLAGS, SpanFlags.withParentIsRemoteFlags(this.traceFlags, this.isLinkContextRemote));
    }

    private static int calculateSize(String traceId, String spanId, TraceFlags flags, byte[] traceStateUtf8, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount, boolean isLinkContextRemote) {
        int size = 0;
        size += MarshalerUtil.sizeTraceId(Span.Link.TRACE_ID, traceId);
        size += MarshalerUtil.sizeSpanId(Span.Link.SPAN_ID, spanId);
        size += MarshalerUtil.sizeBytes(Span.Link.TRACE_STATE, traceStateUtf8);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.Link.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        size += MarshalerUtil.sizeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        return size += MarshalerUtil.sizeFixed32(Span.Link.FLAGS, SpanFlags.withParentIsRemoteFlags(flags, isLinkContextRemote));
    }

    static byte[] encodeSpanLinkTraceState(LinkData link) {
        TraceState traceState = link.getSpanContext().getTraceState();
        return SpanMarshaler.encodeTraceState(traceState);
    }
}

