/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.ExporterBuilderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.internal.OtlpConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.MetricExporter;

public class OtlpMetricExporterProvider
implements ConfigurableMetricExporterProvider {
    @Override
    public MetricExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpMetricExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            ExporterBuilderUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            ExporterBuilderUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcMetricExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            ExporterBuilderUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            ExporterBuilderUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpMetricExporterBuilder httpBuilder() {
        return OtlpHttpMetricExporter.builder();
    }

    OtlpGrpcMetricExporterBuilder grpcBuilder() {
        return OtlpGrpcMetricExporter.builder();
    }
}

