/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.sender.okhttp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.okhttp3.Interceptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.okhttp3.Response;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class RetryInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(RetryInterceptor.class.getName());
    private final RetryPolicy retryPolicy;
    private final Function<Response, Boolean> isRetryable;
    private final Predicate<IOException> retryExceptionPredicate;
    private final Sleeper sleeper;
    private final Supplier<Double> randomJitter;

    public RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable) {
        this(retryPolicy, isRetryable, retryPolicy.getRetryExceptionPredicate() == null ? RetryInterceptor::isRetryableException : retryPolicy.getRetryExceptionPredicate(), TimeUnit.NANOSECONDS::sleep, () -> ThreadLocalRandom.current().nextDouble(0.8, 1.2));
    }

    RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable, Predicate<IOException> retryExceptionPredicate, Sleeper sleeper, Supplier<Double> randomJitter) {
        this.retryPolicy = retryPolicy;
        this.isRetryable = isRetryable;
        this.retryExceptionPredicate = retryExceptionPredicate;
        this.sleeper = sleeper;
        this.randomJitter = randomJitter;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = null;
        IOException exception = null;
        int attempt = 0;
        long nextBackoffNanos = this.retryPolicy.getInitialBackoff().toNanos();
        do {
            if (attempt > 0) {
                long currentBackoffNanos = Math.min(nextBackoffNanos, this.retryPolicy.getMaxBackoff().toNanos());
                long backoffNanos = (long)(this.randomJitter.get() * (double)currentBackoffNanos);
                nextBackoffNanos = (long)((double)currentBackoffNanos * this.retryPolicy.getBackoffMultiplier());
                try {
                    this.sleeper.sleep(backoffNanos);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (response != null) {
                    response.close();
                }
                exception = null;
            }
            try {
                response = chain.proceed(chain.request());
                if (response != null) {
                    boolean retryable = Boolean.TRUE.equals(this.isRetryable.apply(response));
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Attempt " + attempt + " returned " + (retryable ? "retryable" : "non-retryable") + " response: " + RetryInterceptor.responseStringRepresentation(response));
                    }
                    if (!retryable) {
                        return response;
                    }
                    continue;
                }
                throw new NullPointerException("response cannot be null.");
            }
            catch (IOException e) {
                exception = e;
                response = null;
                boolean retryable = this.retryExceptionPredicate.test(exception);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Attempt " + attempt + " failed with " + (retryable ? "retryable" : "non-retryable") + " exception", exception);
                }
                if (retryable) continue;
                throw exception;
            }
        } while (++attempt < this.retryPolicy.getMaxAttempts());
        if (response != null) {
            return response;
        }
        throw exception;
    }

    private static String responseStringRepresentation(Response response) {
        StringJoiner joiner = new StringJoiner(",", "Response{", "}");
        joiner.add("code=" + response.code());
        joiner.add("headers=" + response.headers().toMultimap().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.join((CharSequence)",", (Iterable)entry.getValue())).collect(Collectors.joining(",", "[", "]")));
        return joiner.toString();
    }

    boolean shouldRetryOnException(IOException e) {
        return this.retryExceptionPredicate.test(e);
    }

    static boolean isRetryableException(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof ConnectException) {
            return true;
        }
        if (e instanceof UnknownHostException) {
            return true;
        }
        return e instanceof SocketException;
    }

    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }
}

