/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter.ErrorCauseExtractor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

final class DefaultErrorCauseExtractor
implements ErrorCauseExtractor {
    static final ErrorCauseExtractor INSTANCE = new DefaultErrorCauseExtractor();
    @Nullable
    private static final Class<?> COMPLETION_EXCEPTION_CLASS = DefaultErrorCauseExtractor.getCompletionExceptionClass();

    @Override
    public Throwable extract(Throwable error) {
        if (error.getCause() != null && (error instanceof ExecutionException || DefaultErrorCauseExtractor.isInstanceOfCompletionException(error) || error instanceof InvocationTargetException || error instanceof UndeclaredThrowableException)) {
            return this.extract(error.getCause());
        }
        return error;
    }

    private static boolean isInstanceOfCompletionException(Throwable error) {
        return COMPLETION_EXCEPTION_CLASS != null && COMPLETION_EXCEPTION_CLASS.isInstance(error);
    }

    @Nullable
    private static Class<?> getCompletionExceptionClass() {
        try {
            return Class.forName("java.util.concurrent.CompletionException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private DefaultErrorCauseExtractor() {
    }
}

