/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal.cache.Cache;

public final class ClassNames {
    private static final Cache<Class<?>, String> simpleNames = Cache.weak();

    public static String simpleName(Class<?> type) {
        return simpleNames.computeIfAbsent(type, ClassNames::computeSimpleName);
    }

    private static String computeSimpleName(Class<?> type) {
        String pkgName;
        String className = type.getName();
        if (!type.isAnonymousClass()) {
            String simpleName = type.getSimpleName();
            if (!simpleName.isEmpty()) {
                return simpleName;
            }
            int index = className.indexOf(47);
            if (index != -1) {
                className = className.substring(0, index);
            }
        }
        if (type.getPackage() != null && !(pkgName = type.getPackage().getName()).isEmpty()) {
            className = className.substring(pkgName.length() + 1);
        }
        return className;
    }

    private ClassNames() {
    }
}

