/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal.cache.Cache;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.util.VirtualField;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class RuntimeVirtualFieldSupplier {
    private static final Logger logger = Logger.getLogger(RuntimeVirtualFieldSupplier.class.getName());
    private static final VirtualFieldSupplier DEFAULT;
    private static volatile VirtualFieldSupplier instance;

    public static void set(VirtualFieldSupplier virtualFieldSupplier) {
        if (instance != DEFAULT) {
            logger.warning("Runtime VirtualField supplier has already been set up, further set() calls are ignored");
            return;
        }
        instance = virtualFieldSupplier;
    }

    public static VirtualFieldSupplier get() {
        return instance;
    }

    private RuntimeVirtualFieldSupplier() {
    }

    static {
        instance = DEFAULT = new CacheBasedVirtualFieldSupplier();
    }

    public static interface VirtualFieldSupplier {
        public <U extends T, V extends F, T, F> VirtualField<U, V> find(Class<T> var1, Class<F> var2);
    }

    private static final class CacheBasedVirtualFieldSupplier
    implements VirtualFieldSupplier {
        private final Cache<Class<?>, Cache<Class<?>, VirtualField<?, ?>>> ownerToFieldToImplementationMap = Cache.weak();

        private CacheBasedVirtualFieldSupplier() {
        }

        @Override
        public <U extends T, V extends F, T, F> VirtualField<U, V> find(Class<T> type, Class<F> fieldType) {
            return this.ownerToFieldToImplementationMap.computeIfAbsent(type, c -> Cache.weak()).computeIfAbsent(fieldType, c -> new CacheBasedVirtualField());
        }
    }

    private static final class CacheBasedVirtualField<T, F>
    extends VirtualField<T, F> {
        private final Cache<T, F> cache = Cache.weak();

        private CacheBasedVirtualField() {
        }

        @Override
        @Nullable
        public F get(T object) {
            return this.cache.get(object);
        }

        @Override
        public void set(T object, @Nullable F fieldValue) {
            if (fieldValue == null) {
                this.cache.remove(object);
            } else {
                this.cache.put(object, fieldValue);
            }
        }
    }
}

