/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter.SpanNameExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal.Experimental;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal.HttpConstants;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpSpanNameExtractorBuilder<REQUEST> {
    @Nullable
    final HttpClientAttributesGetter<REQUEST, ?> clientGetter;
    @Nullable
    final HttpServerAttributesGetter<REQUEST, ?> serverGetter;
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;
    Function<REQUEST, String> urlTemplateExtractor = unused -> null;

    public HttpSpanNameExtractorBuilder(@Nullable HttpClientAttributesGetter<REQUEST, ?> clientGetter, @Nullable HttpServerAttributesGetter<REQUEST, ?> serverGetter) {
        this.clientGetter = clientGetter;
        this.serverGetter = serverGetter;
    }

    @CanIgnoreReturnValue
    public HttpSpanNameExtractorBuilder<REQUEST> setKnownMethods(Collection<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpSpanNameExtractorBuilder<REQUEST> setKnownMethods(Set<String> knownMethods) {
        return this.setKnownMethods((Collection<String>)knownMethods);
    }

    public SpanNameExtractor<REQUEST> build() {
        HashSet<String> knownMethods = new HashSet<String>(this.knownMethods);
        return this.clientGetter != null ? new HttpSpanNameExtractor.Client<REQUEST>(this.clientGetter, knownMethods, this.urlTemplateExtractor) : new HttpSpanNameExtractor.Server<REQUEST>(Objects.requireNonNull(this.serverGetter), knownMethods);
    }

    static {
        Experimental.internalSetUrlTemplateExtractor((builder, urlTemplateExtractor) -> {
            builder.urlTemplateExtractor = urlTemplateExtractor;
        });
    }
}

