/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HostIdResource {
    private static final Logger logger = Logger.getLogger(HostIdResource.class.getName());
    static final AttributeKey<String> HOST_ID = AttributeKey.stringKey("host.id");
    public static final String REGISTRY_QUERY = "reg query HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography /v MachineGuid";
    private static final HostIdResource INSTANCE = new HostIdResource(HostIdResource::getOsTypeSystemProperty, HostIdResource::readMachineIdFile, HostIdResource::queryWindowsRegistry);
    private final Supplier<String> getOsType;
    private final Function<Path, List<String>> machineIdReader;
    private final Supplier<List<String>> queryWindowsRegistry;

    HostIdResource(Supplier<String> getOsType, Function<Path, List<String>> machineIdReader, Supplier<List<String>> queryWindowsRegistry) {
        this.getOsType = getOsType;
        this.machineIdReader = machineIdReader;
        this.queryWindowsRegistry = queryWindowsRegistry;
    }

    public static Resource get() {
        return INSTANCE.createResource();
    }

    Resource createResource() {
        if (this.runningWindows()) {
            return this.readWindowsGuid();
        }
        if (this.runningLinux()) {
            return this.readLinuxMachineId();
        }
        logger.log(Level.FINE, "Unsupported OS type: {0}", this.getOsType.get());
        return Resource.empty();
    }

    private boolean runningLinux() {
        return this.getOsType.get().toLowerCase(Locale.ROOT).equals("linux");
    }

    private boolean runningWindows() {
        return this.getOsType.get().startsWith("Windows");
    }

    private static String getOsTypeSystemProperty() {
        return System.getProperty("os.name", "");
    }

    private Resource readLinuxMachineId() {
        Path path = FileSystems.getDefault().getPath("/etc/machine-id", new String[0]);
        List<String> lines = this.machineIdReader.apply(path);
        if (lines.isEmpty()) {
            return Resource.empty();
        }
        return Resource.create(Attributes.of(HOST_ID, lines.get(0)));
    }

    private static List<String> readMachineIdFile(Path path) {
        try {
            List<String> lines = Files.readAllLines(path);
            if (lines.isEmpty()) {
                logger.fine("Failed to read /etc/machine-id: empty file");
            }
            return lines;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Failed to read /etc/machine-id", e);
            return Collections.emptyList();
        }
    }

    private Resource readWindowsGuid() {
        List<String> lines = this.queryWindowsRegistry.get();
        for (String line : lines) {
            String[] parts;
            if (!line.contains("MachineGuid") || (parts = line.trim().split("\\s+")).length != 3) continue;
            return Resource.create(Attributes.of(HOST_ID, parts[2]));
        }
        logger.fine("Failed to read Windows registry: No MachineGuid found in output: " + lines);
        return Resource.empty();
    }

    private static List<String> queryWindowsRegistry() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", REGISTRY_QUERY);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            List<String> output = HostIdResource.getProcessOutput(process);
            int exitedValue = process.waitFor();
            if (exitedValue != 0) {
                logger.fine("Failed to read Windows registry. Exit code: " + exitedValue + " Output: " + String.join((CharSequence)"\n", output));
                return Collections.emptyList();
            }
            return output;
        }
        catch (IOException | InterruptedException e) {
            logger.log(Level.FINE, "Failed to read Windows registry", e);
            return Collections.emptyList();
        }
    }

    private static List<String> getProcessOutput(Process process) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader processOutputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String readLine;
            while ((readLine = processOutputReader.readLine()) != null) {
                result.add(readLine);
            }
        }
        return result;
    }
}

