/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.internal.shaded.AbstractWeakConcurrentMap;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.internal.shaded.WeakConcurrentMap;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.ReadWriteSpan;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.ReadableSpan;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.SpanProcessor;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LeakDetectingSpanProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(LeakDetectingSpanProcessor.class.getName());
    private final PendingSpans pendingSpans;

    public static LeakDetectingSpanProcessor create() {
        return new LeakDetectingSpanProcessor((message, throwable) -> logger.log(Level.WARNING, "Span garbage collected before being ended.", (Throwable)throwable));
    }

    LeakDetectingSpanProcessor(BiConsumer<String, Throwable> reporter) {
        this.pendingSpans = PendingSpans.create(reporter);
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
        CallerStackTrace caller = new CallerStackTrace(span);
        StackTraceElement[] stackTrace = caller.getStackTrace();
        caller.setStackTrace(Arrays.copyOfRange(stackTrace, Math.min(3, stackTrace.length), stackTrace.length));
        this.pendingSpans.put(span, caller);
    }

    @Override
    public boolean isStartRequired() {
        return true;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        ((CallerStackTrace)this.pendingSpans.remove((Object)span)).ended = true;
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    private static AssertionError callerError(CallerStackTrace caller) {
        AssertionError toThrow = new AssertionError((Object)("Span garbage collected before being ended. Thread: [" + caller.threadName + "] started span : " + caller.spanInformation + " here:"));
        ((Throwable)((Object)toThrow)).setStackTrace(caller.getStackTrace());
        return toThrow;
    }

    private static class CallerStackTrace
    extends Throwable {
        private static final long serialVersionUID = 1234567896L;
        final String threadName = Thread.currentThread().getName();
        final String spanInformation;
        volatile boolean ended;

        CallerStackTrace(ReadableSpan span) {
            super("Thread [" + Thread.currentThread().getName() + "] started span : " + span + " here:");
            this.spanInformation = span.getName() + " [" + span.getSpanContext() + "]";
        }
    }

    private static class PendingSpans
    extends WeakConcurrentMap<ReadableSpan, CallerStackTrace> {
        private final ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<ReadableSpan>, CallerStackTrace> map;
        private final BiConsumer<String, Throwable> reporter;

        private static PendingSpans create(BiConsumer<String, Throwable> reporter) {
            PendingSpans pendingSpans = new PendingSpans(new ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<ReadableSpan>, CallerStackTrace>(), reporter);
            Thread thread2 = new Thread(pendingSpans);
            thread2.setName("weak-ref-cleaner-leakingspandetector");
            thread2.setPriority(1);
            thread2.setDaemon(true);
            thread2.start();
            return pendingSpans;
        }

        private PendingSpans(ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<ReadableSpan>, CallerStackTrace> map, BiConsumer<String, Throwable> reporter) {
            super(false, false, map);
            this.map = map;
            this.reporter = reporter;
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Reference gcdReference = this.remove();
                    CallerStackTrace caller = this.map.remove(gcdReference);
                    if (caller == null || caller.ended) continue;
                    this.reporter.accept("Span garbage collected before being ended.", (Throwable)((Object)LeakDetectingSpanProcessor.callerError(caller)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

