/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.logs.LogRecordBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.logs.Logger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.logs.LoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.IncubatingUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.LoggerSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.SdkLogRecordBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.internal.LoggerConfig;

class SdkLogger
implements Logger {
    private static final Logger NOOP_LOGGER = LoggerProvider.noop().get("noop");
    private static final boolean INCUBATOR_AVAILABLE;
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    protected boolean loggerEnabled;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.loggerEnabled = loggerConfig.isEnabled();
    }

    static SdkLogger create(LoggerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedLogger(sharedState, instrumentationScopeInfo, loggerConfig) : new SdkLogger(sharedState, instrumentationScopeInfo, loggerConfig);
    }

    @Override
    public LogRecordBuilder logRecordBuilder() {
        if (this.loggerEnabled) {
            return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo) : new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
        }
        return NOOP_LOGGER.logRecordBuilder();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public boolean isEnabled() {
        return this.loggerEnabled;
    }

    void updateLoggerConfig(LoggerConfig loggerConfig) {
        this.loggerEnabled = loggerConfig.isEnabled();
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.logs.ExtendedDefaultLoggerProvider");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
    }
}

