/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.pushgateway;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

class DefaultJobLabelDetector {
    DefaultJobLabelDetector() {
    }

    static String getDefaultJobLabel() {
        Path jarPath = DefaultJobLabelDetector.getJarPathFromSunCommandLine();
        if (jarPath == null) {
            return "unknown_job";
        }
        return DefaultJobLabelDetector.getServiceName(jarPath);
    }

    private static String getServiceName(Path jarPath) {
        String jarName = jarPath.getFileName().toString();
        int dotIndex = jarName.lastIndexOf(".");
        return dotIndex == -1 ? jarName : jarName.substring(0, dotIndex);
    }

    private static Path getJarPathFromSunCommandLine() {
        Path path;
        String programArguments = System.getProperty("sun.java.command");
        if (programArguments == null) {
            return null;
        }
        int next = 0;
        do {
            int nextSpace;
            if ((nextSpace = programArguments.indexOf(32, next)) == -1) {
                return DefaultJobLabelDetector.pathIfExists(programArguments);
            }
            path = DefaultJobLabelDetector.pathIfExists(programArguments.substring(0, nextSpace));
            next = nextSpace + 1;
        } while (path == null);
        return path;
    }

    private static Path pathIfExists(String programArguments) {
        Path candidate;
        try {
            candidate = Paths.get(programArguments, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        return Files.isRegularFile(candidate, new LinkOption[0]) ? candidate : null;
    }
}

