/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.pushgateway;

import io.prometheus.metrics.config.ExporterPushgatewayProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.config.PrometheusPropertiesException;
import io.prometheus.metrics.exporter.pushgateway.DefaultHttpConnectionFactory;
import io.prometheus.metrics.exporter.pushgateway.DefaultJobLabelDetector;
import io.prometheus.metrics.exporter.pushgateway.Format;
import io.prometheus.metrics.exporter.pushgateway.HttpConnectionFactory;
import io.prometheus.metrics.exporter.pushgateway.Scheme;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.expositionformats.PrometheusProtobufWriter;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import io.prometheus.metrics.model.registry.Collector;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class PushGateway {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private final URL url;
    private final ExpositionFormatWriter writer;
    private final boolean prometheusTimestampsInMs;
    private final Map<String, String> requestHeaders;
    private final PrometheusRegistry registry;
    private final HttpConnectionFactory connectionFactory;

    private PushGateway(PrometheusRegistry registry, Format format, URL url, HttpConnectionFactory connectionFactory, Map<String, String> requestHeaders, boolean prometheusTimestampsInMs) {
        this.registry = registry;
        this.url = url;
        this.requestHeaders = Collections.unmodifiableMap(new HashMap<String, String>(requestHeaders));
        this.connectionFactory = connectionFactory;
        this.prometheusTimestampsInMs = prometheusTimestampsInMs;
        this.writer = this.getWriter(format);
        if (!this.writer.isAvailable()) {
            throw new RuntimeException(this.writer.getClass() + " is not available");
        }
    }

    private ExpositionFormatWriter getWriter(Format format) {
        if (format == Format.PROMETHEUS_TEXT) {
            return PrometheusTextFormatWriter.builder().setTimestampsInMs(this.prometheusTimestampsInMs).build();
        }
        return new PrometheusProtobufWriter();
    }

    public void push() throws IOException {
        this.doRequest(this.registry, "PUT");
    }

    public void push(Collector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "PUT");
    }

    public void push(MultiCollector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "PUT");
    }

    public void pushAdd() throws IOException {
        this.doRequest(this.registry, "POST");
    }

    public void pushAdd(Collector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "POST");
    }

    public void pushAdd(MultiCollector collector) throws IOException {
        PrometheusRegistry registry = new PrometheusRegistry();
        registry.register(collector);
        this.doRequest(registry, "POST");
    }

    public void delete() throws IOException {
        this.doRequest(null, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(PrometheusRegistry registry, String method) throws IOException {
        try {
            HttpURLConnection connection = this.connectionFactory.create(this.url);
            this.requestHeaders.forEach(connection::setRequestProperty);
            connection.setRequestProperty("Content-Type", this.writer.getContentType());
            if (!method.equals("DELETE")) {
                connection.setDoOutput(true);
            }
            connection.setRequestMethod(method);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            try {
                int response;
                if (!method.equals("DELETE")) {
                    OutputStream outputStream = connection.getOutputStream();
                    this.writer.write(outputStream, registry.scrape());
                    outputStream.flush();
                    outputStream.close();
                }
                if ((response = connection.getResponseCode()) / 100 != 2) {
                    String errorMessage;
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        String errBody = PushGateway.readFromStream(errorStream);
                        errorMessage = "Response code from " + this.url + " was " + response + ", response body: " + errBody;
                    } else {
                        errorMessage = "Response code from " + this.url + " was " + response;
                    }
                    throw new IOException(errorMessage);
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            String baseUrl = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                baseUrl = baseUrl + ":" + this.url.getPort();
            }
            throw new IOException("Failed to push metrics to the Prometheus Pushgateway on " + baseUrl + ": " + e.getMessage(), e);
        }
    }

    private static String readFromStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static Builder builder() {
        return PushGateway.builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static class Builder {
        private final PrometheusProperties config;
        private Format format;
        private String address;
        private Scheme scheme;
        private String job;
        private boolean prometheusTimestampsInMs;
        private final Map<String, String> requestHeaders = new HashMap<String, String>();
        private PrometheusRegistry registry = PrometheusRegistry.defaultRegistry;
        private HttpConnectionFactory connectionFactory = new DefaultHttpConnectionFactory();
        private Map<String, String> groupingKey = new TreeMap<String, String>();

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public Builder format(Format format) {
            if (format == null) {
                throw new NullPointerException();
            }
            this.format = format;
            return this;
        }

        public Builder address(String address) {
            if (address == null) {
                throw new NullPointerException();
            }
            this.address = address;
            return this;
        }

        public Builder basicAuth(String user, String password) {
            if (user == null || password == null) {
                throw new NullPointerException();
            }
            byte[] credentialsBytes = (user + ":" + password).getBytes(StandardCharsets.UTF_8);
            String encoded = Base64.getEncoder().encodeToString(credentialsBytes);
            this.requestHeaders.put("Authorization", String.format("Basic %s", encoded));
            return this;
        }

        public Builder bearerToken(String token) {
            if (token == null) {
                throw new NullPointerException();
            }
            this.requestHeaders.put("Authorization", String.format("Bearer %s", token));
            return this;
        }

        public Builder scheme(Scheme scheme) {
            if (scheme == null) {
                throw new NullPointerException();
            }
            this.scheme = scheme;
            return this;
        }

        public Builder connectionFactory(HttpConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException();
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder job(String job) {
            if (job == null) {
                throw new NullPointerException();
            }
            this.job = job;
            return this;
        }

        public Builder groupingKey(String name, String value) {
            if (name == null || value == null) {
                throw new NullPointerException();
            }
            this.groupingKey.put(name, value);
            return this;
        }

        public Builder instanceIpGroupingKey() throws UnknownHostException {
            return this.groupingKey("instance", InetAddress.getLocalHost().getHostAddress());
        }

        public Builder registry(PrometheusRegistry registry) {
            if (registry == null) {
                throw new NullPointerException();
            }
            this.registry = registry;
            return this;
        }

        public Builder prometheusTimestampsInMs(boolean prometheusTimestampsInMs) {
            this.prometheusTimestampsInMs = prometheusTimestampsInMs;
            return this;
        }

        private boolean getPrometheusTimestampsInMs() {
            return this.config.getExporterProperties().getPrometheusTimestampsInMs() || this.prometheusTimestampsInMs;
        }

        private Scheme getScheme(ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getScheme() != null) {
                return Scheme.valueOf(properties.getScheme());
            }
            if (this.scheme != null) {
                return this.scheme;
            }
            return Scheme.HTTP;
        }

        private String getAddress(ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getAddress() != null) {
                return properties.getAddress();
            }
            if (this.address != null) {
                return this.address;
            }
            return "localhost:9091";
        }

        private String getJob(ExporterPushgatewayProperties properties) {
            if (properties != null && properties.getJob() != null) {
                return properties.getJob();
            }
            if (this.job != null) {
                return this.job;
            }
            return DefaultJobLabelDetector.getDefaultJobLabel();
        }

        private Format getFormat() {
            if (this.format != null) {
                return this.format;
            }
            return Format.PROMETHEUS_PROTOBUF;
        }

        private URL makeUrl(ExporterPushgatewayProperties properties) throws UnsupportedEncodingException, MalformedURLException {
            String url = (Object)((Object)this.getScheme(properties)) + "://" + this.getAddress(properties) + "/metrics/";
            String job = this.getJob(properties);
            url = job.contains("/") ? url + "job@base64/" + this.base64url(job) : url + "job/" + URLEncoder.encode(job, "UTF-8");
            if (this.groupingKey != null) {
                for (Map.Entry<String, String> entry : this.groupingKey.entrySet()) {
                    if (entry.getValue().isEmpty()) {
                        url = url + "/" + entry.getKey() + "@base64/=";
                        continue;
                    }
                    if (entry.getValue().contains("/")) {
                        url = url + "/" + entry.getKey() + "@base64/" + this.base64url(entry.getValue());
                        continue;
                    }
                    url = url + "/" + entry.getKey() + "/" + URLEncoder.encode(entry.getValue(), "UTF-8");
                }
            }
            return URI.create(url).normalize().toURL();
        }

        private String base64url(String v) {
            return Base64.getEncoder().encodeToString(v.getBytes(StandardCharsets.UTF_8)).replace("+", "-").replace("/", "_");
        }

        public PushGateway build() {
            ExporterPushgatewayProperties properties = this.config == null ? null : this.config.getExporterPushgatewayProperties();
            try {
                return new PushGateway(this.registry, this.getFormat(), this.makeUrl(properties), this.connectionFactory, this.requestHeaders, this.getPrometheusTimestampsInMs());
            }
            catch (MalformedURLException e) {
                throw new PrometheusPropertiesException(this.address + ": Invalid address. Expecting <host>:<port>");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

