/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.instrumentation.dropwizard5.labels;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MapperConfig {
    private static final String METRIC_PART_REGEX = "[a-zA-Z_0-9](-?[a-zA-Z0-9_])+";
    static final String METRIC_GLOB_REGEX = "^(\\*\\.|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+\\.)+(\\*|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+)$";
    private static final String LABEL_REGEX = "^[a-zA-Z_][a-zA-Z0-9_]+$";
    private static final Pattern MATCH_EXPRESSION_PATTERN = Pattern.compile("^(\\*\\.|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+\\.)+(\\*|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+)$");
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]+$");
    private String match;
    private String name;
    private Map<String, String> labels = new HashMap<String, String>();

    public MapperConfig() {
    }

    MapperConfig(String match) {
        this.validateMatch(match);
        this.match = match;
    }

    public MapperConfig(String match, String name, Map<String, String> labels) {
        this.name = name;
        this.validateMatch(match);
        this.match = match;
        this.validateLabels(labels);
        this.labels = labels;
    }

    public String toString() {
        return String.format("MapperConfig{match=%s, name=%s, labels=%s}", this.match, this.name, this.labels);
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.validateMatch(match);
        this.match = match;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.validateLabels(labels);
        this.labels = labels;
    }

    private void validateMatch(String match) {
        if (!MATCH_EXPRESSION_PATTERN.matcher(match).matches()) {
            throw new IllegalArgumentException(String.format("Match expression [%s] does not match required pattern %s", match, MATCH_EXPRESSION_PATTERN));
        }
    }

    private void validateLabels(Map<String, String> labels) {
        if (labels != null) {
            for (String key : labels.keySet()) {
                if (LABEL_PATTERN.matcher(key).matches()) continue;
                throw new IllegalArgumentException(String.format("Label [%s] does not match required pattern %s", this.match, LABEL_PATTERN));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapperConfig that = (MapperConfig)o;
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.labels != null ? this.labels.equals(that.labels) : that.labels == null;
    }

    public int hashCode() {
        int result = this.match != null ? this.match.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        return result;
    }
}

