/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.instrumentation.dropwizard5;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import io.prometheus.metrics.instrumentation.dropwizard5.labels.CustomLabelMapper;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DropwizardExports
implements MultiCollector {
    private static final Logger logger = Logger.getLogger(DropwizardExports.class.getName());
    private final MetricRegistry registry;
    private final MetricFilter metricFilter;
    private final Optional<CustomLabelMapper> labelMapper;

    public DropwizardExports(MetricRegistry registry) {
        this.registry = registry;
        this.metricFilter = MetricFilter.ALL;
        this.labelMapper = Optional.empty();
    }

    public DropwizardExports(MetricRegistry registry, MetricFilter metricFilter) {
        this.registry = registry;
        this.metricFilter = metricFilter;
        this.labelMapper = Optional.empty();
    }

    public DropwizardExports(MetricRegistry registry, MetricFilter metricFilter, CustomLabelMapper labelMapper) {
        this.registry = registry;
        this.metricFilter = metricFilter;
        this.labelMapper = Optional.ofNullable(labelMapper);
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    private MetricMetadata getMetricMetaData(String metricName, Metric metric) {
        String name = this.labelMapper.isPresent() ? this.labelMapper.get().getName(metricName) : metricName;
        return new MetricMetadata(PrometheusNaming.sanitizeMetricName((String)name), DropwizardExports.getHelpMessage(metricName, metric));
    }

    MetricSnapshot fromCounter(String dropwizardName, Counter counter) {
        MetricMetadata metadata = this.getMetricMetaData(dropwizardName, (Metric)counter);
        CounterSnapshot.CounterDataPointSnapshot.Builder dataPointBuilder = CounterSnapshot.CounterDataPointSnapshot.builder().value(Long.valueOf(counter.getCount()).doubleValue());
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new CounterSnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    MetricSnapshot fromGauge(String dropwizardName, Gauge<?> gauge) {
        double value;
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            logger.log(Level.FINE, String.format("Invalid type for Gauge %s: %s", PrometheusNaming.sanitizeMetricName((String)dropwizardName), obj == null ? "null" : obj.getClass().getName()));
            return null;
        }
        MetricMetadata metadata = this.getMetricMetaData(dropwizardName, (Metric)gauge);
        GaugeSnapshot.GaugeDataPointSnapshot.Builder dataPointBuilder = GaugeSnapshot.GaugeDataPointSnapshot.builder().value(value);
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new GaugeSnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    MetricSnapshot fromSnapshotAndCount(String dropwizardName, Snapshot snapshot, long count, double factor, String helpMessage) {
        Quantiles quantiles = Quantiles.builder().quantile(0.5, snapshot.getMedian() * factor).quantile(0.75, snapshot.get75thPercentile() * factor).quantile(0.95, snapshot.get95thPercentile() * factor).quantile(0.98, snapshot.get98thPercentile() * factor).quantile(0.99, snapshot.get99thPercentile() * factor).quantile(0.999, snapshot.get999thPercentile() * factor).build();
        MetricMetadata metadata = new MetricMetadata(PrometheusNaming.sanitizeMetricName((String)dropwizardName), helpMessage);
        SummarySnapshot.SummaryDataPointSnapshot.Builder dataPointBuilder = SummarySnapshot.SummaryDataPointSnapshot.builder().quantiles(quantiles).count(count);
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new SummarySnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    MetricSnapshot fromHistogram(String dropwizardName, Histogram histogram) {
        return this.fromSnapshotAndCount(dropwizardName, histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardExports.getHelpMessage(dropwizardName, (Metric)histogram));
    }

    MetricSnapshot fromTimer(String dropwizardName, Timer timer) {
        return this.fromSnapshotAndCount(dropwizardName, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardExports.getHelpMessage(dropwizardName, (Metric)timer));
    }

    MetricSnapshot fromMeter(String dropwizardName, Meter meter) {
        MetricMetadata metadata = this.getMetricMetaData(dropwizardName + "_total", (Metric)meter);
        CounterSnapshot.CounterDataPointSnapshot.Builder dataPointBuilder = CounterSnapshot.CounterDataPointSnapshot.builder().value((double)meter.getCount());
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new CounterSnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    public MetricSnapshots collect() {
        MetricSnapshots.Builder metricSnapshots = MetricSnapshots.builder();
        for (Map.Entry entry : this.registry.getGauges(this.metricFilter).entrySet()) {
            Optional.ofNullable(this.fromGauge(((MetricName)entry.getKey()).getKey(), (Gauge)entry.getValue())).ifPresent(arg_0 -> ((MetricSnapshots.Builder)metricSnapshots).metricSnapshot(arg_0));
        }
        for (Map.Entry entry : this.registry.getCounters(this.metricFilter).entrySet()) {
            metricSnapshots.metricSnapshot(this.fromCounter(((MetricName)entry.getKey()).getKey(), (Counter)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getHistograms(this.metricFilter).entrySet()) {
            metricSnapshots.metricSnapshot(this.fromHistogram(((MetricName)entry.getKey()).getKey(), (Histogram)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getTimers(this.metricFilter).entrySet()) {
            metricSnapshots.metricSnapshot(this.fromTimer(((MetricName)entry.getKey()).getKey(), (Timer)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getMeters(this.metricFilter).entrySet()) {
            metricSnapshots.metricSnapshot(this.fromMeter(((MetricName)entry.getKey()).getKey(), (Meter)entry.getValue()));
        }
        return metricSnapshots.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MetricRegistry registry;
        private MetricFilter metricFilter = MetricFilter.ALL;
        private CustomLabelMapper labelMapper;

        private Builder() {
        }

        public Builder dropwizardRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder metricFilter(MetricFilter metricFilter) {
            this.metricFilter = metricFilter;
            return this;
        }

        public Builder customLabelMapper(CustomLabelMapper labelMapper) {
            this.labelMapper = labelMapper;
            return this;
        }

        DropwizardExports build() {
            if (this.registry == null) {
                throw new IllegalArgumentException("MetricRegistry must be set");
            }
            if (this.labelMapper == null) {
                return new DropwizardExports(this.registry, this.metricFilter);
            }
            return new DropwizardExports(this.registry, this.metricFilter, this.labelMapper);
        }

        public void register() {
            this.register(PrometheusRegistry.defaultRegistry);
        }

        public void register(PrometheusRegistry registry) {
            DropwizardExports dropwizardExports = this.build();
            registry.register((MultiCollector)dropwizardExports);
        }
    }
}

