/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.grpc;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.MediaType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.RequestBody;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okio.Buffer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okio.BufferedSink;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okio.GzipSink;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okio.Okio;
import java.io.IOException;
import javax.annotation.Nullable;

public final class GrpcRequestBody
extends RequestBody {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED_FLAG = 0;
    private static final byte COMPRESSED_FLAG = 1;
    private static final MediaType GRPC_MEDIA_TYPE = MediaType.parse("application/grpc");
    private final Marshaler marshaler;
    private final int messageSize;
    private final int contentLength;
    private final boolean compressed;

    public GrpcRequestBody(Marshaler marshaler, boolean compressed) {
        this.marshaler = marshaler;
        this.compressed = compressed;
        this.messageSize = marshaler.getBinarySerializedSize();
        this.contentLength = compressed ? -1 : 5 + this.messageSize;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return GRPC_MEDIA_TYPE;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public void writeTo(BufferedSink sink2) throws IOException {
        if (!this.compressed) {
            sink2.writeByte(0);
            sink2.writeInt(this.messageSize);
            this.marshaler.writeBinaryTo(sink2.outputStream());
        } else {
            try (Buffer compressedBody = new Buffer();){
                try (BufferedSink gzipSink = Okio.buffer(new GzipSink(compressedBody));){
                    this.marshaler.writeBinaryTo(gzipSink.outputStream());
                }
                sink2.writeByte(1);
                int compressedBytes = (int)compressedBody.size();
                sink2.writeInt(compressedBytes);
                sink2.write(compressedBody, (long)compressedBytes);
            }
        }
    }
}

