/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.KeyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.proto.metrics.v1.internal.Exemplar;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.LongExemplarData;
import java.io.IOException;
import java.util.List;

final class ExemplarMarshaler
extends MarshalerWithSize {
    private final long timeUnixNano;
    private final ExemplarData value;
    private final ProtoFieldInfo valueField;
    private final SpanContext spanContext;
    private final KeyValueMarshaler[] filteredAttributeMarshalers;

    static ExemplarMarshaler[] createRepeated(List<? extends ExemplarData> exemplars) {
        int numExemplars = exemplars.size();
        ExemplarMarshaler[] marshalers = new ExemplarMarshaler[numExemplars];
        for (int i = 0; i < numExemplars; ++i) {
            marshalers[i] = ExemplarMarshaler.create(exemplars.get(i));
        }
        return marshalers;
    }

    private static ExemplarMarshaler create(ExemplarData exemplar) {
        ProtoFieldInfo valueField;
        KeyValueMarshaler[] attributeMarshalers = KeyValueMarshaler.createRepeated(exemplar.getFilteredAttributes());
        if (exemplar instanceof LongExemplarData) {
            valueField = Exemplar.AS_INT;
        } else {
            assert (exemplar instanceof DoubleExemplarData);
            valueField = Exemplar.AS_DOUBLE;
        }
        return new ExemplarMarshaler(exemplar.getEpochNanos(), exemplar, valueField, exemplar.getSpanContext(), attributeMarshalers);
    }

    private ExemplarMarshaler(long timeUnixNano, ExemplarData value, ProtoFieldInfo valueField, SpanContext spanContext, KeyValueMarshaler[] filteredAttributeMarshalers) {
        super(ExemplarMarshaler.calculateSize(timeUnixNano, valueField, value, spanContext, filteredAttributeMarshalers));
        this.timeUnixNano = timeUnixNano;
        this.value = value;
        this.valueField = valueField;
        this.spanContext = spanContext;
        this.filteredAttributeMarshalers = filteredAttributeMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(Exemplar.TIME_UNIX_NANO, this.timeUnixNano);
        if (this.valueField == Exemplar.AS_INT) {
            output.serializeFixed64Optional(this.valueField, ((LongExemplarData)this.value).getValue());
        } else {
            output.serializeDoubleOptional(this.valueField, ((DoubleExemplarData)this.value).getValue());
        }
        if (this.spanContext.isValid()) {
            output.serializeSpanId(Exemplar.SPAN_ID, this.spanContext.getSpanId());
            output.serializeTraceId(Exemplar.TRACE_ID, this.spanContext.getTraceId());
        }
        output.serializeRepeatedMessage(Exemplar.FILTERED_ATTRIBUTES, this.filteredAttributeMarshalers);
    }

    private static int calculateSize(long timeUnixNano, ProtoFieldInfo valueField, ExemplarData value, SpanContext spanContext, KeyValueMarshaler[] filteredAttributeMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(Exemplar.TIME_UNIX_NANO, timeUnixNano);
        size = valueField == Exemplar.AS_INT ? (size += MarshalerUtil.sizeFixed64Optional(valueField, ((LongExemplarData)value).getValue())) : (size += MarshalerUtil.sizeDoubleOptional(valueField, ((DoubleExemplarData)value).getValue()));
        if (spanContext.isValid()) {
            size += MarshalerUtil.sizeSpanId(Exemplar.SPAN_ID, spanContext.getSpanId());
            size += MarshalerUtil.sizeTraceId(Exemplar.TRACE_ID, spanContext.getTraceId());
        }
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Exemplar.FILTERED_ATTRIBUTES, (Marshaler[])filteredAttributeMarshalers);
    }
}

