/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.grpc.GrpcExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.export.AggregationTemporalitySelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final GrpcExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporter<MetricsRequestMarshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export(request, metrics.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

