/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.LongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.concurrent.AdderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.concurrent.LongAdder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableLongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableMetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.data.ImmutableSumData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.state.Measurement;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public final class LongSumAggregator
extends AbstractSumAggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;

    public LongSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongPointData diff(LongPointData previousPoint, LongPointData currentPoint) {
        return ImmutableLongPointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        private final LongAdder current = AdderUtil.createLongAdder();

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            long value = reset ? this.current.sumThenReset() : this.current.sum();
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

