/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.TlsUtil;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class TlsConfigHelper {
    @Nullable
    private X509KeyManager keyManager;
    @Nullable
    private X509TrustManager trustManager;
    @Nullable
    private SSLContext sslContext;

    public void setTrustManagerFromCerts(byte[] trustedCertsPem) {
        if (this.trustManager != null) {
            throw new IllegalStateException("trustManager has been previously configured");
        }
        try {
            this.trustManager = TlsUtil.trustManager(trustedCertsPem);
        }
        catch (SSLException e) {
            throw new IllegalStateException("Error creating X509TrustManager with provided certs. Are they valid X.509 in PEM format?", e);
        }
    }

    public void setKeyManagerFromCerts(byte[] privateKeyPem, byte[] certificatePem) {
        if (this.keyManager != null) {
            throw new IllegalStateException("keyManager has been previously configured");
        }
        try {
            this.keyManager = TlsUtil.keyManager(privateKeyPem, certificatePem);
        }
        catch (SSLException e) {
            throw new IllegalStateException("Error creating X509KeyManager with provided certs. Are they valid X.509 in PEM format?", e);
        }
    }

    public void setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        if (this.sslContext != null || this.trustManager != null) {
            throw new IllegalStateException("sslContext or trustManager has been previously configured");
        }
        this.trustManager = trustManager;
        this.sslContext = sslContext;
    }

    @Nullable
    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    @Nullable
    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    @Nullable
    public SSLContext getSslContext() {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        try {
            TrustManager[] trustManagerArray;
            KeyManager[] keyManagerArray;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            if (this.keyManager == null) {
                keyManagerArray = null;
            } else {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = this.keyManager;
            }
            if (this.trustManager == null) {
                trustManagerArray = null;
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = this.trustManager;
            }
            sslContext.init(keyManagerArray, trustManagerArray, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public TlsConfigHelper copy() {
        TlsConfigHelper copy = new TlsConfigHelper();
        copy.keyManager = this.keyManager;
        copy.trustManager = this.trustManager;
        copy.sslContext = this.sslContext;
        return copy;
    }
}

