/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.ProtoEnumInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.otlp.metrics.HistogramDataPointMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.proto.metrics.v1.internal.Histogram;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.HistogramData;
import java.io.IOException;

final class HistogramMarshaler
extends MarshalerWithSize {
    private final HistogramDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;

    static HistogramMarshaler create(HistogramData histogram) {
        HistogramDataPointMarshaler[] dataPointMarshalers = HistogramDataPointMarshaler.createRepeated(histogram.getPoints());
        return new HistogramMarshaler(dataPointMarshalers, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    private HistogramMarshaler(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        super(HistogramMarshaler.calculateSize(dataPoints, aggregationTemporality));
        this.dataPoints = dataPoints;
        this.aggregationTemporality = aggregationTemporality;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Histogram.DATA_POINTS, this.dataPoints);
        output.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
    }

    private static int calculateSize(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Histogram.DATA_POINTS, (Marshaler[])dataPoints);
        return size += MarshalerUtil.sizeEnum(Histogram.AGGREGATION_TEMPORALITY, aggregationTemporality);
    }
}

