/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.AggregationTemporalitySelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpMetricExporter
implements MetricExporter {
    private final HttpExporterBuilder<MetricsRequestMarshaler> builder;
    private final HttpExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;

    OtlpHttpMetricExporter(HttpExporterBuilder<MetricsRequestMarshaler> builder, HttpExporter<MetricsRequestMarshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.builder = builder;
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    public static OtlpHttpMetricExporter getDefault() {
        return OtlpHttpMetricExporter.builder().build();
    }

    public static OtlpHttpMetricExporterBuilder builder() {
        return new OtlpHttpMetricExporterBuilder();
    }

    public OtlpHttpMetricExporterBuilder toBuilder() {
        return new OtlpHttpMetricExporterBuilder(this.builder.copy());
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler exportRequest = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export(exportRequest, metrics.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpMetricExporter{" + this.builder.toString(false) + "}";
    }
}

