/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace.data.SpanData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final HttpExporterBuilder<TraceRequestMarshaler> builder;
    private final HttpExporter<TraceRequestMarshaler> delegate;

    OtlpHttpSpanExporter(HttpExporterBuilder<TraceRequestMarshaler> builder, HttpExporter<TraceRequestMarshaler> delegate) {
        this.builder = builder;
        this.delegate = delegate;
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public OtlpHttpSpanExporterBuilder toBuilder() {
        return new OtlpHttpSpanExporterBuilder(this.builder.copy());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        TraceRequestMarshaler exportRequest = TraceRequestMarshaler.create(spans);
        return this.delegate.export(exportRequest, spans.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpSpanExporter{" + this.builder.toString(false) + "}";
    }
}

