/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.BatchCallback;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.DoubleGaugeBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.DoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.LongCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.LongUpDownCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.Meter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.metrics.ObservableMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.SdkDoubleGauge;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.SdkDoubleHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.SdkLongCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.SdkLongUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.SdkObservableInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.export.RegisteredReader;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.state.CallbackRegistration;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.state.MeterProviderSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.state.MeterSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.state.SdkObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

final class SdkMeter
implements Meter {
    private static final Logger logger = Logger.getLogger(SdkMeter.class.getName());
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile("([A-Za-z]){1}([A-Za-z0-9\\_\\-\\./]){0,254}");
    private static final Meter NOOP_METER = MeterProvider.noop().get("noop");
    private static final String NOOP_INSTRUMENT_NAME = "noop";
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> registeredReaders) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationScopeInfo, registeredReaders);
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    Collection<MetricData> collectAll(RegisteredReader registeredReader, long epochNanos) {
        return this.meterSharedState.collectAll(registeredReader, this.meterProviderSharedState, epochNanos);
    }

    void resetForTest() {
        this.meterSharedState.resetForTest();
    }

    @Override
    public LongCounterBuilder counterBuilder(String name) {
        return !SdkMeter.checkValidInstrumentName(name) ? NOOP_METER.counterBuilder(NOOP_INSTRUMENT_NAME) : new SdkLongCounter.SdkLongCounterBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return !SdkMeter.checkValidInstrumentName(name) ? NOOP_METER.upDownCounterBuilder(NOOP_INSTRUMENT_NAME) : new SdkLongUpDownCounter.SdkLongUpDownCounterBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String name) {
        return !SdkMeter.checkValidInstrumentName(name) ? NOOP_METER.histogramBuilder(NOOP_INSTRUMENT_NAME) : new SdkDoubleHistogram.SdkDoubleHistogramBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return !SdkMeter.checkValidInstrumentName(name) ? NOOP_METER.gaugeBuilder(NOOP_INSTRUMENT_NAME) : new SdkDoubleGauge.SdkDoubleGaugeBuilder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    @Override
    public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
        HashSet<ObservableMeasurement> measurements = new HashSet<ObservableMeasurement>();
        measurements.add(observableMeasurement);
        Collections.addAll(measurements, additionalMeasurements);
        ArrayList<SdkObservableMeasurement> sdkMeasurements = new ArrayList<SdkObservableMeasurement>();
        for (ObservableMeasurement measurement : measurements) {
            if (!(measurement instanceof SdkObservableMeasurement)) {
                logger.log(Level.WARNING, "batchCallback called with instruments that were not created by the SDK.");
                continue;
            }
            SdkObservableMeasurement sdkMeasurement = (SdkObservableMeasurement)measurement;
            if (!this.meterSharedState.getInstrumentationScopeInfo().equals(sdkMeasurement.getInstrumentationScopeInfo())) {
                logger.log(Level.WARNING, "batchCallback called with instruments that belong to a different Meter.");
                continue;
            }
            sdkMeasurements.add(sdkMeasurement);
        }
        CallbackRegistration callbackRegistration = CallbackRegistration.create(sdkMeasurements, callback);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    public String toString() {
        return "SdkMeter{instrumentationScopeInfo=" + this.instrumentationScopeInfo + "}";
    }

    static boolean checkValidInstrumentName(String name) {
        if (name != null && VALID_INSTRUMENT_NAME_PATTERN.matcher(name).matches()) {
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Instrument name \"" + name + "\" is invalid, returning noop instrument. Instrument names must consist of 255 or fewer characters including alphanumeric, _, ., -, and start with a letter.", (Throwable)((Object)new AssertionError()));
        }
        return false;
    }
}

