/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.internal.DaemonThreadFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.MetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.PeriodicMetricReader;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class PeriodicMetricReaderBuilder {
    static final long DEFAULT_SCHEDULE_DELAY_MINUTES = 1L;
    private final MetricExporter metricExporter;
    private long intervalNanos = TimeUnit.MINUTES.toNanos(1L);
    @Nullable
    private ScheduledExecutorService executor;

    PeriodicMetricReaderBuilder(MetricExporter metricExporter) {
        this.metricExporter = metricExporter;
    }

    public PeriodicMetricReaderBuilder setInterval(long interval, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(interval > 0L, "interval must be positive");
        this.intervalNanos = unit.toNanos(interval);
        return this;
    }

    public PeriodicMetricReaderBuilder setInterval(Duration interval) {
        Objects.requireNonNull(interval, "interval");
        return this.setInterval(interval.toNanos(), TimeUnit.NANOSECONDS);
    }

    public PeriodicMetricReaderBuilder setExecutor(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public PeriodicMetricReader build() {
        ScheduledExecutorService executor = this.executor;
        if (executor == null) {
            executor = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("PeriodicMetricReader"));
        }
        return new PeriodicMetricReader(this.metricExporter, this.intervalNanos, executor);
    }
}

