/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.Clock;
import javax.annotation.concurrent.Immutable;

@Immutable
final class AnchoredClock {
    private final Clock clock;
    private final long epochNanos;
    private final long nanoTime;

    private AnchoredClock(Clock clock, long epochNanos, long nanoTime) {
        this.clock = clock;
        this.epochNanos = epochNanos;
        this.nanoTime = nanoTime;
    }

    public static AnchoredClock create(Clock clock) {
        return new AnchoredClock(clock, clock.now(), clock.nanoTime());
    }

    long now() {
        long deltaNanos = this.clock.nanoTime() - this.nanoTime;
        return this.epochNanos + deltaNanos;
    }

    long startTime() {
        return this.epochNanos;
    }
}

