/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.simpleclient.bridge;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exemplars.Exemplar;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.ClassicHistogramBuckets;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.Unit;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class SimpleclientCollector
implements MultiCollector {
    private final CollectorRegistry simpleclientRegistry;

    private SimpleclientCollector(CollectorRegistry simpleclientRegistry) {
        this.simpleclientRegistry = simpleclientRegistry;
    }

    public MetricSnapshots collect() {
        return this.convert(this.simpleclientRegistry.metricFamilySamples());
    }

    public MetricSnapshots collect(Predicate<String> includedNames) {
        return super.collect(includedNames);
    }

    public List<String> getPrometheusNames() {
        return super.getPrometheusNames();
    }

    private MetricSnapshots convert(Enumeration<Collector.MetricFamilySamples> samples) {
        MetricSnapshots.Builder result = MetricSnapshots.builder();
        block10: while (samples.hasMoreElements()) {
            Collector.MetricFamilySamples sample = samples.nextElement();
            switch (sample.type) {
                case COUNTER: {
                    result.metricSnapshot(this.convertCounter(sample));
                    continue block10;
                }
                case GAUGE: {
                    result.metricSnapshot(this.convertGauge(sample));
                    continue block10;
                }
                case HISTOGRAM: {
                    result.metricSnapshot(this.convertHistogram(sample, false));
                    continue block10;
                }
                case GAUGE_HISTOGRAM: {
                    result.metricSnapshot(this.convertHistogram(sample, true));
                    continue block10;
                }
                case SUMMARY: {
                    result.metricSnapshot(this.convertSummary(sample));
                    continue block10;
                }
                case INFO: {
                    result.metricSnapshot(this.convertInfo(sample));
                    continue block10;
                }
                case STATE_SET: {
                    result.metricSnapshot(this.convertStateSet(sample));
                    continue block10;
                }
                case UNKNOWN: {
                    result.metricSnapshot(this.convertUnknown(sample));
                    continue block10;
                }
            }
            throw new IllegalStateException(sample.type + ": Unexpected metric type");
        }
        return result.build();
    }

    private MetricSnapshot convertCounter(Collector.MetricFamilySamples samples) {
        CounterSnapshot.Builder counter = (CounterSnapshot.Builder)((CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(this.stripSuffix(samples.name, "_total"))).help(samples.help)).unit(this.convertUnit(samples));
        HashMap<Labels, CounterSnapshot.CounterDataPointSnapshot.Builder> dataPoints = new HashMap<Labels, CounterSnapshot.CounterDataPointSnapshot.Builder>();
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            Labels labels = Labels.of((List)sample.labelNames, (List)sample.labelValues);
            CounterSnapshot.CounterDataPointSnapshot.Builder dataPoint = dataPoints.computeIfAbsent(labels, l -> (CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels));
            if (sample.name.endsWith("_created")) {
                dataPoint.createdTimestampMillis((long)Unit.secondsToMillis((double)sample.value));
                continue;
            }
            dataPoint.value(sample.value).exemplar(this.convertExemplar(sample.exemplar));
            if (sample.timestampMs == null) continue;
            dataPoint.scrapeTimestampMillis(sample.timestampMs.longValue());
        }
        for (CounterSnapshot.CounterDataPointSnapshot.Builder dataPoint : dataPoints.values()) {
            counter.dataPoint(dataPoint.build());
        }
        return counter.build();
    }

    private MetricSnapshot convertGauge(Collector.MetricFamilySamples samples) {
        GaugeSnapshot.Builder gauge = (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(samples.name)).help(samples.help)).unit(this.convertUnit(samples));
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            GaugeSnapshot.GaugeDataPointSnapshot.Builder dataPoint = ((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().value(sample.value).labels(Labels.of((List)sample.labelNames, (List)sample.labelValues))).exemplar(this.convertExemplar(sample.exemplar));
            if (sample.timestampMs != null) {
                dataPoint.scrapeTimestampMillis(sample.timestampMs.longValue());
            }
            gauge.dataPoint(dataPoint.build());
        }
        return gauge.build();
    }

    private MetricSnapshot convertHistogram(Collector.MetricFamilySamples samples, boolean isGaugeHistogram) {
        HistogramSnapshot.Builder histogram = ((HistogramSnapshot.Builder)((HistogramSnapshot.Builder)((HistogramSnapshot.Builder)HistogramSnapshot.builder().name(samples.name)).help(samples.help)).unit(this.convertUnit(samples))).gaugeHistogram(isGaugeHistogram);
        HashMap<Labels, HistogramSnapshot.HistogramDataPointSnapshot.Builder> dataPoints = new HashMap<Labels, HistogramSnapshot.HistogramDataPointSnapshot.Builder>();
        HashMap<Labels, Map> cumulativeBuckets = new HashMap<Labels, Map>();
        HashMap<Labels, Exemplars.Builder> exemplars = new HashMap<Labels, Exemplars.Builder>();
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            Labels labels = this.labelsWithout(sample, "le");
            dataPoints.computeIfAbsent(labels, l -> (HistogramSnapshot.HistogramDataPointSnapshot.Builder)HistogramSnapshot.HistogramDataPointSnapshot.builder().labels(labels));
            cumulativeBuckets.computeIfAbsent(labels, l -> new HashMap());
            exemplars.computeIfAbsent(labels, l -> Exemplars.builder());
            if (sample.name.endsWith("_sum")) {
                ((HistogramSnapshot.HistogramDataPointSnapshot.Builder)dataPoints.get(labels)).sum(sample.value);
            }
            if (sample.name.endsWith("_bucket")) {
                this.addBucket((Map)cumulativeBuckets.get(labels), sample);
            }
            if (sample.name.endsWith("_created")) {
                ((HistogramSnapshot.HistogramDataPointSnapshot.Builder)dataPoints.get(labels)).createdTimestampMillis((long)Unit.secondsToMillis((double)sample.value));
            }
            if (sample.exemplar != null) {
                ((Exemplars.Builder)exemplars.get(labels)).exemplar(this.convertExemplar(sample.exemplar));
            }
            if (sample.timestampMs == null) continue;
            ((HistogramSnapshot.HistogramDataPointSnapshot.Builder)dataPoints.get(labels)).scrapeTimestampMillis(sample.timestampMs.longValue());
        }
        for (Labels labels : dataPoints.keySet()) {
            histogram.dataPoint(((HistogramSnapshot.HistogramDataPointSnapshot.Builder)((HistogramSnapshot.HistogramDataPointSnapshot.Builder)dataPoints.get(labels)).classicHistogramBuckets(this.makeBuckets((Map)cumulativeBuckets.get(labels))).exemplars(((Exemplars.Builder)exemplars.get(labels)).build())).build());
        }
        return histogram.build();
    }

    private MetricSnapshot convertSummary(Collector.MetricFamilySamples samples) {
        SummarySnapshot.Builder summary = (SummarySnapshot.Builder)((SummarySnapshot.Builder)((SummarySnapshot.Builder)SummarySnapshot.builder().name(samples.name)).help(samples.help)).unit(this.convertUnit(samples));
        HashMap<Labels, SummarySnapshot.SummaryDataPointSnapshot.Builder> dataPoints = new HashMap<Labels, SummarySnapshot.SummaryDataPointSnapshot.Builder>();
        HashMap<Labels, Quantiles.Builder> quantiles = new HashMap<Labels, Quantiles.Builder>();
        HashMap<Labels, Exemplars.Builder> exemplars = new HashMap<Labels, Exemplars.Builder>();
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            Labels labels = this.labelsWithout(sample, "quantile");
            dataPoints.computeIfAbsent(labels, l -> (SummarySnapshot.SummaryDataPointSnapshot.Builder)SummarySnapshot.SummaryDataPointSnapshot.builder().labels(labels));
            quantiles.computeIfAbsent(labels, l -> Quantiles.builder());
            exemplars.computeIfAbsent(labels, l -> Exemplars.builder());
            if (sample.name.endsWith("_sum")) {
                ((SummarySnapshot.SummaryDataPointSnapshot.Builder)dataPoints.get(labels)).sum(sample.value);
            } else if (sample.name.endsWith("_count")) {
                ((SummarySnapshot.SummaryDataPointSnapshot.Builder)dataPoints.get(labels)).count((long)sample.value);
            } else if (sample.name.endsWith("_created")) {
                ((SummarySnapshot.SummaryDataPointSnapshot.Builder)dataPoints.get(labels)).createdTimestampMillis((long)Unit.secondsToMillis((double)sample.value));
            } else {
                for (int i = 0; i < sample.labelNames.size(); ++i) {
                    if (!((String)sample.labelNames.get(i)).equals("quantile")) continue;
                    ((Quantiles.Builder)quantiles.get(labels)).quantile(new Quantile(Double.parseDouble((String)sample.labelValues.get(i)), sample.value));
                    break;
                }
            }
            if (sample.exemplar != null) {
                ((Exemplars.Builder)exemplars.get(labels)).exemplar(this.convertExemplar(sample.exemplar));
            }
            if (sample.timestampMs == null) continue;
            ((SummarySnapshot.SummaryDataPointSnapshot.Builder)dataPoints.get(labels)).scrapeTimestampMillis(sample.timestampMs.longValue());
        }
        for (Labels labels : dataPoints.keySet()) {
            summary.dataPoint(((SummarySnapshot.SummaryDataPointSnapshot.Builder)((SummarySnapshot.SummaryDataPointSnapshot.Builder)dataPoints.get(labels)).quantiles(((Quantiles.Builder)quantiles.get(labels)).build()).exemplars(((Exemplars.Builder)exemplars.get(labels)).build())).build());
        }
        return summary.build();
    }

    private MetricSnapshot convertStateSet(Collector.MetricFamilySamples samples) {
        StateSetSnapshot.Builder stateSet = (StateSetSnapshot.Builder)((StateSetSnapshot.Builder)StateSetSnapshot.builder().name(samples.name)).help(samples.help);
        HashMap<Labels, StateSetSnapshot.StateSetDataPointSnapshot.Builder> dataPoints = new HashMap<Labels, StateSetSnapshot.StateSetDataPointSnapshot.Builder>();
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            Labels labels = this.labelsWithout(sample, sample.name);
            dataPoints.computeIfAbsent(labels, l -> (StateSetSnapshot.StateSetDataPointSnapshot.Builder)StateSetSnapshot.StateSetDataPointSnapshot.builder().labels(labels));
            String stateName = null;
            for (int i = 0; i < sample.labelNames.size(); ++i) {
                if (!((String)sample.labelNames.get(i)).equals(sample.name)) continue;
                stateName = (String)sample.labelValues.get(i);
                break;
            }
            if (stateName == null) {
                throw new IllegalStateException("Invalid StateSet metric: No state name found.");
            }
            ((StateSetSnapshot.StateSetDataPointSnapshot.Builder)dataPoints.get(labels)).state(stateName, sample.value == 1.0);
            if (sample.timestampMs == null) continue;
            ((StateSetSnapshot.StateSetDataPointSnapshot.Builder)dataPoints.get(labels)).scrapeTimestampMillis(sample.timestampMs.longValue());
        }
        for (StateSetSnapshot.StateSetDataPointSnapshot.Builder dataPoint : dataPoints.values()) {
            stateSet.dataPoint(dataPoint.build());
        }
        return stateSet.build();
    }

    private MetricSnapshot convertUnknown(Collector.MetricFamilySamples samples) {
        UnknownSnapshot.Builder unknown = (UnknownSnapshot.Builder)((UnknownSnapshot.Builder)((UnknownSnapshot.Builder)UnknownSnapshot.builder().name(samples.name)).help(samples.help)).unit(this.convertUnit(samples));
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            UnknownSnapshot.UnknownDataPointSnapshot.Builder dataPoint = ((UnknownSnapshot.UnknownDataPointSnapshot.Builder)UnknownSnapshot.UnknownDataPointSnapshot.builder().value(sample.value).labels(Labels.of((List)sample.labelNames, (List)sample.labelValues))).exemplar(this.convertExemplar(sample.exemplar));
            if (sample.timestampMs != null) {
                dataPoint.scrapeTimestampMillis(sample.timestampMs.longValue());
            }
            unknown.dataPoint(dataPoint.build());
        }
        return unknown.build();
    }

    private String stripSuffix(String name, String suffix) {
        if (name.endsWith(suffix)) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    private Unit convertUnit(Collector.MetricFamilySamples samples) {
        if (samples.unit != null && !samples.unit.isEmpty()) {
            return new Unit(samples.unit);
        }
        return null;
    }

    private ClassicHistogramBuckets makeBuckets(Map<Double, Long> cumulativeBuckets) {
        ArrayList<Double> upperBounds = new ArrayList<Double>(cumulativeBuckets.size());
        Collections.sort(upperBounds);
        upperBounds.addAll(cumulativeBuckets.keySet());
        ClassicHistogramBuckets.Builder result = ClassicHistogramBuckets.builder();
        long previousCount = 0L;
        for (Double upperBound : upperBounds) {
            long cumulativeCount = cumulativeBuckets.get(upperBound);
            result.bucket(upperBound.doubleValue(), cumulativeCount - previousCount);
            previousCount = cumulativeCount;
        }
        return result.build();
    }

    private void addBucket(Map<Double, Long> buckets, Collector.MetricFamilySamples.Sample sample) {
        for (int i = 0; i < sample.labelNames.size(); ++i) {
            double upperBound;
            if (!((String)sample.labelNames.get(i)).equals("le")) continue;
            switch ((String)sample.labelValues.get(i)) {
                case "+Inf": {
                    upperBound = Double.POSITIVE_INFINITY;
                    break;
                }
                case "-Inf": {
                    upperBound = Double.NEGATIVE_INFINITY;
                    break;
                }
                default: {
                    upperBound = Double.parseDouble((String)sample.labelValues.get(i));
                }
            }
            buckets.put(upperBound, (long)sample.value);
            return;
        }
        throw new IllegalStateException(sample.name + " does not have a le label.");
    }

    private Labels labelsWithout(Collector.MetricFamilySamples.Sample sample, String excludedLabelName) {
        Labels.Builder labels = Labels.builder();
        for (int i = 0; i < sample.labelNames.size(); ++i) {
            if (((String)sample.labelNames.get(i)).equals(excludedLabelName)) continue;
            labels.label((String)sample.labelNames.get(i), (String)sample.labelValues.get(i));
        }
        return labels.build();
    }

    private MetricSnapshot convertInfo(Collector.MetricFamilySamples samples) {
        InfoSnapshot.Builder info = (InfoSnapshot.Builder)((InfoSnapshot.Builder)InfoSnapshot.builder().name(this.stripSuffix(samples.name, "_info"))).help(samples.help);
        for (Collector.MetricFamilySamples.Sample sample : samples.samples) {
            info.dataPoint(((InfoSnapshot.InfoDataPointSnapshot.Builder)InfoSnapshot.InfoDataPointSnapshot.builder().labels(Labels.of((List)sample.labelNames, (List)sample.labelValues))).build());
        }
        return info.build();
    }

    private io.prometheus.metrics.model.snapshots.Exemplar convertExemplar(Exemplar exemplar) {
        if (exemplar == null) {
            return null;
        }
        Exemplar.Builder result = io.prometheus.metrics.model.snapshots.Exemplar.builder().value(exemplar.getValue());
        if (exemplar.getTimestampMs() != null) {
            result.timestampMillis(exemplar.getTimestampMs().longValue());
        }
        Labels.Builder labels = Labels.builder();
        for (int i = 0; i < exemplar.getNumberOfLabels(); ++i) {
            labels.label(exemplar.getLabelName(i), exemplar.getLabelValue(i));
        }
        return result.labels(labels.build()).build();
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static Builder builder() {
        return SimpleclientCollector.builder(PrometheusProperties.get());
    }

    public static class Builder {
        private final PrometheusProperties config;
        private CollectorRegistry collectorRegistry;

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public Builder collectorRegistry(CollectorRegistry registry) {
            this.collectorRegistry = registry;
            return this;
        }

        public SimpleclientCollector build() {
            return this.collectorRegistry != null ? new SimpleclientCollector(this.collectorRegistry) : new SimpleclientCollector(CollectorRegistry.defaultRegistry);
        }

        public SimpleclientCollector register() {
            return this.register(PrometheusRegistry.defaultRegistry);
        }

        public SimpleclientCollector register(PrometheusRegistry registry) {
            SimpleclientCollector result = this.build();
            registry.register((MultiCollector)result);
            return result;
        }
    }
}

