/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exemplars.Exemplar;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Collector {
    public static final double NANOSECONDS_PER_SECOND = 1.0E9;
    public static final double MILLISECONDS_PER_SECOND = 1000.0;
    private static final Pattern METRIC_NAME_RE = Pattern.compile("[a-zA-Z_:][a-zA-Z0-9_:]*");
    private static final Pattern METRIC_LABEL_NAME_RE = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Pattern RESERVED_METRIC_LABEL_NAME_RE = Pattern.compile("__.*");
    private static final Pattern SANITIZE_PREFIX_PATTERN = Pattern.compile("^[^a-zA-Z_:]");
    private static final Pattern SANITIZE_BODY_PATTERN = Pattern.compile("[^a-zA-Z0-9_:]");

    public abstract List<MetricFamilySamples> collect();

    public <T extends Collector> T register() {
        return this.register(CollectorRegistry.defaultRegistry);
    }

    public <T extends Collector> T register(CollectorRegistry registry) {
        registry.register(this);
        return (T)this;
    }

    protected static void checkMetricName(String name) {
        if (!METRIC_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric name: " + name);
        }
    }

    public static String sanitizeMetricName(String metricName) {
        return SANITIZE_BODY_PATTERN.matcher(SANITIZE_PREFIX_PATTERN.matcher(metricName).replaceFirst("_")).replaceAll("_");
    }

    protected static void checkMetricLabelName(String name) {
        if (!METRIC_LABEL_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric label name: " + name);
        }
        if (RESERVED_METRIC_LABEL_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric label name, reserved for internal use: " + name);
        }
    }

    public static String doubleToGoString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return Double.toString(d);
    }

    public static interface Describable {
        public List<MetricFamilySamples> describe();
    }

    public static class MetricFamilySamples {
        public final String name;
        public final String unit;
        public final Type type;
        public final String help;
        public final List<Sample> samples;

        public MetricFamilySamples(String name, String unit, Type type, String help, List<Sample> samples) {
            if (!unit.isEmpty() && !name.endsWith("_" + unit)) {
                throw new IllegalArgumentException("Metric's unit is not the suffix of the metric name: " + name);
            }
            if (!(type != Type.INFO && type != Type.STATE_SET || unit.isEmpty())) {
                throw new IllegalArgumentException("Metric is of a type that cannot have a unit: " + name);
            }
            List<Sample> mungedSamples = samples;
            if (type == Type.COUNTER) {
                if (name.endsWith("_total")) {
                    name = name.substring(0, name.length() - 6);
                }
                String withTotal = name + "_total";
                mungedSamples = new ArrayList<Sample>(samples.size());
                for (Sample s : samples) {
                    String n = s.name;
                    if (name.equals(n)) {
                        n = withTotal;
                    }
                    mungedSamples.add(new Sample(n, s.labelNames, s.labelValues, s.value, s.exemplar, s.timestampMs));
                }
            }
            this.name = name;
            this.unit = unit;
            this.type = type;
            this.help = help;
            this.samples = mungedSamples;
        }

        public MetricFamilySamples(String name, Type type, String help, List<Sample> samples) {
            this(name, "", type, help, samples);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetricFamilySamples)) {
                return false;
            }
            MetricFamilySamples other = (MetricFamilySamples)obj;
            return other.name.equals(this.name) && other.unit.equals(this.unit) && other.type.equals((Object)this.type) && other.help.equals(this.help) && other.samples.equals(this.samples);
        }

        public int hashCode() {
            int hash = 1;
            hash = 37 * hash + this.name.hashCode();
            hash = 37 * hash + this.unit.hashCode();
            hash = 37 * hash + this.type.hashCode();
            hash = 37 * hash + this.help.hashCode();
            hash = 37 * hash + this.samples.hashCode();
            return hash;
        }

        public String toString() {
            return "Name: " + this.name + " Unit:" + this.unit + " Type: " + (Object)((Object)this.type) + " Help: " + this.help + " Samples: " + this.samples;
        }

        public static class Sample {
            public final String name;
            public final List<String> labelNames;
            public final List<String> labelValues;
            public final double value;
            public final Exemplar exemplar;
            public final Long timestampMs;

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value, Exemplar exemplar, Long timestampMs) {
                this.name = name;
                this.labelNames = labelNames;
                this.labelValues = labelValues;
                this.value = value;
                this.exemplar = exemplar;
                this.timestampMs = timestampMs;
            }

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value, Long timestampMs) {
                this(name, labelNames, labelValues, value, null, timestampMs);
            }

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value, Exemplar exemplar) {
                this(name, labelNames, labelValues, value, exemplar, null);
            }

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value) {
                this(name, labelNames, labelValues, value, null, null);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Sample)) {
                    return false;
                }
                Sample other = (Sample)obj;
                return other.name.equals(this.name) && other.labelNames.equals(this.labelNames) && other.labelValues.equals(this.labelValues) && other.value == this.value && (this.exemplar == null && other.exemplar == null || other.exemplar != null && other.exemplar.equals(this.exemplar)) && (this.timestampMs == null && other.timestampMs == null || other.timestampMs != null && other.timestampMs.equals(this.timestampMs));
            }

            public int hashCode() {
                int hash = 1;
                hash = 37 * hash + this.name.hashCode();
                hash = 37 * hash + this.labelNames.hashCode();
                hash = 37 * hash + this.labelValues.hashCode();
                long d = Double.doubleToLongBits(this.value);
                hash = 37 * hash + (int)(d ^ d >>> 32);
                if (this.timestampMs != null) {
                    hash = 37 * hash + this.timestampMs.hashCode();
                }
                if (this.exemplar != null) {
                    hash = 37 * this.exemplar.hashCode();
                }
                return hash;
            }

            public String toString() {
                return "Name: " + this.name + " LabelNames: " + this.labelNames + " labelValues: " + this.labelValues + " Value: " + this.value + " TimestampMs: " + this.timestampMs;
            }
        }
    }

    public static enum Type {
        UNKNOWN,
        COUNTER,
        GAUGE,
        STATE_SET,
        INFO,
        HISTOGRAM,
        GAUGE_HISTOGRAM,
        SUMMARY;

    }
}

