/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DropwizardExports
extends Collector {
    private MetricRegistry registry;
    private static final Logger LOGGER = Logger.getLogger(DropwizardExports.class.getName());

    public DropwizardExports(MetricRegistry registry) {
        this.registry = registry;
    }

    List<Collector.MetricFamilySamples> fromCounter(String name, Counter counter) {
        Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(name, new ArrayList(), new ArrayList(), new Long(counter.getCount()).doubleValue());
        return Arrays.asList(new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, DropwizardExports.getHelpMessage(name, (Metric)counter), Arrays.asList(sample)));
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    List<Collector.MetricFamilySamples> fromGauge(String name, Gauge gauge) {
        Double value;
        Object obj = gauge.getValue();
        if (obj instanceof Integer) {
            value = ((Integer)obj).doubleValue();
        } else if (obj instanceof Double) {
            value = (Double)obj;
        } else if (obj instanceof Float) {
            value = ((Float)obj).doubleValue();
        } else if (obj instanceof Long) {
            value = ((Long)obj).doubleValue();
        } else {
            LOGGER.log(Level.FINE, String.format("Invalid type for Gauge %s: %s", name, obj.getClass().getName()));
            return new ArrayList<Collector.MetricFamilySamples>();
        }
        Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(name, new ArrayList(), new ArrayList(), value.doubleValue());
        return Arrays.asList(new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, DropwizardExports.getHelpMessage(name, (Metric)gauge), Arrays.asList(sample)));
    }

    List<Collector.MetricFamilySamples> fromSnapshotAndCount(String name, Snapshot snapshot, long count, double factor, String helpMessage) {
        long sum = 0L;
        for (long i : snapshot.getValues()) {
            sum += i;
        }
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.5"), snapshot.getMedian() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.75"), snapshot.get75thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.95"), snapshot.get95thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.98"), snapshot.get98thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.99"), snapshot.get99thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.999"), snapshot.get999thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name + "_count", new ArrayList(), new ArrayList(), (double)count), new Collector.MetricFamilySamples.Sample(name + "_sum", new ArrayList(), new ArrayList(), (double)sum * factor));
        return Arrays.asList(new Collector.MetricFamilySamples(name, Collector.Type.SUMMARY, helpMessage, samples));
    }

    List<Collector.MetricFamilySamples> fromHistogram(String name, Histogram histogram) {
        return this.fromSnapshotAndCount(name, histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardExports.getHelpMessage(name, (Metric)histogram));
    }

    List<Collector.MetricFamilySamples> fromTimer(String name, Timer timer) {
        return this.fromSnapshotAndCount(name, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardExports.getHelpMessage(name, (Metric)timer));
    }

    List<Collector.MetricFamilySamples> fromMeter(String name, Meter meter) {
        return Arrays.asList(new Collector.MetricFamilySamples(name + "_total", Collector.Type.COUNTER, DropwizardExports.getHelpMessage(name, (Metric)meter), Arrays.asList(new Collector.MetricFamilySamples.Sample(name + "_total", new ArrayList(), new ArrayList(), (double)meter.getCount()))));
    }

    public static String sanitizeMetricName(String name) {
        return name.replaceAll("[^a-zA-Z0-9:_]", "_");
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfSamples = new ArrayList<Collector.MetricFamilySamples>();
        for (Map.Entry entry : this.registry.getGauges().entrySet()) {
            mfSamples.addAll(this.fromGauge(DropwizardExports.sanitizeMetricName((String)entry.getKey()), (Gauge)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getCounters().entrySet()) {
            mfSamples.addAll(this.fromCounter(DropwizardExports.sanitizeMetricName((String)entry.getKey()), (Counter)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getHistograms().entrySet()) {
            mfSamples.addAll(this.fromHistogram(DropwizardExports.sanitizeMetricName((String)entry.getKey()), (Histogram)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getTimers().entrySet()) {
            mfSamples.addAll(this.fromTimer(DropwizardExports.sanitizeMetricName((String)entry.getKey()), (Timer)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getMeters().entrySet()) {
            mfSamples.addAll(this.fromMeter(DropwizardExports.sanitizeMetricName((String)entry.getKey()), (Meter)entry.getValue()));
        }
        return mfSamples;
    }
}

