/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DropwizardExports
extends Collector {
    private MetricRegistry registry;
    private static final Logger LOGGER = Logger.getLogger(DropwizardExports.class.getName());

    public DropwizardExports(MetricRegistry registry) {
        this.registry = registry;
    }

    List<Collector.MetricFamilySamples> fromCounter(String dropwizardName, Counter counter) {
        String name = DropwizardExports.sanitizeMetricName(dropwizardName);
        Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(name, new ArrayList(), new ArrayList(), new Long(counter.getCount()).doubleValue());
        return Arrays.asList(new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, DropwizardExports.getHelpMessage(dropwizardName, (Metric)counter), Arrays.asList(sample)));
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    List<Collector.MetricFamilySamples> fromGauge(String dropwizardName, Gauge gauge) {
        double value;
        String name = DropwizardExports.sanitizeMetricName(dropwizardName);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            LOGGER.log(Level.FINE, String.format("Invalid type for Gauge %s: %s", name, obj.getClass().getName()));
            return new ArrayList<Collector.MetricFamilySamples>();
        }
        Collector.MetricFamilySamples.Sample sample = new Collector.MetricFamilySamples.Sample(name, new ArrayList(), new ArrayList(), value);
        return Arrays.asList(new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, DropwizardExports.getHelpMessage(dropwizardName, (Metric)gauge), Arrays.asList(sample)));
    }

    List<Collector.MetricFamilySamples> fromSnapshotAndCount(String dropwizardName, Snapshot snapshot, long count, double factor, String helpMessage) {
        String name = DropwizardExports.sanitizeMetricName(dropwizardName);
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.5"), snapshot.getMedian() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.75"), snapshot.get75thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.95"), snapshot.get95thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.98"), snapshot.get98thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.99"), snapshot.get99thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name, Arrays.asList("quantile"), Arrays.asList("0.999"), snapshot.get999thPercentile() * factor), new Collector.MetricFamilySamples.Sample(name + "_count", new ArrayList(), new ArrayList(), (double)count));
        return Arrays.asList(new Collector.MetricFamilySamples(name, Collector.Type.SUMMARY, helpMessage, samples));
    }

    List<Collector.MetricFamilySamples> fromHistogram(String dropwizardName, Histogram histogram) {
        return this.fromSnapshotAndCount(dropwizardName, histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardExports.getHelpMessage(dropwizardName, (Metric)histogram));
    }

    List<Collector.MetricFamilySamples> fromTimer(String dropwizardName, Timer timer) {
        return this.fromSnapshotAndCount(dropwizardName, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardExports.getHelpMessage(dropwizardName, (Metric)timer));
    }

    List<Collector.MetricFamilySamples> fromMeter(String dropwizardName, Meter meter) {
        String name = DropwizardExports.sanitizeMetricName(dropwizardName);
        return Arrays.asList(new Collector.MetricFamilySamples(name + "_total", Collector.Type.COUNTER, DropwizardExports.getHelpMessage(dropwizardName, (Metric)meter), Arrays.asList(new Collector.MetricFamilySamples.Sample(name + "_total", new ArrayList(), new ArrayList(), (double)meter.getCount()))));
    }

    public static String sanitizeMetricName(String dropwizardName) {
        return dropwizardName.replaceAll("[^a-zA-Z0-9:_]", "_");
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfSamples = new ArrayList<Collector.MetricFamilySamples>();
        for (Map.Entry entry : this.registry.getGauges().entrySet()) {
            mfSamples.addAll(this.fromGauge((String)entry.getKey(), (Gauge)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getCounters().entrySet()) {
            mfSamples.addAll(this.fromCounter((String)entry.getKey(), (Counter)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getHistograms().entrySet()) {
            mfSamples.addAll(this.fromHistogram((String)entry.getKey(), (Histogram)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getTimers().entrySet()) {
            mfSamples.addAll(this.fromTimer((String)entry.getKey(), (Timer)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getMeters().entrySet()) {
            mfSamples.addAll(this.fromMeter((String)entry.getKey(), (Meter)entry.getValue()));
        }
        return mfSamples;
    }
}

