/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.jetty;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class QueuedThreadPoolStatisticsCollector
extends Collector {
    private static final List<String> LABEL_NAMES = Collections.singletonList("unit");
    private final Map<String, QueuedThreadPool> queuedThreadPoolMap = new ConcurrentHashMap<String, QueuedThreadPool>();

    public QueuedThreadPoolStatisticsCollector() {
    }

    public QueuedThreadPoolStatisticsCollector(QueuedThreadPool queuedThreadPool, String name) {
        this.add(queuedThreadPool, name);
    }

    public QueuedThreadPoolStatisticsCollector add(QueuedThreadPool queuedThreadPool, String name) {
        this.queuedThreadPoolMap.put(name, queuedThreadPool);
        return this;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(this.buildGauge("jetty_queued_thread_pool_threads", "Number of total threads", QueuedThreadPool::getThreads), this.buildGauge("jetty_queued_thread_pool_threads_idle", "Number of idle threads", QueuedThreadPool::getIdleThreads), this.buildGauge("jetty_queued_thread_pool_threads_max", "Max size of thread pool", QueuedThreadPool::getMaxThreads), this.buildGauge("jetty_queued_thread_pool_jobs", "Number of total jobs", QueuedThreadPool::getQueueSize));
    }

    public <T extends Collector> T register(CollectorRegistry registry) {
        if (this.queuedThreadPoolMap.isEmpty()) {
            throw new IllegalStateException("You must register at least one QueuedThreadPool.");
        }
        return (T)super.register(registry);
    }

    private GaugeMetricFamily buildGauge(String metric, String help, Function<QueuedThreadPool, Integer> metricValueProvider) {
        GaugeMetricFamily metricFamily = new GaugeMetricFamily(metric, help, LABEL_NAMES);
        this.queuedThreadPoolMap.forEach((key, value) -> metricFamily.addMetric(Collections.singletonList(key), (double)((Integer)metricValueProvider.apply((QueuedThreadPool)value)).intValue()));
        return metricFamily;
    }
}

