/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs;

import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.Uri$;
import akka.stream.Materializer;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.RestAPIUtils$Result$;
import io.prophecy.libs.utils.package$;
import org.apache.spark.sql.prophecy.ProphecyEventActor$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RestAPIUtils$
implements LazyLogging {
    public static final RestAPIUtils$ MODULE$;
    private Duration defaultTimeout;
    private final transient Logger logger;
    private volatile boolean bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new RestAPIUtils$();
    }

    private Logger logger$lzycompute() {
        RestAPIUtils$ restAPIUtils$ = this;
        synchronized (restAPIUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Duration defaultTimeout() {
        if (this.bitmap$init$0) {
            return this.defaultTimeout;
        }
        throw new UninitializedFieldError("Uninitialized field: RestAPIUtils.scala: 40");
    }

    public void defaultTimeout_$eq(Duration x$1) {
        this.defaultTimeout = x$1;
        this.bitmap$init$0 = true;
    }

    private List<String> httpMethods() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONNECT", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE"}));
    }

    public Product io$prophecy$libs$RestAPIUtils$$verifyUrl(String url) {
        Try try_;
        block4: {
            Right right;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(url){
                        public static final long serialVersionUID = 0L;
                        private final String url$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            HttpRequest$.MODULE$.verifyUri(Uri$.MODULE$.apply(this.url$1));
                        }
                        {
                            this.url$1 = url$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    right = scala.package$.MODULE$.Right().apply((Object)url);
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                right = scala.package$.MODULE$.Left().apply((Object)RestAPIUtils$Result$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsing the url failed with error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error.getMessage()}))));
            }
            return right;
        }
        throw new MatchError((Object)try_);
    }

    public Product io$prophecy$libs$RestAPIUtils$$parseMethod(String method) {
        Option option;
        block4: {
            Right right;
            block3: {
                block2: {
                    option = HttpMethods$.MODULE$.getForKeyCaseInsensitive(method, Predef$.MODULE$.$conforms());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    HttpMethod value = (HttpMethod)some.x();
                    right = scala.package$.MODULE$.Right().apply((Object)value);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                right = scala.package$.MODULE$.Left().apply((Object)RestAPIUtils$Result$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported method ", ", expected one of (", " etc.)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, this.httpMethods().mkString(", ")}))));
            }
            return right;
        }
        throw new MatchError((Object)option);
    }

    public Right<Nothing$, HttpEntity.Strict> io$prophecy$libs$RestAPIUtils$$createEntity(HttpMethod method, String content) {
        HttpMethod httpMethod;
        block12: {
            HttpEntity.Strict strict;
            Right$ right$;
            block3: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    right$ = scala.package$.MODULE$.Right();
                                                    httpMethod = method;
                                                    HttpMethod httpMethod2 = HttpMethods$.MODULE$.CONNECT();
                                                    HttpMethod httpMethod3 = httpMethod;
                                                    if (httpMethod2 != null ? !httpMethod2.equals(httpMethod3) : httpMethod3 != null) break block2;
                                                    strict = HttpEntity$.MODULE$.Empty();
                                                    break block3;
                                                }
                                                HttpMethod httpMethod4 = HttpMethods$.MODULE$.DELETE();
                                                HttpMethod httpMethod5 = httpMethod;
                                                if (httpMethod4 != null ? !httpMethod4.equals(httpMethod5) : httpMethod5 != null) break block4;
                                                strict = HttpEntity$.MODULE$.Empty();
                                                break block3;
                                            }
                                            HttpMethod httpMethod6 = HttpMethods$.MODULE$.GET();
                                            HttpMethod httpMethod7 = httpMethod;
                                            if (httpMethod6 != null ? !httpMethod6.equals(httpMethod7) : httpMethod7 != null) break block5;
                                            strict = HttpEntity$.MODULE$.Empty();
                                            break block3;
                                        }
                                        HttpMethod httpMethod8 = HttpMethods$.MODULE$.HEAD();
                                        HttpMethod httpMethod9 = httpMethod;
                                        if (httpMethod8 != null ? !httpMethod8.equals(httpMethod9) : httpMethod9 != null) break block6;
                                        strict = HttpEntity$.MODULE$.Empty();
                                        break block3;
                                    }
                                    HttpMethod httpMethod10 = HttpMethods$.MODULE$.OPTIONS();
                                    HttpMethod httpMethod11 = httpMethod;
                                    if (httpMethod10 != null ? !httpMethod10.equals(httpMethod11) : httpMethod11 != null) break block7;
                                    strict = HttpEntity$.MODULE$.Empty();
                                    break block3;
                                }
                                HttpMethod httpMethod12 = HttpMethods$.MODULE$.PATCH();
                                HttpMethod httpMethod13 = httpMethod;
                                if (httpMethod12 != null ? !httpMethod12.equals(httpMethod13) : httpMethod13 != null) break block8;
                                strict = HttpEntity$.MODULE$.Empty();
                                break block3;
                            }
                            HttpMethod httpMethod14 = HttpMethods$.MODULE$.POST();
                            HttpMethod httpMethod15 = httpMethod;
                            if (httpMethod14 != null ? !httpMethod14.equals(httpMethod15) : httpMethod15 != null) break block9;
                            strict = HttpEntity$.MODULE$.apply(ContentTypes$.MODULE$.application$divjson(), content);
                            break block3;
                        }
                        HttpMethod httpMethod16 = HttpMethods$.MODULE$.PUT();
                        HttpMethod httpMethod17 = httpMethod;
                        if (httpMethod16 != null ? !httpMethod16.equals(httpMethod17) : httpMethod17 != null) break block10;
                        strict = HttpEntity$.MODULE$.apply(ContentTypes$.MODULE$.application$divjson(), content);
                        break block3;
                    }
                    HttpMethod httpMethod18 = HttpMethods$.MODULE$.TRACE();
                    HttpMethod httpMethod19 = httpMethod;
                    if (httpMethod18 != null ? !httpMethod18.equals(httpMethod19) : httpMethod19 != null) break block11;
                    strict = HttpEntity$.MODULE$.Empty();
                    break block3;
                }
                if (httpMethod == null) break block12;
                strict = HttpEntity$.MODULE$.Empty();
            }
            return right$.apply((Object)strict);
        }
        throw new MatchError((Object)httpMethod);
    }

    public Product io$prophecy$libs$RestAPIUtils$$parseHeaders(Seq<String> headers) {
        Either either;
        block4: {
            Right right;
            block3: {
                block2: {
                    either = package$.MODULE$.EitherSeq((Seq)headers.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Product apply(String header) {
                            Tuple2 tuple2;
                            block2: {
                                HttpHeader.ParsingResult parsingResult;
                                block5: {
                                    Right right;
                                    block4: {
                                        block3: {
                                            String value;
                                            String value2;
                                            tuple2 = new StringOps(Predef$.MODULE$.augmentString(header)).splitAt(header.indexOf(":"));
                                            if (tuple2 == null) break block2;
                                            String name = (String)tuple2._1();
                                            Tuple2 tuple22 = new Tuple2((Object)name, (Object)(value2 = (String)tuple2._2()));
                                            Tuple2 tuple23 = tuple22;
                                            String name2 = (String)tuple23._1();
                                            parsingResult = HttpHeader$.MODULE$.parse(name2, value = (String)tuple23._2(), HttpHeader$.MODULE$.parse$default$3());
                                            if (!(parsingResult instanceof HttpHeader.ParsingResult$.Ok)) break block3;
                                            HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                                            HttpHeader header2 = ok.header();
                                            right = scala.package$.MODULE$.Right().apply((Object)header2);
                                            break block4;
                                        }
                                        if (!(parsingResult instanceof HttpHeader.ParsingResult$.Error)) break block5;
                                        HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                                        ErrorInfo error2 = error.error();
                                        right = scala.package$.MODULE$.Left().apply((Object)RestAPIUtils$Result$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsing a header ", " failed with an error `", "`. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error2.errorHeaderName(), error2.summary(), error2.detail()}))));
                                    }
                                    return right;
                                }
                                throw new MatchError((Object)parsingResult);
                            }
                            throw new MatchError((Object)tuple2);
                        }
                    }, scala.collection.Seq$.MODULE$.canBuildFrom())).toEither();
                    if (!(either instanceof Right)) break block2;
                    Right right2 = (Right)either;
                    Seq value = (Seq)right2.b();
                    right = scala.package$.MODULE$.Right().apply((Object)Seq$.MODULE$.apply(value));
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left = (Left)either;
                Seq value = (Seq)left.a();
                right = scala.package$.MODULE$.Left().apply(value.head());
            }
            return right;
        }
        throw new MatchError(either);
    }

    public Future<String> getContent(HttpMessage message) {
        return message.entity().dataBytes().runFold((Object)ByteString$.MODULE$.apply(""), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ByteString apply(ByteString x$2, ByteString x$3) {
                return x$2.$plus$plus(x$3);
            }
        }, (Materializer)ProphecyEventActor$.MODULE$.materializer()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ByteString x$4) {
                return x$4.utf8String();
            }
        }, (ExecutionContext)ProphecyEventActor$.MODULE$.dispatcher());
    }

    private RestAPIUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.defaultTimeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute();
        this.bitmap$init$0 = true;
    }
}

