/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs.utils.sftp;

import com.databricks.dbutils_v1.DBUtilsHolder$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.prophecy.libs.utils.sftp.FTPProperties;
import io.prophecy.libs.utils.sftp.SFTPOps;
import io.prophecy.libs.utils.sftp.SFTPOps$;
import io.prophecy.libs.utils.sftp.SFTPOps$RFChunk$;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.UUID;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SFTPOps$ {
    public static final SFTPOps$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$init$0;

    static {
        new SFTPOps$();
    }

    public Logger logger() {
        if (this.bitmap$init$0) {
            return this.logger;
        }
        throw new UninitializedFieldError("Uninitialized field: SFTPOps.scala: 21");
    }

    public Dataset<Row> copyFromSFTP(FTPProperties options) {
        java.nio.file.Path sourceRoot = Paths.get(options.sourcePath(), new String[0]).getParent();
        java.nio.file.Path targetRoot = Paths.get(options.tgtPath(), new String[0]);
        Tuple2<List<RemoteResourceInfo>, List<Tuple2<RemoteResourceInfo, FileAttributes>>> tuple2 = this.listSFTP(options);
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            boolean splitsAllowed;
            Tuple2 tuple22;
            List sourceDirs = (List)tuple2._1();
            List sourceFiles = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sourceDirs, (Object)sourceFiles);
            List sourceDirs2 = (List)tuple23._1();
            List sourceFiles2 = (List)tuple23._2();
            List workFiles = (List)sourceFiles2.map((Function1)new Serializable(options, sourceRoot){
                public static final long serialVersionUID = 0L;
                private final FTPProperties options$1;
                private final java.nio.file.Path sourceRoot$1;

                public final SFTPOps.RFInfo apply(Tuple2<RemoteResourceInfo, FileAttributes> x0$1) {
                    Tuple2<RemoteResourceInfo, FileAttributes> tuple2 = x0$1;
                    if (tuple2 != null) {
                        RemoteResourceInfo sFile = (RemoteResourceInfo)tuple2._1();
                        FileAttributes fileStat = (FileAttributes)tuple2._2();
                        String relativePath = ((Object)this.sourceRoot$1.relativize(Paths.get(sFile.getPath(), new String[0]))).toString();
                        SFTPOps.RFInfo rFInfo = new SFTPOps.RFInfo(sFile.getPath(), new StringBuilder().append((Object)this.options$1.tgtPath()).append((Object)"/").append((Object)relativePath).toString(), fileStat.getSize(), fileStat.getAtime(), fileStat.getMtime(), (Seq<SFTPOps.RFChunk>)((Seq)Seq$.MODULE$.empty()));
                        return rFInfo;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.options$1 = options$1;
                    this.sourceRoot$1 = sourceRoot$1;
                }
            }, List$.MODULE$.canBuildFrom());
            List workDirs = ((List)((List)((SeqLike)sourceDirs2.map((Function1)new Serializable(options, targetRoot){
                public static final long serialVersionUID = 0L;
                private final FTPProperties options$1;
                private final java.nio.file.Path targetRoot$1;

                public final SFTPOps.RDInfo apply(RemoteResourceInfo rf) {
                    String relativePath = ((Object)this.targetRoot$1.relativize(Paths.get(rf.getPath(), new String[0]))).toString();
                    return new SFTPOps.RDInfo(rf.getPath(), new StringBuilder().append((Object)this.options$1.tgtPath()).append((Object)relativePath).toString(), relativePath);
                }
                {
                    this.options$1 = options$1;
                    this.targetRoot$1 = targetRoot$1;
                }
            }, List$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(SFTPOps.RDInfo x$2) {
                    return x$2.depth();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Path apply(SFTPOps.RDInfo rd) {
                    return new Path(rd.tgtPath());
                }
            }, List$.MODULE$.canBuildFrom())).toList();
            SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().get();
            SerializableWritable hadoopConfig = new SerializableWritable((Writable)sparkSession.sparkContext().hadoopConfiguration());
            FileSystem destFS = options.hdfsTargetPath().getFileSystem(sparkSession.sparkContext().hadoopConfiguration());
            boolean bl = splitsAllowed = !(destFS instanceof ChecksumFileSystem);
            if (BoxesRunTime.unboxToBoolean((Object)options.enableSplitTransfers().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            })) && !splitsAllowed) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Split transfers are enabled, but are not allowed.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Path tempPath = new Path(options.dfsTempPath());
            Object object = destFS.exists(tempPath) ? BoxesRunTime.boxToBoolean((boolean)destFS.delete(tempPath, true)) : BoxedUnit.UNIT;
            destFS.mkdirs(tempPath);
            destFS.deleteOnExit(tempPath);
            workDirs.foreach((Function1)new Serializable(destFS){
                public static final long serialVersionUID = 0L;
                private final FileSystem destFS$1;

                public final Object apply(Path wd) {
                    return this.destFS$1.exists(wd) ? BoxesRunTime.boxToBoolean((boolean)this.destFS$1.delete(wd, true)) : BoxedUnit.UNIT;
                }
                {
                    this.destFS$1 = destFS$1;
                }
            });
            Seq<SFTPOps.RFInfo> splitFiles = this.splitSFTPFiles((Seq<SFTPOps.RFInfo>)workFiles, options);
            RDD<SFTPOps.RFInfo> splitMap = this.createCopyJobs(splitFiles, sparkSession, (SerializableWritable<Configuration>)hadoopConfig, options);
            Tuple4[] concatResults = (Tuple4[])this.createConcatJob(splitMap, (SerializableWritable<Configuration>)hadoopConfig, options).collect();
            destFS.delete(tempPath, true);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Io_prophecy_libs_utils_sftp_SFTPOps$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor()})));
                }

                public Io_prophecy_libs_utils_sftp_SFTPOps$$typecreator1$1() {
                }
            }
            return sparkSession.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])concatResults), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_prophecy_libs_utils_sftp_SFTPOps$$typecreator1$1())).withColumnRenamed("_1", "srcPath").withColumnRenamed("_2", "tgtPath").withColumnRenamed("_3", "sftpSize").withColumnRenamed("_4", "cloudSize");
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<List<RemoteResourceInfo>, List<Tuple2<RemoteResourceInfo, FileAttributes>>> listSFTP(FTPProperties options) {
        URI srcURI = new URI(options.sourcePath());
        java.nio.file.Path srcPath = Paths.get(srcURI.getPath(), new String[0]);
        None$ glob = options.sourceIsGlob() ? new Some((Object)FileSystems.getDefault().getPathMatcher(new StringBuilder().append((Object)"glob:").append((Object)((Object)srcPath).toString()).toString())) : None$.MODULE$;
        SFTPClient client = this.sftpConnect(options);
        Buffer roots = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(client.ls(((Object)srcPath.getParent()).toString())).asScala()).filter((Function1)new Serializable(srcPath, (Option)glob){
            public static final long serialVersionUID = 0L;
            private final java.nio.file.Path srcPath$1;
            private final Option glob$1;

            public final boolean apply(RemoteResourceInfo f) {
                Option option;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            option = this.glob$1;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            PathMatcher globber = (PathMatcher)some.x();
                            bl = globber.matches(Paths.get(f.getPath(), new String[0]));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        bl = Paths.get(f.getPath(), new String[0]).startsWith(this.srcPath$1);
                    }
                    return bl;
                }
                throw new MatchError((Object)option);
            }
            {
                this.srcPath$1 = srcPath$1;
                this.glob$1 = glob$1;
            }
        });
        ArrayBuffer dirList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer fileList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Queue lsQ = (Queue)Queue$.MODULE$.apply((Seq)roots);
        while (lsQ.nonEmpty()) {
            RemoteResourceInfo lsPath = (RemoteResourceInfo)lsQ.dequeue();
            if (lsPath.isDirectory()) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(client.ls(lsPath.getPath())).asScala()).foreach((Function1)new Serializable(lsQ){
                    public static final long serialVersionUID = 0L;
                    private final Queue lsQ$1;

                    public final void apply(RemoteResourceInfo rf) {
                        this.lsQ$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RemoteResourceInfo[]{rf}));
                    }
                    {
                        this.lsQ$1 = lsQ$1;
                    }
                });
                dirList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RemoteResourceInfo[]{lsPath}));
                continue;
            }
            fileList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)lsPath, (Object)client.stat(lsPath.getPath()))}));
        }
        return new Tuple2((Object)dirList.toList(), (Object)fileList.toList());
    }

    public Seq<SFTPOps.RFInfo> splitSFTPFiles(Seq<SFTPOps.RFInfo> files, FTPProperties options) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().get();
        FileSystem tgtFS = options.hdfsTargetPath().getFileSystem(sparkSession.sparkContext().hadoopConfiguration());
        boolean splitTransfers = BoxesRunTime.unboxToBoolean((Object)options.enableSplitTransfers().getOrElse((Function0)new Serializable(tgtFS){
            public static final long serialVersionUID = 0L;
            private final FileSystem tgtFS$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !(this.tgtFS$2 instanceof ChecksumFileSystem);
            }
            {
                this.tgtFS$2 = tgtFS$2;
            }
        }));
        long blockSize = tgtFS.getDefaultBlockSize(options.hdfsTargetPath());
        long chunkSize = BoxesRunTime.unboxToLong((Object)options.chunkSize().getOrElse((Function0)new Serializable(blockSize){
            public static final long serialVersionUID = 0L;
            private final long blockSize$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.blockSize$1;
            }
            {
                this.blockSize$1 = blockSize$1;
            }
        }));
        return (Seq)files.map((Function1)new Serializable(options, splitTransfers, chunkSize){
            public static final long serialVersionUID = 0L;
            private final FTPProperties options$2;
            private final boolean splitTransfers$1;
            private final long chunkSize$1;

            public final SFTPOps.RFInfo apply(SFTPOps.RFInfo rf) {
                SFTPOps.RFInfo rFInfo;
                if (rf.size() > this.chunkSize$1 && this.splitTransfers$1) {
                    long offset = 0L;
                    long consumeSize = rf.size();
                    ArrayBuffer chunks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    while (consumeSize > 0L) {
                        long toConsume = consumeSize - this.chunkSize$1 < this.chunkSize$1 / 3L ? consumeSize : this.chunkSize$1;
                        chunks.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SFTPOps.RFChunk[]{new SFTPOps.RFChunk(new StringBuilder().append((Object)this.options$2.dfsTempPath()).append((Object)this.options$2.uploadFilePrefix()).append((Object)UUID.randomUUID().toString()).toString(), offset, toConsume, SFTPOps$RFChunk$.MODULE$.apply$default$4())}));
                        offset += (consumeSize -= toConsume) + 1L;
                    }
                    List x$3 = chunks.toList();
                    String x$4 = rf.copy$default$1();
                    String x$5 = rf.copy$default$2();
                    long x$6 = rf.copy$default$3();
                    long x$7 = rf.copy$default$4();
                    long x$8 = rf.copy$default$5();
                    rFInfo = rf.copy(x$4, x$5, x$6, x$7, x$8, (Seq<SFTPOps.RFChunk>)x$3);
                } else {
                    Seq x$9 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SFTPOps.RFChunk[]{new SFTPOps.RFChunk(new StringBuilder().append((Object)this.options$2.dfsTempPath()).append((Object)this.options$2.uploadFilePrefix()).append((Object)UUID.randomUUID().toString()).toString(), 0L, rf.size(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.chunkSize$1)))}));
                    String x$10 = rf.copy$default$1();
                    String x$11 = rf.copy$default$2();
                    long x$12 = rf.copy$default$3();
                    long x$13 = rf.copy$default$4();
                    long x$14 = rf.copy$default$5();
                    rFInfo = rf.copy(x$10, x$11, x$12, x$13, x$14, (Seq<SFTPOps.RFChunk>)x$9);
                }
                return rFInfo;
            }
            {
                this.options$2 = options$2;
                this.splitTransfers$1 = splitTransfers$1;
                this.chunkSize$1 = chunkSize$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public RDD<SFTPOps.RFInfo> createCopyJobs(Seq<SFTPOps.RFInfo> files, SparkSession sparkSession, SerializableWritable<Configuration> hadoopConfig, FTPProperties options) {
        Seq fileChunks = (Seq)files.flatMap((Function1)new Serializable(hadoopConfig){
            public static final long serialVersionUID = 0L;
            public final SerializableWritable hadoopConfig$1;

            public final Seq<Tuple3<SFTPOps.RFInfo, SFTPOps.RFChunk, SerializableWritable<Configuration>>> apply(SFTPOps.RFInfo rfi) {
                return (Seq)rfi.splits().map((Function1)new Serializable(this, rfi){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.10 $outer;
                    private final SFTPOps.RFInfo rfi$1;

                    public final Tuple3<SFTPOps.RFInfo, SFTPOps.RFChunk, SerializableWritable<Configuration>> apply(SFTPOps.RFChunk chunk) {
                        return new Tuple3((Object)this.rfi$1, (Object)chunk, (Object)this.$outer.hadoopConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rfi$1 = rfi$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.hadoopConfig$1 = hadoopConfig$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return sparkSession.sparkContext().parallelize(fileChunks, sparkSession.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final FTPProperties options$3;

            public final SFTPOps.RFInfo apply(Tuple3<SFTPOps.RFInfo, SFTPOps.RFChunk, SerializableWritable<Configuration>> x0$2) {
                Tuple3<SFTPOps.RFInfo, SFTPOps.RFChunk, SerializableWritable<Configuration>> tuple3 = x0$2;
                if (tuple3 != null) {
                    SFTPOps.RFInfo rfi = (SFTPOps.RFInfo)tuple3._1();
                    SFTPOps.RFChunk chunk = (SFTPOps.RFChunk)tuple3._2();
                    SerializableWritable hadoopConfig = (SerializableWritable)tuple3._3();
                    SFTPClient client = SFTPOps$.MODULE$.sftpConnect(this.options$3);
                    RemoteFile srcFile = client.open(rfi.srcPath());
                    byte[] bArray = new byte[(int)chunk.size()];
                    Path tgtPath = new Path(chunk.chunkFilename());
                    FileSystem tgtFS = tgtPath.getFileSystem((Configuration)hadoopConfig.value());
                    FSDataOutputStream tgtFile = tgtFS.create(tgtPath);
                    int readSize = (int)BoxesRunTime.unboxToLong((Object)chunk.wholeFileChunkSize().getOrElse((Function0)new Serializable(this, chunk){
                        public static final long serialVersionUID = 0L;
                        private final SFTPOps.RFChunk chunk$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.chunk$1.size();
                        }
                        {
                            this.chunk$1 = chunk$1;
                        }
                    }));
                    long toConsume = chunk.size();
                    int fileOffset = (int)chunk.offset();
                    while (toConsume > 0L) {
                        int thisReadSize = toConsume > (long)readSize ? readSize : (int)toConsume;
                        srcFile.read((long)fileOffset, bArray, 0, thisReadSize);
                        tgtFile.write(bArray, fileOffset, thisReadSize);
                        toConsume -= (long)thisReadSize;
                        fileOffset += thisReadSize + 1;
                    }
                    srcFile.close();
                    tgtFile.close();
                    tgtFS.close();
                    SFTPOps$.MODULE$.io$prophecy$libs$utils$sftp$SFTPOps$$disconnect(client);
                    SFTPOps.RFInfo rFInfo = rfi;
                    return rFInfo;
                }
                throw new MatchError(tuple3);
            }
            {
                this.options$3 = options$3;
            }
        }, ClassTag$.MODULE$.apply(SFTPOps.RFInfo.class)).distinct();
    }

    public RDD<Tuple4<String, String, Object, Object>> createConcatJob(RDD<SFTPOps.RFInfo> files, SerializableWritable<Configuration> hadoopConfig, FTPProperties options) {
        return files.map((Function1)new Serializable(hadoopConfig, options){
            public static final long serialVersionUID = 0L;
            private final SerializableWritable hadoopConfig$2;
            private final FTPProperties options$4;

            public final Tuple4<String, String, Object, Object> apply(SFTPOps.RFInfo rfInfo) {
                Boolean bl;
                Seq splitParts = (Seq)((TraversableLike)rfInfo.splits().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(SFTPOps.RFChunk a) {
                        return a.offset();
                    }
                }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(SFTPOps.RFChunk p) {
                        return new Path(p.chunkFilename());
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Path targetFile = new Path(rfInfo.tgtPath());
                FileSystem tgtFS = targetFile.getFileSystem((Configuration)this.hadoopConfig$2.value());
                boolean enableSplitTransfers = BoxesRunTime.unboxToBoolean((Object)this.options$4.enableSplitTransfers().getOrElse((Function0)new Serializable(this, tgtFS){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem tgtFS$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return !(this.tgtFS$1 instanceof ChecksumFileSystem);
                    }
                    {
                        this.tgtFS$1 = tgtFS$1;
                    }
                }));
                Object object = tgtFS.exists(targetFile) ? BoxesRunTime.boxToBoolean((boolean)tgtFS.delete(targetFile, true)) : BoxedUnit.UNIT;
                tgtFS.mkdirs(targetFile.getParent());
                if (enableSplitTransfers) {
                    tgtFS.concat(targetFile, (Path[])splitParts.toArray(ClassTag$.MODULE$.apply(Path.class)));
                    bl = BoxedUnit.UNIT;
                } else {
                    bl = BoxesRunTime.boxToBoolean((boolean)tgtFS.rename((Path)splitParts.head(), targetFile));
                }
                long tgtBytes = tgtFS.getUsed(targetFile);
                tgtFS.close();
                return new Tuple4((Object)rfInfo.srcPath(), (Object)rfInfo.tgtPath(), (Object)BoxesRunTime.boxToLong((long)rfInfo.size()), (Object)BoxesRunTime.boxToLong((long)tgtBytes));
            }
            {
                this.hadoopConfig$2 = hadoopConfig$2;
                this.options$4 = options$4;
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
    }

    public SFTPClient sftpConnect(FTPProperties conOpts) {
        String string2;
        block13: {
            SSHClient client;
            block12: {
                block5: {
                    Tuple2 tuple2;
                    block8: {
                        Option option;
                        block11: {
                            block7: {
                                KeyProvider keyProvider;
                                String username;
                                block10: {
                                    String kfp;
                                    block9: {
                                        Option keyFilePassphrase;
                                        block6: {
                                            client = new SSHClient();
                                            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
                                            client.connect(conOpts.host(), conOpts.port());
                                            string2 = conOpts.credType();
                                            if (!"databricksSecrets".equals(string2)) break block5;
                                            String scopeName = (String)conOpts.credentialScope().get();
                                            username = (String)conOpts.usernameSecretName().map((Function1)new Serializable(scopeName){
                                                public static final long serialVersionUID = 0L;
                                                private final String scopeName$1;

                                                public final String apply(String usn) {
                                                    return DBUtilsHolder$.MODULE$.dbutils().secrets().get(this.scopeName$1, usn);
                                                }
                                                {
                                                    this.scopeName$1 = scopeName$1;
                                                }
                                            }).orElse((Function0)new Serializable(conOpts){
                                                public static final long serialVersionUID = 0L;
                                                private final FTPProperties conOpts$1;

                                                public final Option<String> apply() {
                                                    return this.conOpts$1.textUsername();
                                                }
                                                {
                                                    this.conOpts$1 = conOpts$1;
                                                }
                                            }).get();
                                            Option password = conOpts.passwordSecretName().map((Function1)new Serializable(scopeName){
                                                public static final long serialVersionUID = 0L;
                                                private final String scopeName$1;

                                                public final String apply(String psn) {
                                                    return DBUtilsHolder$.MODULE$.dbutils().secrets().get(this.scopeName$1, psn);
                                                }
                                                {
                                                    this.scopeName$1 = scopeName$1;
                                                }
                                            }).orElse((Function0)new Serializable(conOpts){
                                                public static final long serialVersionUID = 0L;
                                                private final FTPProperties conOpts$1;

                                                public final Option<String> apply() {
                                                    return this.conOpts$1.textPassword();
                                                }
                                                {
                                                    this.conOpts$1 = conOpts$1;
                                                }
                                            });
                                            Option<String> keyFilePath = conOpts.keyFilePath();
                                            keyFilePassphrase = conOpts.keyFilePassphraseSecretName().map((Function1)new Serializable(scopeName){
                                                public static final long serialVersionUID = 0L;
                                                private final String scopeName$1;

                                                public final String apply(String ksn) {
                                                    return DBUtilsHolder$.MODULE$.dbutils().secrets().get(this.scopeName$1, ksn);
                                                }
                                                {
                                                    this.scopeName$1 = scopeName$1;
                                                }
                                            }).orElse((Function0)new Serializable(conOpts){
                                                public static final long serialVersionUID = 0L;
                                                private final FTPProperties conOpts$1;

                                                public final Option<String> apply() {
                                                    return this.conOpts$1.keyFilePassphrase();
                                                }
                                                {
                                                    this.conOpts$1 = conOpts$1;
                                                }
                                            });
                                            tuple2 = new Tuple2((Object)password, keyFilePath);
                                            if (tuple2 == null) break block6;
                                            Option option2 = (Option)tuple2._1();
                                            Option option3 = (Option)tuple2._2();
                                            if (!(option2 instanceof Some)) break block6;
                                            Some some = (Some)option2;
                                            String pwd = (String)some.x();
                                            if (!None$.MODULE$.equals(option3)) break block6;
                                            client.authPassword(username, pwd);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block7;
                                        }
                                        if (tuple2 == null) break block8;
                                        Option option4 = (Option)tuple2._1();
                                        Option option5 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option4) || !(option5 instanceof Some)) break block8;
                                        Some some = (Some)option5;
                                        kfp = (String)some.x();
                                        option = keyFilePassphrase;
                                        if (!(option instanceof Some)) break block9;
                                        Some some2 = (Some)option;
                                        String phrase = (String)some2.x();
                                        keyProvider = client.loadKeys(kfp, phrase);
                                        break block10;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block11;
                                    keyProvider = client.loadKeys(kfp);
                                }
                                KeyProvider keyLoader = keyProvider;
                                client.authPublickey(username, new KeyProvider[]{keyLoader});
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block12;
                        }
                        throw new MatchError((Object)option);
                    }
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        Option option6 = (Option)tuple2._2();
                        if (option instanceof Some && option6 instanceof Some) {
                            throw new RuntimeException("Either `password` or `keyFilePath` must be specified, not both");
                        }
                    }
                    throw new RuntimeException("Either `password` or `keyFilePath` must be specified.");
                }
                if (!"userPwd".equals(string2)) break block13;
                client.authPassword((String)conOpts.textUsername().get(), (String)conOpts.textPassword().get());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            SFTPClient sftpClient = client.newSFTPClient();
            return sftpClient;
        }
        throw new MatchError((Object)string2);
    }

    public void io$prophecy$libs$utils$sftp$SFTPOps$$disconnect(SFTPClient channel) {
        channel.close();
        channel.getSFTPEngine().close();
    }

    private SFTPOps$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply("SFTPOps");
        this.bitmap$init$0 = true;
    }
}

