/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.jsonrpc.package;
import java.util.UUID;
import org.apache.spark.annotation.Py4JWhitelist;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.InterimStore$;
import org.apache.spark.sql.InterimStrategy;
import org.apache.spark.sql.MetricsCollector$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.event.RunType$Interactive$;
import org.apache.spark.sql.event.SparkExecutionMetricsCollector;
import org.apache.spark.sql.event.Succeeded;
import org.apache.spark.sql.event.package;
import org.apache.spark.sql.event.package$PipelineStatus$SUCCEEDED$;
import org.apache.spark.sql.event.package$WorkflowProcessNodeInfo$;
import org.apache.spark.sql.executionmetrics.InMemoryStore;
import org.apache.spark.sql.executionmetrics.package;
import org.apache.spark.sql.prophecy.InterimKey;
import org.apache.spark.sql.prophecy.InterimKey$;
import org.apache.spark.sql.prophecy.InterimSummary;
import org.apache.spark.sql.prophecy.JobMetricsMetadata;
import org.apache.spark.sql.prophecy.ProphecyEventSendingListener;
import org.apache.spark.sql.prophecy.ProphecyJobCompleteEvent;
import org.apache.spark.sql.prophecy.package$;
import org.apache.spark.sql.prophecy.util.CommonUtils$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class MetricsCollector$
implements Serializable,
LazyLogging {
    public static final MetricsCollector$ MODULE$;
    private final TrieMap<SparkSession, String> org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap;
    private final TrieMap<String, ProphecyEventSendingListener> org$apache$spark$sql$MetricsCollector$$sessionIdToListener;
    private final TrieMap<String, SparkSession> org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession;
    private final TrieMap<String, InMemoryStore> sessionDataStore;
    private final String groupIdKey;
    private final String sparkConfPipelineUriKey;
    private final String sparkConfFabricIdKey;
    private final String sparkConfServiceUrlKey;
    private final String sparkConfRunTypeKey;
    private final String sparkConfJobUriKey;
    private final String sparkConfUserIdKey;
    private final String sparkConfPipelineProcessesKey;
    private final String sparkConfPipelineCodeKey;
    private final String DeltaPathPrefix;
    private final String sparkConfPipelineUUIDKey;
    private final String sparkConfExpectedInterims;
    private final String sparkConfJobBranch;
    private final String sparkConfURL;
    private final String sparkConfOffloadForTestEnabled;
    private final String sparkConfTestListenerEnabled;
    private final String sparkConfProjectID;
    private final String sparkConfPackagesPath;
    private final String disableOffload;
    private final String sparkConfPipelineMetricsTable;
    private final String sparkConfComponentMetricsTable;
    private final String sparkConfInterimsTable;
    private final String InstrumentationJobId;
    private final String InstrumentationJobDescription;
    private final String InstrumentationReadJobId;
    private final String InstrumentationReadJobDescription;
    private final transient Logger logger;
    private volatile int bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetricsCollector$();
    }

    private Logger logger$lzycompute() {
        MetricsCollector$ metricsCollector$ = this;
        synchronized (metricsCollector$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public TrieMap<SparkSession, String> org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 22");
    }

    public TrieMap<String, ProphecyEventSendingListener> org$apache$spark$sql$MetricsCollector$$sessionIdToListener() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 23");
    }

    public TrieMap<String, SparkSession> org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 24");
    }

    public TrieMap<String, InMemoryStore> sessionDataStore() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.sessionDataStore;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 25");
    }

    public Option<ProphecyEventSendingListener> getListenerFromSparkSession(SparkSession sparkSession) {
        return this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().get((Object)sparkSession).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ProphecyEventSendingListener> apply(String k) {
                return MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)k);
            }
        });
    }

    public String groupIdKey() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.groupIdKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 32");
    }

    public String sparkConfPipelineUriKey() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this.sparkConfPipelineUriKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 33");
    }

    public String sparkConfFabricIdKey() {
        if ((this.bitmap$init$0 & 0x40) != 0) {
            return this.sparkConfFabricIdKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 34");
    }

    public String sparkConfServiceUrlKey() {
        if ((this.bitmap$init$0 & 0x80) != 0) {
            return this.sparkConfServiceUrlKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 35");
    }

    public String sparkConfRunTypeKey() {
        if ((this.bitmap$init$0 & 0x100) != 0) {
            return this.sparkConfRunTypeKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 36");
    }

    public String sparkConfJobUriKey() {
        if ((this.bitmap$init$0 & 0x200) != 0) {
            return this.sparkConfJobUriKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 37");
    }

    public String sparkConfUserIdKey() {
        if ((this.bitmap$init$0 & 0x400) != 0) {
            return this.sparkConfUserIdKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 38");
    }

    public String sparkConfPipelineProcessesKey() {
        if ((this.bitmap$init$0 & 0x800) != 0) {
            return this.sparkConfPipelineProcessesKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 39");
    }

    public String sparkConfPipelineCodeKey() {
        if ((this.bitmap$init$0 & 0x1000) != 0) {
            return this.sparkConfPipelineCodeKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 40");
    }

    public String DeltaPathPrefix() {
        if ((this.bitmap$init$0 & 0x2000) != 0) {
            return this.DeltaPathPrefix;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 41");
    }

    public String sparkConfPipelineUUIDKey() {
        if ((this.bitmap$init$0 & 0x4000) != 0) {
            return this.sparkConfPipelineUUIDKey;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 42");
    }

    public String sparkConfExpectedInterims() {
        if ((this.bitmap$init$0 & 0x8000) != 0) {
            return this.sparkConfExpectedInterims;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 43");
    }

    public String sparkConfJobBranch() {
        if ((this.bitmap$init$0 & 0x10000) != 0) {
            return this.sparkConfJobBranch;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 44");
    }

    public String sparkConfURL() {
        if ((this.bitmap$init$0 & 0x20000) != 0) {
            return this.sparkConfURL;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 45");
    }

    public String sparkConfOffloadForTestEnabled() {
        if ((this.bitmap$init$0 & 0x40000) != 0) {
            return this.sparkConfOffloadForTestEnabled;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 46");
    }

    public String sparkConfTestListenerEnabled() {
        if ((this.bitmap$init$0 & 0x80000) != 0) {
            return this.sparkConfTestListenerEnabled;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 47");
    }

    public String sparkConfProjectID() {
        if ((this.bitmap$init$0 & 0x100000) != 0) {
            return this.sparkConfProjectID;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 48");
    }

    public String sparkConfPackagesPath() {
        if ((this.bitmap$init$0 & 0x200000) != 0) {
            return this.sparkConfPackagesPath;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 49");
    }

    public String disableOffload() {
        if ((this.bitmap$init$0 & 0x400000) != 0) {
            return this.disableOffload;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 50");
    }

    public String sparkConfPipelineMetricsTable() {
        if ((this.bitmap$init$0 & 0x800000) != 0) {
            return this.sparkConfPipelineMetricsTable;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 51");
    }

    public String sparkConfComponentMetricsTable() {
        if ((this.bitmap$init$0 & 0x1000000) != 0) {
            return this.sparkConfComponentMetricsTable;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 52");
    }

    public String sparkConfInterimsTable() {
        if ((this.bitmap$init$0 & 0x2000000) != 0) {
            return this.sparkConfInterimsTable;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 53");
    }

    public String InstrumentationJobId() {
        if ((this.bitmap$init$0 & 0x4000000) != 0) {
            return this.InstrumentationJobId;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 54");
    }

    public String InstrumentationJobDescription() {
        if ((this.bitmap$init$0 & 0x8000000) != 0) {
            return this.InstrumentationJobDescription;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 55");
    }

    public String InstrumentationReadJobId() {
        if ((this.bitmap$init$0 & 0x10000000) != 0) {
            return this.InstrumentationReadJobId;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 56");
    }

    public String InstrumentationReadJobDescription() {
        if ((this.bitmap$init$0 & 0x20000000) != 0) {
            return this.InstrumentationReadJobDescription;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsCollector.scala: 57");
    }

    public String getSessionAppendedKey(String key, String session) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, session}));
    }

    public Option<String> getUniqueSessionId(SparkSession session) {
        return this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().get((Object)session);
    }

    public String getSession(String sessionForInteractive) {
        return sessionForInteractive.isEmpty() ? UUID.randomUUID().toString() : sessionForInteractive;
    }

    public String getJobGroup(SparkSession spark) {
        return spark.sparkContext().getLocalProperty(this.groupIdKey());
    }

    public String getTaskIdFromGroup(SparkSession spark) {
        String jobGroup = this.getJobGroup(spark);
        String[] split2 = new StringOps(Predef$.MODULE$.augmentString(jobGroup)).split('_');
        Option jobAndRun = Predef$.MODULE$.refArrayOps((Object[])split2).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String str) {
                return str.contains("job") && str.contains("run");
            }
        });
        return (String)jobAndRun.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String str) {
                return new StringOps(Predef$.MODULE$.augmentString(str)).split('-')[3];
            }
        }).getOrElse((Function0)new Serializable(jobGroup){
            public static final long serialVersionUID = 0L;
            private final String jobGroup$1;

            public final String apply() {
                return this.jobGroup$1;
            }
            {
                this.jobGroup$1 = jobGroup$1;
            }
        });
    }

    @Py4JWhitelist
    public void initializeMetrics(SparkSession spark) {
        InterimStrategy interimStrategy = new InterimStrategy(spark);
        spark.experimental().extraStrategies_$eq((Seq)Nil$.MODULE$.$colon$colon((Object)interimStrategy));
        InterimStore$.MODULE$.reset(spark);
    }

    private void removeExistingListener(SparkSession spark, String session) {
        Option option;
        block11: {
            block10: {
                BoxedUnit boxedUnit;
                block9: {
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("checking if the session already has a listener");
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    option = this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)session);
                    if (!(option instanceof Some)) break block9;
                    Some some = (Some)option;
                    ProphecyEventSendingListener l = (ProphecyEventSendingListener)((Object)some.x());
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("removing older spark listener for session {}", new Object[]{session});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    spark.sparkContext().removeSparkListener((SparkListenerInterface)l);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    break block10;
                }
                if (!None$.MODULE$.equals(option)) break block11;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("No spark listener present for session {}", new Object[]{session});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    @Py4JWhitelist
    public synchronized void addSparkListener(SparkSession spark, String executionUrl, String session, boolean scheduled) {
        this.removeExistingListener(spark, session);
        ProphecyEventSendingListener listener = new ProphecyEventSendingListener(spark, executionUrl, session, scheduled);
        this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().update((Object)session, (Object)listener);
        spark.sparkContext().addSparkListener((SparkListenerInterface)listener);
    }

    @Py4JWhitelist
    public <R> void instrumentExternal(Function0<R> func, SparkSession spark, String pipelineId, String sessionForInteractive, List<Tuple2<Tuple3<String, String, String>, Dataset<Row>>> interimDetailsTupleList) {
        List interimDetailsWithKey = (List)interimDetailsTupleList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<InterimKey, Dataset<Row>> apply(Tuple2<Tuple3<String, String, String>, Dataset<Row>> details) {
                return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)new InterimKey((String)((Tuple3)details._1())._1(), (String)((Tuple3)details._1())._2(), (String)((Tuple3)details._1())._3())), details._2());
            }
        }, List$.MODULE$.canBuildFrom());
        this.instrument(spark, pipelineId, sessionForInteractive, (List<Tuple2<InterimKey, Dataset<Row>>>)interimDetailsWithKey, func);
    }

    public <R> void instrument(SparkSession spark, String pipelineId, String sessionForInteractive, List<Tuple2<InterimKey, Dataset<Row>>> interimDetails, Function0<R> func) {
        Try try_;
        block18: {
            try {
                BoxedUnit boxedUnit;
                Failure failure;
                Throwable throwable;
                Option option;
                this.start(spark, pipelineId, sessionForInteractive);
                try_ = Try$.MODULE$.apply(func);
                if (try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty()) {
                    BoxedUnit boxedUnit2;
                    Throwable codeException = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("-- Code execution failed --");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    this.end(spark, interimDetails);
                    throw codeException;
                }
                if (!(try_ instanceof Success)) break block18;
                if (CommonUtils$.MODULE$.isBlank(sessionForInteractive)) {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Code executed successfully");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Code executed successfully for session `{}`", new Object[]{sessionForInteractive});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
                this.end(spark, interimDetails);
            }
            catch (Throwable throwable) {
                try {
                    this.end(spark, interimDetails);
                    throw throwable;
                }
                finally {
                    InterimStore$.MODULE$.reset(spark);
                }
            }
            this.end(spark, interimDetails);
            return;
        }
        try {
            throw new MatchError((Object)try_);
        }
        finally {
            InterimStore$.MODULE$.reset(spark);
        }
    }

    public <R> String instrument$default$3() {
        return "";
    }

    public <R> List<Tuple2<InterimKey, Dataset<Row>>> instrument$default$4() {
        return Nil$.MODULE$;
    }

    @Py4JWhitelist
    public void start(SparkSession spark, String pipelineId, String sessionForInteractive) {
        BoxedUnit boxedUnit;
        String pipelineUri;
        InterimStore$.MODULE$.reset(spark);
        String session = this.getSession(sessionForInteractive);
        String string2 = pipelineUri = CommonUtils$.MODULE$.isBlank(pipelineId) ? (String)spark.conf().getOption(this.sparkConfPipelineUriKey()).getOrElse((Function0)new Serializable(pipelineId){
            public static final long serialVersionUID = 0L;
            private final String pipelineId$1;

            public final String apply() {
                return this.pipelineId$1;
            }
            {
                this.pipelineId$1 = pipelineId$1;
            }
        }) : io.prophecy.libs.metadata.package$.MODULE$.addProjectIdToProphecyUri(pipelineId, (Option<String>)spark.conf().getOption(this.sparkConfProjectID()));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                   |MetricsCollector.start method with spark ", " pipelineId ", " and sessionForInteractive ", "\n                   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{session, pipelineUri, sessionForInteractive})))).stripMargin());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession().put((Object)session, (Object)spark);
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().put((Object)spark, (Object)session);
        Option<String> executionUrlOption = this.getSparkExecutionUrl(spark);
        executionUrlOption.foreach((Function1)new Serializable(spark, pipelineId, sessionForInteractive, session, pipelineUri){
            public static final long serialVersionUID = 0L;
            public final SparkSession spark$1;
            private final String pipelineId$1;
            private final String sessionForInteractive$1;
            public final String session$1;
            private final String pipelineUri$1;

            public final void apply(String executionUrl) {
                Option option;
                block19: {
                    block16: {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        Map map;
                        Map pipelineProcesses;
                        Option prophecyURL;
                        Option branch;
                        Option userID;
                        String pipelineURI;
                        Option fabricId;
                        long timeStarted;
                        block18: {
                            block17: {
                                BoxedUnit boxedUnit3;
                                BoxedUnit boxedUnit4;
                                block15: {
                                    BoxedUnit boxedUnit5;
                                    BoxedUnit boxedUnit6;
                                    if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                                        MetricsCollector$.MODULE$.logger().underlying().info("Execution ServiceURL: {}", new Object[]{executionUrl});
                                        boxedUnit6 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit6 = BoxedUnit.UNIT;
                                    }
                                    boolean isJob = this.sessionForInteractive$1.isEmpty();
                                    MetricsCollector$.MODULE$.addSparkListener(this.spark$1, executionUrl, this.session$1, isJob);
                                    timeStarted = System.currentTimeMillis();
                                    if (!isJob) break block15;
                                    Option jobURI = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfJobUriKey());
                                    Option fabricId2 = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfFabricIdKey());
                                    Option userID2 = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfUserIdKey());
                                    Option branch2 = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfJobBranch());
                                    Option prophecyUrl = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfURL());
                                    List expectedInterims = (List)this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfExpectedInterims()).fold((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final List<InterimKey> apply() {
                                            return List$.MODULE$.empty();
                                        }
                                    }, (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final List<InterimKey> apply(String x$2) {
                                            return (List)Json$.MODULE$.parse(x$2).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InterimKey$.MODULE$.format()));
                                        }
                                    });
                                    String taskRunId = MetricsCollector$.MODULE$.getTaskIdFromGroup(this.spark$1);
                                    String uuid = UUID.randomUUID().toString();
                                    Some x$10 = new Some((Object)uuid);
                                    Option x$11 = jobURI;
                                    Some x$12 = new Some((Object)this.pipelineUri$1);
                                    Option x$13 = fabricId2;
                                    long x$14 = timeStarted;
                                    Option x$15 = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.sparkConfRunTypeKey()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$3) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
                                        }
                                    });
                                    String x$16 = taskRunId;
                                    Option x$17 = userID2;
                                    Option x$18 = branch2;
                                    Option x$19 = prophecyUrl;
                                    List x$20 = expectedInterims;
                                    JobMetricsMetadata jobMetricsMetadata = new JobMetricsMetadata((Option<String>)x$10, (Option<String>)x$11, (Option<String>)x$13, x$14, (Option<Object>)x$15, x$16, (Option<String>)x$12, (Option<String>)x$17, (Option<String>)x$18, (Option<String>)x$19, (List<InterimKey>)x$20);
                                    if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                                        MetricsCollector$.MODULE$.logger().underlying().info("JobsMetricsEvent {} spark {} with pipelineUri {}", new Object[]{jobMetricsMetadata, this.session$1, this.pipelineUri$1});
                                        boxedUnit5 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit5 = BoxedUnit.UNIT;
                                    }
                                    MetricsCollector$.MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(this.spark$1, uuid));
                                    MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)this.session$1).foreach((Function1)new Serializable(this, jobMetricsMetadata){
                                        public static final long serialVersionUID = 0L;
                                        private final JobMetricsMetadata jobMetricsMetadata$1;

                                        public final void apply(ProphecyEventSendingListener x$4) {
                                            x$4.beginJobMetricsCollection(this.jobMetricsMetadata$1);
                                        }
                                        {
                                            this.jobMetricsMetadata$1 = jobMetricsMetadata$1;
                                        }
                                    });
                                    break block16;
                                }
                                fabricId = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfFabricIdKey(), this.session$1));
                                pipelineURI = this.pipelineId$1;
                                userID = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfUserIdKey(), this.session$1));
                                branch = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfJobBranch(), this.session$1));
                                prophecyURL = this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfURL(), this.session$1));
                                pipelineProcesses = (Map)this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineProcessesKey(), this.session$1)).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Map<String, package.WorkflowProcessNodeInfo> apply(String x$5) {
                                        return (Map)Json$.MODULE$.parse(x$5).as(Reads$.MODULE$.mapReads(package$WorkflowProcessNodeInfo$.MODULE$.processWorkflowNodeInfo()));
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Map<String, Nothing$> apply() {
                                        return Predef$.MODULE$.Map().empty();
                                    }
                                });
                                option = this.spark$1.conf().getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_parts"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineCodeKey(), this.session$1)})));
                                if (!(option instanceof Some)) break block17;
                                Some some = (Some)option;
                                String parts = (String)some.x();
                                if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                                    MetricsCollector$.MODULE$.logger().underlying().info("Got code split in {} parts", new Object[]{parts});
                                    boxedUnit4 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit4 = BoxedUnit.UNIT;
                                }
                                StringBuffer compressedCodeBuffer = new StringBuffer();
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(parts)).toInt()).map((Function1)new Serializable(this, compressedCodeBuffer){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.start.1 $outer;
                                    private final StringBuffer compressedCodeBuffer$1;

                                    public final StringBuffer apply(int partID) {
                                        return this.compressedCodeBuffer$1.append(this.$outer.spark$1.conf().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineCodeKey(), this.$outer.session$1), BoxesRunTime.boxToInteger((int)partID)}))));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.compressedCodeBuffer$1 = compressedCodeBuffer$1;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                                Map rdc = (Map)Json$.MODULE$.parse(package$.MODULE$.decompress(compressedCodeBuffer.toString())).as(Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()));
                                if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                                    MetricsCollector$.MODULE$.logger().underlying().info("Final code size = {}", new Object[]{BoxesRunTime.boxToInteger((int)rdc.toString().getBytes().length)});
                                    boxedUnit3 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                                map = rdc;
                                break block18;
                            }
                            if (!None$.MODULE$.equals(option)) break block19;
                            map = (Map)this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineCodeKey(), this.session$1)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Map<String, String> apply(String compressedCode) {
                                    return (Map)Json$.MODULE$.parse(package$.MODULE$.decompress(compressedCode)).as(Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()));
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Map<String, Nothing$> apply() {
                                    return Predef$.MODULE$.Map().empty();
                                }
                            });
                        }
                        Map code = map;
                        if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                            MetricsCollector$.MODULE$.logger().underlying().info("Code received contained following files -> {}", new Object[]{code.keySet()});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        package.DatabricksJobGroupMatcher jobGroupMatcher = new package.DatabricksJobGroupMatcher("");
                        String uuid = this.spark$1.conf().get(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineUUIDKey(), this.session$1));
                        List expectedInterims = (List)this.spark$1.conf().getOption(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfExpectedInterims(), this.session$1)).fold((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<InterimKey> apply() {
                                return List$.MODULE$.empty();
                            }
                        }, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<InterimKey> apply(String x$6) {
                                return (List)Json$.MODULE$.parse(x$6).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InterimKey$.MODULE$.format()));
                            }
                        });
                        String taskRunId = MetricsCollector$.MODULE$.getTaskIdFromGroup(this.spark$1);
                        Some x$21 = new Some((Object)uuid);
                        String x$22 = "";
                        String x$23 = pipelineURI;
                        String x$24 = (String)fabricId.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        long x$25 = timeStarted;
                        RunType$Interactive$ x$26 = RunType$Interactive$.MODULE$;
                        String x$27 = taskRunId;
                        String x$28 = taskRunId;
                        String x$29 = (String)userID.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        Option x$30 = branch;
                        List x$31 = expectedInterims;
                        Map x$32 = code;
                        Option x$33 = prophecyURL;
                        SparkExecutionMetricsCollector.ExecutionMetricsMetadata executionMetricsMetadata = new SparkExecutionMetricsCollector.ExecutionMetricsMetadata((Option<String>)x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, (Option<String>)x$30, (Option<String>)x$33, (List<InterimKey>)x$31, (Map<String, String>)x$32);
                        SparkExecutionMetricsCollector.JobGroupStatusTrackRequest jobGroupStatusTrackRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackRequest(this.session$1, MetricsCollector$.MODULE$.getJobGroup(this.spark$1), jobGroupMatcher, (Option<SparkExecutionMetricsCollector.ExecutionMetricsMetadata>)new Some((Object)executionMetricsMetadata));
                        if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                            Object[] objectArray = new Object[1];
                            String x$34 = ((Object)executionMetricsMetadata).toString();
                            boolean x$35 = true;
                            int x$36 = CommonUtils$.MODULE$.truncate$default$2();
                            objectArray[0] = CommonUtils$.MODULE$.truncate(x$34, x$36, x$35);
                            MetricsCollector$.MODULE$.logger().underlying().info("Interactive metrics collection beginning with metadata {}", objectArray);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        MetricsCollector$.MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(this.spark$1, uuid));
                        ((InMemoryStore)MetricsCollector$.MODULE$.sessionDataStore().apply((Object)uuid)).updateRunUID(taskRunId, taskRunId);
                        MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)this.session$1).foreach((Function1)new Serializable(this, pipelineProcesses, jobGroupStatusTrackRequest){
                            public static final long serialVersionUID = 0L;
                            private final Map pipelineProcesses$1;
                            private final SparkExecutionMetricsCollector.JobGroupStatusTrackRequest jobGroupStatusTrackRequest$1;

                            public final void apply(ProphecyEventSendingListener x$7) {
                                x$7.beginInteractiveMetricsCollection(this.jobGroupStatusTrackRequest$1, (Map<String, package.WorkflowProcessNodeInfo>)this.pipelineProcesses$1);
                            }
                            {
                                this.pipelineProcesses$1 = pipelineProcesses$1;
                                this.jobGroupStatusTrackRequest$1 = jobGroupStatusTrackRequest$1;
                            }
                        });
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.spark$1 = spark$1;
                this.pipelineId$1 = pipelineId$1;
                this.sessionForInteractive$1 = sessionForInteractive$1;
                this.session$1 = session$1;
                this.pipelineUri$1 = pipelineUri$1;
            }
        });
    }

    public String start$default$3() {
        return "";
    }

    @Py4JWhitelist
    public void end(SparkSession spark) {
        this.end(spark, (List<Tuple2<InterimKey, Dataset<Row>>>)List$.MODULE$.empty());
    }

    public void end(SparkSession spark, List<Tuple2<InterimKey, Dataset<Row>>> interimDetails) {
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().get((Object)spark).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ProphecyEventSendingListener> apply(String k) {
                return MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().get((Object)k);
            }
        }).foreach((Function1)new Serializable(spark, interimDetails){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$2;
            private final List interimDetails$1;

            public final Object apply(ProphecyEventSendingListener listener) {
                Option option;
                block11: {
                    String uuid;
                    block10: {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        block9: {
                            BoxedUnit boxedUnit3;
                            uuid = (String)listener.metricsCollector().recordUID().getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            this.spark$2.sparkContext().listenerBus().post((SparkListenerEvent)new ProphecyJobCompleteEvent(listener.session(), (Option<InterimSummary>)new Some((Object)InterimStore$.MODULE$.apply(this.spark$2).interimSummary())));
                            if (listener.scheduled()) {
                                listener.endJobMetricsCollection(package$PipelineStatus$SUCCEEDED$.MODULE$);
                            } else {
                                Succeeded succeededResult = new Succeeded(listener.session(), "", package$PipelineStatus$SUCCEEDED$.MODULE$.entryName());
                                SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest stopRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest(succeededResult);
                                listener.endInteractiveMetricsCollection(stopRequest);
                            }
                            if (MetricsCollector$.MODULE$.logger().underlying().isInfoEnabled()) {
                                MetricsCollector$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"In memory state at the end of the run\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MetricsCollector$.MODULE$.sessionDataStore().get((Object)uuid).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(InMemoryStore x$8) {
                                        return x$8.toString();
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "*Couldn't find in memory state*";
                                    }
                                })}))).toString());
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            option = MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().remove((Object)this.spark$2);
                            if (!(option instanceof Some)) break block9;
                            Some some = (Some)option;
                            String session = (String)some.x();
                            MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$offloadMetrics(this.spark$2, session, listener, uuid, (List<Tuple2<InterimKey, Dataset<Row>>>)this.interimDetails$1);
                            boxedUnit2 = MetricsCollector$.MODULE$.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession().remove((Object)session);
                            break block10;
                        }
                        if (!None$.MODULE$.equals(option)) break block11;
                        if (MetricsCollector$.MODULE$.logger().underlying().isWarnEnabled()) {
                            MetricsCollector$.MODULE$.logger().underlying().warn("No attached session");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = boxedUnit;
                    }
                    return CommonUtils$.MODULE$.shouldOffloadInTestEnv(this.spark$2) ? BoxedUnit.UNIT : MetricsCollector$.MODULE$.sessionDataStore().remove((Object)uuid);
                }
                throw new MatchError((Object)option);
            }
            {
                this.spark$2 = spark$2;
                this.interimDetails$1 = interimDetails$1;
            }
        });
        InterimStore$.MODULE$.reset(spark);
    }

    public void org$apache$spark$sql$MetricsCollector$$offloadMetrics(SparkSession spark, String session, ProphecyEventSendingListener listener, String uuid, List<Tuple2<InterimKey, Dataset<Row>>> interimDetails) {
        Some some;
        String string2;
        Option isOffloadDisabled = listener.scheduled() ? spark.conf().getOption(this.disableOffload()) : spark.conf().getOption(this.getSessionAppendedKey(this.disableOffload(), session));
        Option option = isOffloadDisabled;
        if (option instanceof Some && "true".equals(string2 = (String)(some = (Some)option).x())) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Execution metrics are disabled. So not offloading to Metric-Sink");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            package.MetricsTableNames metricsTableNames;
            if (listener.scheduled()) {
                Option providedPipelineMetricsTable = spark.conf().getOption(this.sparkConfPipelineMetricsTable());
                Option providedComponentMetricsTable = spark.conf().getOption(this.sparkConfComponentMetricsTable());
                Option providedInterimsTable = spark.conf().getOption(this.sparkConfInterimsTable());
                metricsTableNames = new package.MetricsTableNames((Option<String>)providedPipelineMetricsTable, (Option<String>)providedComponentMetricsTable, (Option<String>)providedInterimsTable);
            } else {
                Option providedPipelineMetricsTable = spark.conf().getOption(this.getSessionAppendedKey(this.sparkConfPipelineMetricsTable(), session));
                Option providedComponentMetricsTable = spark.conf().getOption(this.getSessionAppendedKey(this.sparkConfComponentMetricsTable(), session));
                Option providedInterimsTable = spark.conf().getOption(this.getSessionAppendedKey(this.sparkConfInterimsTable(), session));
                metricsTableNames = new package.MetricsTableNames((Option<String>)providedPipelineMetricsTable, (Option<String>)providedComponentMetricsTable, (Option<String>)providedInterimsTable);
            }
            package.MetricsTableNames executionMetricTable = metricsTableNames;
            this.sessionDataStore().get((Object)uuid).foreach((Function1)new Serializable(interimDetails, executionMetricTable){
                public static final long serialVersionUID = 0L;
                private final List interimDetails$2;
                private final package.MetricsTableNames executionMetricTable$1;

                public final Tuple2<List<package.ComponentRuns>, List<String>> apply(InMemoryStore x$9) {
                    return x$9.offload(this.executionMetricTable$1, (List<Tuple2<InterimKey, Dataset<Row>>>)this.interimDetails$2);
                }
                {
                    this.interimDetails$2 = interimDetails$2;
                    this.executionMetricTable$1 = executionMetricTable$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void end() {
        if (this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().nonEmpty()) {
            ((ProphecyEventSendingListener)((Object)((Tuple2)this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener().head())._2())).sendJobPipelineEndEvent(package$PipelineStatus$SUCCEEDED$.MODULE$);
            this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().remove(((Tuple2)this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap().head())._1());
        }
    }

    private Option<String> getSparkExecutionUrl(SparkSession spark) {
        return spark.conf().getOption(this.sparkConfServiceUrlKey());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetricsCollector$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionToIdMap = new TrieMap();
        this.bitmap$init$0 |= 1;
        this.org$apache$spark$sql$MetricsCollector$$sessionIdToListener = new TrieMap();
        this.bitmap$init$0 |= 2;
        this.org$apache$spark$sql$MetricsCollector$$sparkSessionIdToSparkSession = new TrieMap();
        this.bitmap$init$0 |= 4;
        this.sessionDataStore = new TrieMap();
        this.bitmap$init$0 |= 8;
        this.groupIdKey = "spark.jobGroup.id";
        this.bitmap$init$0 |= 0x10;
        this.sparkConfPipelineUriKey = "prophecy.metadata.pipeline.uri";
        this.bitmap$init$0 |= 0x20;
        this.sparkConfFabricIdKey = "prophecy.metadata.fabric.id";
        this.bitmap$init$0 |= 0x40;
        this.sparkConfServiceUrlKey = "prophecy.execution.service.url";
        this.bitmap$init$0 |= 0x80;
        this.sparkConfRunTypeKey = "prophecy.metadata.is.interactive.run";
        this.bitmap$init$0 |= 0x100;
        this.sparkConfJobUriKey = "prophecy.metadata.job.uri";
        this.bitmap$init$0 |= 0x200;
        this.sparkConfUserIdKey = "prophecy.metadata.user.id";
        this.bitmap$init$0 |= 0x400;
        this.sparkConfPipelineProcessesKey = "prophecy.metadata.pipeline.processes";
        this.bitmap$init$0 |= 0x800;
        this.sparkConfPipelineCodeKey = "prophecy.metadata.pipeline.code";
        this.bitmap$init$0 |= 0x1000;
        this.DeltaPathPrefix = "prophecy.delta.path.prefix";
        this.bitmap$init$0 |= 0x2000;
        this.sparkConfPipelineUUIDKey = "prophecy.metadata.pipeline.uuid";
        this.bitmap$init$0 |= 0x4000;
        this.sparkConfExpectedInterims = "prophecy.metadata.expected-interims";
        this.bitmap$init$0 |= 0x8000;
        this.sparkConfJobBranch = "prophecy.metadata.job.branch";
        this.bitmap$init$0 |= 0x10000;
        this.sparkConfURL = "prophecy.metadata.url";
        this.bitmap$init$0 |= 0x20000;
        this.sparkConfOffloadForTestEnabled = "prophecy.execution.offload-for-test.enabled";
        this.bitmap$init$0 |= 0x40000;
        this.sparkConfTestListenerEnabled = "prophecy.execution.test.listener.enabled";
        this.bitmap$init$0 |= 0x80000;
        this.sparkConfProjectID = "prophecy.project.id";
        this.bitmap$init$0 |= 0x100000;
        this.sparkConfPackagesPath = "prophecy.packages.path";
        this.bitmap$init$0 |= 0x200000;
        this.disableOffload = "prophecy.execution.metrics.disabled";
        this.bitmap$init$0 |= 0x400000;
        this.sparkConfPipelineMetricsTable = "prophecy.execution.metrics.pipeline-metrics.table";
        this.bitmap$init$0 |= 0x800000;
        this.sparkConfComponentMetricsTable = "prophecy.execution.metrics.component-metrics.table";
        this.bitmap$init$0 |= 0x1000000;
        this.sparkConfInterimsTable = "prophecy.execution.metrics.interims.table";
        this.bitmap$init$0 |= 0x2000000;
        this.InstrumentationJobId = "instrumentation_write";
        this.bitmap$init$0 |= 0x4000000;
        this.InstrumentationJobDescription = "Prophecy: Write Instrumentation";
        this.bitmap$init$0 |= 0x8000000;
        this.InstrumentationReadJobId = "instrumentation_read";
        this.bitmap$init$0 |= 0x10000000;
        this.InstrumentationReadJobDescription = "Prophecy: Read Instrumentation";
        this.bitmap$init$0 |= 0x20000000;
    }
}

