/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.executionmetrics.evolutions;

import io.prophecy.libs.jsonrpc.package;
import io.prophecy.libs.jsonrpc.package$CreateDbSuffixFromUrl$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.executionmetrics.evolutions.DeltaMetricsStorageInitializer;
import org.apache.spark.sql.executionmetrics.evolutions.MetricsStorageDetails;
import org.apache.spark.sql.executionmetrics.evolutions.MetricsStore;
import org.apache.spark.sql.executionmetrics.evolutions.MetricsStore$DeltaStore$;
import org.apache.spark.sql.executionmetrics.evolutions.StorageMetadata;
import org.apache.spark.sql.executionmetrics.evolutions.TableMetadata;
import org.apache.spark.sql.executionmetrics.evolutions.TableMetadata$;
import org.apache.spark.sql.executionmetrics.pipelineruns.DeltaStorageMetadata;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Seq;

public final class MetricsStorageInitializer$ {
    public static final MetricsStorageInitializer$ MODULE$;
    private final String DefaultPipelineRunsTableName;
    private final String DefaultComponentRunsTableName;
    private final String DefaultInterimTableName;
    private volatile byte bitmap$init$0;

    static {
        new MetricsStorageInitializer$();
    }

    private String DefaultPipelineRunsTableName() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.DefaultPipelineRunsTableName;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsStorageInitializer.scala: 48");
    }

    private String DefaultComponentRunsTableName() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.DefaultComponentRunsTableName;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsStorageInitializer.scala: 49");
    }

    private String DefaultInterimTableName() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.DefaultInterimTableName;
        }
        throw new UninitializedFieldError("Uninitialized field: MetricsStorageInitializer.scala: 50");
    }

    public String schemaName(String suffix) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`prophecy_", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix}));
    }

    public String org$apache$spark$sql$executionmetrics$evolutions$MetricsStorageInitializer$$pipelineRunsTableWithSchema(String suffix) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schemaName(suffix), this.DefaultPipelineRunsTableName()}));
    }

    public String org$apache$spark$sql$executionmetrics$evolutions$MetricsStorageInitializer$$componentRunsTableWithSchema(String suffix) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schemaName(suffix), this.DefaultComponentRunsTableName()}));
    }

    public String org$apache$spark$sql$executionmetrics$evolutions$MetricsStorageInitializer$$interimsTableWithSchema(String suffix, String user) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schemaName(suffix), this.DefaultInterimTableName(), user.replaceAll("[^a-zA-Z0-9]", "_")}));
    }

    public StorageMetadata initialize(SparkSession spark, MetricsStorageDetails storageDetails, MetricsStore store, boolean readOnly) {
        MetricsStore metricsStore = store;
        if (MetricsStore$DeltaStore$.MODULE$.equals(metricsStore)) {
            DeltaStorageMetadata deltaStorageMetadata = new DeltaMetricsStorageInitializer(spark, storageDetails).initialize(readOnly);
            return deltaStorageMetadata;
        }
        throw new MatchError((Object)metricsStore);
    }

    private TableMetadata getTableMetadata(Option<String> providedFQTN, Function0<String> defaultFQTN) {
        Option<String> option;
        block4: {
            TableMetadata tableMetadata;
            block3: {
                block2: {
                    option = providedFQTN;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String fqtn = (String)some.x();
                    String[] namespaceSplit = fqtn.split("\\.");
                    tableMetadata = new TableMetadata((String)Predef$.MODULE$.refArrayOps((Object[])namespaceSplit).last(), fqtn, Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])namespaceSplit).init()).mkString("."), TableMetadata$.MODULE$.apply$default$4());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                String[] namespaceSplit = ((String)defaultFQTN.apply()).split("\\.");
                tableMetadata = new TableMetadata((String)Predef$.MODULE$.refArrayOps((Object[])namespaceSplit).last(), (String)defaultFQTN.apply(), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])namespaceSplit).init()).mkString("."), true);
            }
            return tableMetadata;
        }
        throw new MatchError(option);
    }

    public StorageMetadata createStorageMetadata(SparkSession sparkSession, package.MetricsTableNames executionMetricsTables, Option<String> dbSuffix, String user, MetricsStore metricsStore, boolean readOnly) {
        String suffix = package$CreateDbSuffixFromUrl$.MODULE$.apply(dbSuffix);
        TableMetadata pipelineMetricsTable = this.getTableMetadata(executionMetricsTables.pipelineMetrics(), (Function0<String>)new Serializable(suffix){
            public static final long serialVersionUID = 0L;
            private final String suffix$1;

            public final String apply() {
                return MetricsStorageInitializer$.MODULE$.org$apache$spark$sql$executionmetrics$evolutions$MetricsStorageInitializer$$pipelineRunsTableWithSchema(this.suffix$1);
            }
            {
                this.suffix$1 = suffix$1;
            }
        });
        TableMetadata componentMetricsTable = this.getTableMetadata(executionMetricsTables.componentMetrics(), (Function0<String>)new Serializable(suffix){
            public static final long serialVersionUID = 0L;
            private final String suffix$1;

            public final String apply() {
                return MetricsStorageInitializer$.MODULE$.org$apache$spark$sql$executionmetrics$evolutions$MetricsStorageInitializer$$componentRunsTableWithSchema(this.suffix$1);
            }
            {
                this.suffix$1 = suffix$1;
            }
        });
        TableMetadata interimsTable = this.getTableMetadata(executionMetricsTables.interims(), (Function0<String>)new Serializable(user, suffix){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String suffix$1;

            public final String apply() {
                return MetricsStorageInitializer$.MODULE$.org$apache$spark$sql$executionmetrics$evolutions$MetricsStorageInitializer$$interimsTableWithSchema(this.suffix$1, this.user$1);
            }
            {
                this.user$1 = user$1;
                this.suffix$1 = suffix$1;
            }
        });
        MetricsStorageDetails storageDetails = new MetricsStorageDetails(pipelineMetricsTable, componentMetricsTable, interimsTable, executionMetricsTables.isEmpty(), suffix);
        return this.initialize(sparkSession, storageDetails, metricsStore, readOnly);
    }

    private MetricsStorageInitializer$() {
        MODULE$ = this;
        this.DefaultPipelineRunsTableName = "pipeline_runs";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.DefaultComponentRunsTableName = "component_runs";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.DefaultInterimTableName = "interims";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

