/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs.sources.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SqlUtils$ {
    public static SqlUtils$ MODULE$;

    static {
        new SqlUtils$();
    }

    public String formatValue(Object value) {
        String string;
        block4: {
            while (true) {
                Object object;
                if ((object = value) == null) {
                    string = "NULL";
                    break block4;
                }
                if (object instanceof String) {
                    String string2 = (String)object;
                    string = new StringBuilder(2).append("'").append(string2.replaceAll("'", "''")).append("'").toString();
                    break block4;
                }
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    string = new StringBuilder(2).append("'").append(timestamp.toString()).append("'").toString();
                    break block4;
                }
                if (!(object instanceof Date)) break;
                Date date = (Date)object;
                value = new Timestamp(date.getTime());
            }
            string = value.toString();
        }
        return string;
    }

    public String getMergeStatement(String[] sourceColList, String insertSQL, String updateSQL) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        String insertStmt;
        String target = this.extractTableName(updateSQL != null ? updateSQL : insertSQL);
        String colPrefix = this.findUniquePrefix(sourceColList);
        String sourceColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceColList)).map((Function1 & java.io.Serializable & Serializable)a -> new StringBuilder(0).append(colPrefix).append((String)a).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String string = insertStmt = insertSQL != null ? new StringOps(Predef$.MODULE$.augmentString(insertSQL)).stripSuffix(";").replaceFirst(new StringBuilder(20).append("(?i)INSERT\\s+INTO\\s+").append(target).toString(), "INSERT ").replaceAll(":", colPrefix) : null;
        if (updateSQL != null) {
            String[] updateClauses = new StringOps(Predef$.MODULE$.augmentString(updateSQL.trim())).stripSuffix(";").split("(?i)WHERE ");
            String _updateStmt = updateClauses[0].trim().toUpperCase().startsWith("DELETE") ? "DELETE" : updateClauses[0].replaceFirst(new StringBuilder(19).append("(?i)UPDATE\\s+").append(target).append("\\s+SET").toString(), "UPDATE SET").replaceAll(":", colPrefix);
            String[] whereParts = updateClauses[1].split(" (?i)WITH ");
            String _matchClause = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])whereParts[0].split(" (?i)AND "))).map((Function1 & java.io.Serializable & Serializable)a -> a.replace(":", colPrefix), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" AND ");
            tuple22 = new Tuple2((Object)_updateStmt, (Object)_matchClause);
        } else {
            tuple22 = tuple2 = new Tuple2(null, (Object)"1=2");
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String updateStmt = (String)tuple2._1();
        String matchClause = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)updateStmt, (Object)matchClause);
        Tuple2 tuple24 = tuple23;
        String updateStmt2 = (String)tuple24._1();
        String matchClause2 = (String)tuple24._2();
        String mergeStmt = new StringBuilder(57).append("MERGE INTO ").append(target).append(" as target ").append("USING (VALUES %s ) AS source (").append(sourceColumns).append(") ").append("ON ").append(matchClause2).append((Object)(updateStmt2 != null ? new StringBuilder(19).append(" WHEN MATCHED THEN ").append(updateStmt2).toString() : "")).append((Object)(insertStmt != null ? new StringBuilder(23).append(" WHEN NOT MATCHED THEN ").append(insertStmt).toString() : "")).toString();
        return mergeStmt;
    }

    public String findUniquePrefix(String[] colList) {
        ObjectRef prefix = ObjectRef.create((Object)"v@");
        while (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colList)).filter((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlUtils$.$anonfun$findUniquePrefix$1(prefix, x$2))))).nonEmpty()) {
            prefix.elem = new StringBuilder(1).append((String)prefix.elem).append("@").toString();
        }
        return new StringBuilder(1).append((String)prefix.elem).append("_").toString();
    }

    public String extractTableName(String sqlClause) {
        String[] tokens = sqlClause.split("\\s+");
        return tokens[0].trim().toUpperCase().contains("UPDATE") ? tokens[1].trim() : tokens[2].trim();
    }

    public String formatRow(Row row) {
        return new StringBuilder(2).append("(").append(((TraversableOnce)row.toSeq().map((Function1 & java.io.Serializable & Serializable)x$3 -> MODULE$.formatValue(x$3), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
    }

    public void executeStmt(Statement stmt, String sqlStmt) {
        try {
            stmt.execute(sqlStmt);
        }
        catch (SQLException ex) {
            Predef$.MODULE$.println((Object)new StringBuilder(47).append("Exception while updating data. \nSQL: ").append(sqlStmt).append("\nMessage: ").append(ex.getMessage()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$findUniquePrefix$1(ObjectRef prefix$1, String x$2) {
        return x$2.toLowerCase().startsWith(new StringBuilder(1).append((String)prefix$1.elem).append("_").toString());
    }

    private SqlUtils$() {
        MODULE$ = this;
    }
}

