/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.metadata.package$;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.annotation.Py4JWhitelist;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.InterimStore$;
import org.apache.spark.sql.InterimStrategy;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.event.RunType$Interactive$;
import org.apache.spark.sql.event.SparkExecutionMetricsCollector;
import org.apache.spark.sql.event.SparkExecutionMetricsCollector$ExecutionMetricsMetadata$;
import org.apache.spark.sql.event.Succeeded;
import org.apache.spark.sql.event.package;
import org.apache.spark.sql.event.package$PipelineStatus$SUCCEEDED$;
import org.apache.spark.sql.event.package$WorkflowProcessNodeInfo$;
import org.apache.spark.sql.executionmetrics.InMemoryStore;
import org.apache.spark.sql.prophecy.JobMetricsMetadata;
import org.apache.spark.sql.prophecy.ProphecyEventSendingListener;
import org.apache.spark.sql.prophecy.ProphecyEventSendingListener$;
import org.apache.spark.sql.prophecy.util.CommonUtils$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetricsCollector$
implements scala.Serializable,
LazyLogging {
    public static MetricsCollector$ MODULE$;
    private final TrieMap<SparkSession, String> sparkSessionToIdMap;
    private final TrieMap<String, ProphecyEventSendingListener> sessionIdToListener;
    private final TrieMap<String, SparkSession> sparkSessionIdToSparkSession;
    private final TrieMap<String, Object> sparkSessionIdToEMSnoozeFlag;
    private final TrieMap<String, InMemoryStore> sessionDataStore;
    private final String groupIdKey;
    private final String sparkConfPipelineUriKey;
    private final String sparkConfFabricIdKey;
    private final String sparkConfServiceUrlKey;
    private final String sparkConfRunTypeKey;
    private final String sparkConfJobUriKey;
    private final String sparkConfUserIdKey;
    private final String sparkConfPipelineProcessesKey;
    private final String DeltaPathPrefix;
    private final String sparkConfPipelineUUIDKey;
    private final String sparkConfJobBranch;
    private final String sparkConfURL;
    private final String sparkConfTestEnabled;
    private final String sparkConfProjectID;
    private final String disableOffload;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetricsCollector$();
    }

    private Logger logger$lzycompute() {
        MetricsCollector$ metricsCollector$ = this;
        synchronized (metricsCollector$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private TrieMap<SparkSession, String> sparkSessionToIdMap() {
        return this.sparkSessionToIdMap;
    }

    private TrieMap<String, ProphecyEventSendingListener> sessionIdToListener() {
        return this.sessionIdToListener;
    }

    private TrieMap<String, SparkSession> sparkSessionIdToSparkSession() {
        return this.sparkSessionIdToSparkSession;
    }

    private TrieMap<String, Object> sparkSessionIdToEMSnoozeFlag() {
        return this.sparkSessionIdToEMSnoozeFlag;
    }

    public TrieMap<String, InMemoryStore> sessionDataStore() {
        return this.sessionDataStore;
    }

    private String groupIdKey() {
        return this.groupIdKey;
    }

    public String sparkConfPipelineUriKey() {
        return this.sparkConfPipelineUriKey;
    }

    public String sparkConfFabricIdKey() {
        return this.sparkConfFabricIdKey;
    }

    public String sparkConfServiceUrlKey() {
        return this.sparkConfServiceUrlKey;
    }

    public String sparkConfRunTypeKey() {
        return this.sparkConfRunTypeKey;
    }

    public String sparkConfJobUriKey() {
        return this.sparkConfJobUriKey;
    }

    public String sparkConfUserIdKey() {
        return this.sparkConfUserIdKey;
    }

    public String sparkConfPipelineProcessesKey() {
        return this.sparkConfPipelineProcessesKey;
    }

    public String DeltaPathPrefix() {
        return this.DeltaPathPrefix;
    }

    public String sparkConfPipelineUUIDKey() {
        return this.sparkConfPipelineUUIDKey;
    }

    public String sparkConfJobBranch() {
        return this.sparkConfJobBranch;
    }

    public String sparkConfURL() {
        return this.sparkConfURL;
    }

    public String sparkConfTestEnabled() {
        return this.sparkConfTestEnabled;
    }

    public String sparkConfProjectID() {
        return this.sparkConfProjectID;
    }

    public String disableOffload() {
        return this.disableOffload;
    }

    public String getSessionAppendedKey(String key, String session) {
        return new StringBuilder(1).append(key).append(".").append(session).toString();
    }

    public Option<String> getUniqueSessionId(SparkSession session) {
        return this.sparkSessionToIdMap().get((Object)session);
    }

    public String getSession(String sessionForInteractive) {
        return sessionForInteractive.isEmpty() ? UUID.randomUUID().toString() : sessionForInteractive;
    }

    public String getJobGroup(SparkSession spark) {
        return spark.sparkContext().getLocalProperty(this.groupIdKey());
    }

    public String getTaskIdFromGroup(SparkSession spark) {
        String jobGroup = this.getJobGroup(spark);
        String[] split = new StringOps(Predef$.MODULE$.augmentString(jobGroup)).split('_');
        Option jobAndRun = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).find((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToBoolean((boolean)MetricsCollector$.$anonfun$getTaskIdFromGroup$1(str)));
        return (String)jobAndRun.map((Function1 & Serializable & scala.Serializable)str -> new StringOps(Predef$.MODULE$.augmentString(str)).split('-')[3]).getOrElse((Function0 & Serializable & scala.Serializable)() -> jobGroup);
    }

    @Py4JWhitelist
    public void initializeMetrics(SparkSession spark) {
        InterimStrategy interimStrategy = new InterimStrategy(spark);
        spark.experimental().extraStrategies_$eq((Seq)Nil$.MODULE$.$colon$colon((Object)interimStrategy));
        InterimStore$.MODULE$.reset(spark);
    }

    @Py4JWhitelist
    public void addSparkListener(SparkSession spark, String executionUrl, String session, boolean scheduled) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("checking if the session already has a listener");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = this.sessionIdToListener().get((Object)session);
        if (option instanceof Some) {
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            ProphecyEventSendingListener l = (ProphecyEventSendingListener)((Object)some.value());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("removing older spark listener for session {}", new Object[]{session});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            spark.sparkContext().removeSparkListener((SparkListenerInterface)l);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No spark listener present for session {}", new Object[]{session});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
        } else {
            throw new MatchError((Object)option);
        }
        ProphecyEventSendingListener listener = new ProphecyEventSendingListener(executionUrl, session, scheduled);
        this.sessionIdToListener().update((Object)session, (Object)listener);
        spark.sparkContext().addSparkListener((SparkListenerInterface)listener);
    }

    @Py4JWhitelist
    public void start(SparkSession spark, String pipelineId, String sessionForInteractive) {
        BoxedUnit boxedUnit;
        String pipelineUri;
        String session = this.getSession(sessionForInteractive);
        String string = pipelineUri = CommonUtils$.MODULE$.isBlank(pipelineId) ? (String)spark.conf().getOption(this.sparkConfPipelineUriKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> pipelineId) : package$.MODULE$.addProjectIdToProphecyUri(pipelineId, (Option<String>)spark.conf().getOption(this.sparkConfProjectID()));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("\n                   | MetricsCollector.start method with spark ").append(session).append(" pipelineId ").append(pipelineUri).append(" and sessionForInteractive ").append(sessionForInteractive).append("\n                   |").toString())).stripMargin());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.sparkSessionIdToSparkSession().put((Object)session, (Object)spark);
        this.sparkSessionToIdMap().put((Object)spark, (Object)session);
        Option<String> executionUrlOption = this.getSparkExecutionUrl(spark);
        executionUrlOption.foreach((Function1 & Serializable & scala.Serializable)executionUrl -> {
            MetricsCollector$.$anonfun$start$2(sessionForInteractive, spark, session, pipelineUri, pipelineId, executionUrl);
            return BoxedUnit.UNIT;
        });
    }

    public String start$default$3() {
        return "";
    }

    @Py4JWhitelist
    public void end(SparkSession spark) {
        this.sparkSessionToIdMap().get((Object)spark).flatMap((Function1 & Serializable & scala.Serializable)k -> MODULE$.sessionIdToListener().get(k)).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            BoxedUnit boxedUnit;
            if (listener.scheduled()) {
                listener.endJobMetricsCollection(package$PipelineStatus$SUCCEEDED$.MODULE$);
            } else {
                Succeeded succeededResult = new Succeeded(listener.session(), "", package$PipelineStatus$SUCCEEDED$.MODULE$.entryName());
                SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest stopRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest(succeededResult);
                listener.endInteractiveMetricsCollection(stopRequest);
            }
            String uuid = (String)listener.metricsCollector().recordUID().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("In memory state at the end of the run\n{}", new Object[]{MODULE$.sessionDataStore().get((Object)uuid).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            MODULE$.sparkSessionToIdMap().get((Object)spark).map((Function1 & Serializable & scala.Serializable)session -> {
                Option option;
                Some some;
                String string;
                Option option2 = spark.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.disableOffload(), (String)session));
                if (option2 instanceof Some && "true".equals(string = (String)(some = (Some)option2).value())) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isInfoEnabled()) {
                        MODULE$.logger().underlying().info("Execution metrics are disabled. So not offloading to Metric-Sink");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    option = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
                } else {
                    option = MODULE$.sessionDataStore().get((Object)uuid).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.offload());
                }
                return option;
            });
            return MODULE$.sessionDataStore().remove((Object)uuid);
        });
        this.sparkSessionToIdMap().remove((Object)spark).foreach((Function1 & Serializable & scala.Serializable)sessionId -> MODULE$.sparkSessionIdToSparkSession().remove(sessionId));
        InterimStore$.MODULE$.reset(spark);
    }

    public void end() {
        block0: {
            if (!this.sparkSessionToIdMap().nonEmpty()) break block0;
            ((ProphecyEventSendingListener)((Object)((Tuple2)this.sessionIdToListener().head())._2())).sendJobPipelineEndEvent(package$PipelineStatus$SUCCEEDED$.MODULE$);
            this.sparkSessionToIdMap().remove(((Tuple2)this.sparkSessionToIdMap().head())._1());
        }
    }

    private Option<String> getSparkExecutionUrl(SparkSession spark) {
        return spark.conf().getOption(this.sparkConfServiceUrlKey());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getTaskIdFromGroup$1(String str) {
        return str.contains("job") && str.contains("run");
    }

    public static final /* synthetic */ boolean $anonfun$start$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$start$2(String sessionForInteractive$1, SparkSession spark$1, String session$1, String pipelineUri$1, String pipelineId$1, String executionUrl) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Execution ServiceURL: {}", new Object[]{executionUrl});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean isJob = sessionForInteractive$1.isEmpty();
        MetricsCollector$ metricsCollector$ = MODULE$;
        synchronized (metricsCollector$) {
            MODULE$.addSparkListener(spark$1, executionUrl, session$1, isJob);
        }
        long timeStarted = System.currentTimeMillis();
        if (isJob) {
            BoxedUnit boxedUnit2;
            Option jobURI = spark$1.conf().getOption(MODULE$.sparkConfJobUriKey());
            Option fabricId = spark$1.conf().getOption(MODULE$.sparkConfFabricIdKey());
            Option userID = spark$1.conf().getOption(MODULE$.sparkConfUserIdKey());
            Option branch = spark$1.conf().getOption(MODULE$.sparkConfJobBranch());
            Option prophecyUrl = spark$1.conf().getOption(MODULE$.sparkConfURL());
            String taskRunId = MODULE$.getTaskIdFromGroup(spark$1);
            String uuid = UUID.randomUUID().toString();
            Some x$1 = new Some((Object)uuid);
            Option x$22 = jobURI;
            Some x$32 = new Some((Object)pipelineUri$1);
            Option x$42 = fabricId;
            long x$52 = timeStarted;
            Option x$6 = spark$1.conf().getOption(MODULE$.sparkConfRunTypeKey()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsCollector$.$anonfun$start$3(x$2)));
            String x$7 = taskRunId;
            Option x$8 = userID;
            Option x$9 = branch;
            Option x$10 = prophecyUrl;
            JobMetricsMetadata jobMetricsMetadata = new JobMetricsMetadata((Option<String>)x$1, (Option<String>)x$22, (Option<String>)x$42, x$52, (Option<Object>)x$6, x$7, (Option<String>)x$32, (Option<String>)x$8, (Option<String>)x$9, (Option<String>)x$10);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("JobsMetricsEvent {} spark {} with pipelineUri {}", new Object[]{jobMetricsMetadata, session$1, pipelineUri$1});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(uuid, spark$1, (ExecutionContext)ProphecyEventSendingListener$.MODULE$.system().dispatcher()));
            MODULE$.sessionIdToListener().get((Object)session$1).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.beginJobMetricsCollection(jobMetricsMetadata);
                return BoxedUnit.UNIT;
            });
        } else {
            BoxedUnit boxedUnit3;
            Option fabricId = spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfFabricIdKey(), session$1));
            String pipelineURI = pipelineId$1;
            Option userID = spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfUserIdKey(), session$1));
            Map pipelineProcesses = (Map)spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfPipelineProcessesKey(), session$1)).map((Function1 & Serializable & scala.Serializable)x$4 -> (Map)Json$.MODULE$.parse(x$4).as(Reads$.MODULE$.mapReads(package$WorkflowProcessNodeInfo$.MODULE$.processWorkflowNodeInfo()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            package.DatabricksJobGroupMatcher jobGroupMatcher = new package.DatabricksJobGroupMatcher("");
            String uuid = spark$1.conf().get(MODULE$.getSessionAppendedKey(MODULE$.sparkConfPipelineUUIDKey(), session$1));
            String taskRunId = MODULE$.getTaskIdFromGroup(spark$1);
            SparkExecutionMetricsCollector.ExecutionMetricsMetadata executionMetricsMetadata = new SparkExecutionMetricsCollector.ExecutionMetricsMetadata((Option<String>)new Some((Object)uuid), "", pipelineURI, (String)fabricId.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), timeStarted, RunType$Interactive$.MODULE$, taskRunId, taskRunId, (String)userID.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), SparkExecutionMetricsCollector$ExecutionMetricsMetadata$.MODULE$.apply$default$10(), SparkExecutionMetricsCollector$ExecutionMetricsMetadata$.MODULE$.apply$default$11());
            SparkExecutionMetricsCollector.JobGroupStatusTrackRequest jobGroupStatusTrackRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackRequest(session$1, MODULE$.getJobGroup(spark$1), jobGroupMatcher, (Option<SparkExecutionMetricsCollector.ExecutionMetricsMetadata>)new Some((Object)executionMetricsMetadata));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Interactive metrics collection beginning with metadata {}", new Object[]{executionMetricsMetadata});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(uuid, spark$1, (ExecutionContext)ProphecyEventSendingListener$.MODULE$.system().dispatcher()));
            ((InMemoryStore)MODULE$.sessionDataStore().apply((Object)uuid)).updateRunUID(taskRunId, taskRunId);
            MODULE$.sessionIdToListener().get((Object)session$1).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.beginInteractiveMetricsCollection(jobGroupStatusTrackRequest, (Map<String, package.WorkflowProcessNodeInfo>)pipelineProcesses);
                return BoxedUnit.UNIT;
            });
        }
    }

    private MetricsCollector$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.sparkSessionToIdMap = new TrieMap();
        this.sessionIdToListener = new TrieMap();
        this.sparkSessionIdToSparkSession = new TrieMap();
        this.sparkSessionIdToEMSnoozeFlag = new TrieMap();
        this.sessionDataStore = new TrieMap();
        this.groupIdKey = "spark.jobGroup.id";
        this.sparkConfPipelineUriKey = "prophecy.metadata.pipeline.uri";
        this.sparkConfFabricIdKey = "prophecy.metadata.fabric.id";
        this.sparkConfServiceUrlKey = "prophecy.execution.service.url";
        this.sparkConfRunTypeKey = "prophecy.metadata.is.interactive.run";
        this.sparkConfJobUriKey = "prophecy.metadata.job.uri";
        this.sparkConfUserIdKey = "prophecy.metadata.user.id";
        this.sparkConfPipelineProcessesKey = "prophecy.metadata.pipeline.processes";
        this.DeltaPathPrefix = "prophecy.delta.path.prefix";
        this.sparkConfPipelineUUIDKey = "prophecy.metadata.pipeline.uuid";
        this.sparkConfJobBranch = "prophecy.metadata.job.branch";
        this.sparkConfURL = "prophecy.metadata.url";
        this.sparkConfTestEnabled = "prophecy.execution.test.enabled";
        this.sparkConfProjectID = "prophecy.project.id";
        this.disableOffload = "prophecy.execution.metrics.disabled";
    }
}

