/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.executionmetrics;

import com.databricks.dbutils_v1.DBUtilsHolder$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.spark.sql.MetricsCollector$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.executionmetrics.package;
import org.apache.spark.sql.executionmetrics.package$FileContent$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ZipFileExtractor$
implements LazyLogging {
    public static ZipFileExtractor$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ZipFileExtractor$();
    }

    private Logger logger$lzycompute() {
        ZipFileExtractor$ zipFileExtractor$ = this;
        synchronized (zipFileExtractor$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Either<RuntimeException, ZipFile> zipFile(File file) {
        String string = file.getName();
        Object object = string.endsWith(".jar") ? package$.MODULE$.Right().apply((Object)new JarFile(file)) : (string.endsWith(".whl") ? package$.MODULE$.Right().apply((Object)new ZipFile(file)) : package$.MODULE$.Left().apply((Object)new RuntimeException(new StringBuilder(21).append("Unknown Extension ").append(string).append("!! ").toString())));
        return object;
    }

    private Either<RuntimeException, List<package.FileContent>> unzip(String zipPath) {
        Left left;
        Either<RuntimeException, ZipFile> either = this.zipFile(new File(zipPath));
        if (either instanceof Right) {
            Right right = (Right)either;
            ZipFile zip = (ZipFile)right.value();
            left = package$.MODULE$.Right().apply((Object)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(zip.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)package$FileContent$.MODULE$.isCodeOrConfig(entry.getName()))).map((Function1 & Serializable & scala.Serializable)entry -> {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zip.getInputStream((ZipEntry)entry)));
                String content = package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> bufferedReader.readLine()).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZipFileExtractor$.$anonfun$unzip$4(x$1))).mkString("\n");
                return new package.FileContent(entry.getName(), content);
            }).toList());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            RuntimeException err = (RuntimeException)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<RuntimeException, List<package.FileContent>> extract(String path) {
        BoxedUnit boxedUnit;
        File file = new File(path);
        String toPath = new StringBuilder(33).append("/tmp/prophecy/workspaces/package/").append(file.getName()).toString();
        String dbfsLocalDiskPath = new StringBuilder(40).append("file:///tmp/prophecy/workspaces/package/").append(file.getName()).toString();
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DBUtilsHolder$.MODULE$.dbutils().fs().cp(path, dbfsLocalDiskPath, DBUtilsHolder$.MODULE$.dbutils().fs().cp$default$3()));
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            boolean value = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (value) {
                BoxedUnit boxedUnit2;
                File ffile = new File(toPath);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(36).append("Does file exist here ----> for path ").append(ffile.getName()).append(ffile.exists()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                    return this.unzip(toPath);
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return this.unzip(toPath);
            }
        }
        if (bl) {
            return package$.MODULE$.Left().apply((Object)new RuntimeException("Couldn't copy file."));
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable ex = failure.exception();
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(new StringBuilder(33).append("Error in case of upload for file ").append(file.getName()).toString(), ex);
            boxedUnit = BoxedUnit.UNIT;
            return this.unzip(path);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.unzip(path);
    }

    public boolean testDatabricksEnv(SparkSession spark) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DBUtilsHolder$.MODULE$.dbutils().fs().ls("dbfs:/"));
        boolean bl = try_ instanceof Failure && spark.conf().getOption(MetricsCollector$.MODULE$.sparkConfTestEnabled()).isDefined() ? true : try_ instanceof Success;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$unzip$4(String x$1) {
        return x$1 != null;
    }

    private ZipFileExtractor$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

