/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.executionmetrics.interims;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.jsonrpc.package;
import io.prophecy.libs.jsonrpc.package$Filters$;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.executionmetrics.evolutions.DeltaInitializer$;
import org.apache.spark.sql.executionmetrics.interims.DeltaInterims$;
import org.apache.spark.sql.executionmetrics.interims.InterimsTable;
import org.apache.spark.sql.executionmetrics.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!\u0002\f\u0018\u0011\u0003!c!\u0002\u0014\u0018\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\td\u0001\u0002\u0014\u0018\u0001\u0005C\u0001B\b\u0003\u0003\u0002\u0003\u0006Ia\u0014\u0005\t}\u0011\u0011\t\u0011)A\u0005e!A\u0001\t\u0002B\u0001B\u0003%!\u0007\u0003\u0005T\t\t\u0005\t\u0015a\u0003U\u0011\u0015qC\u0001\"\u0001[\u0011\u001d\tGA1A\u0005\u0002\tDaa\u0019\u0003!\u0002\u0013\u0011\u0004b\u00023\u0005\u0005\u0004%\tA\u0019\u0005\u0007K\u0012\u0001\u000b\u0011\u0002\u001a\t\u000b\u0019$A\u0011I4\t\u000f-$!\u0019!C\u0001E\"1A\u000e\u0002Q\u0001\nIBQ!\u001c\u0003\u0005B9Dq!a\u0002\u0005\t\u0003\nI\u0001C\u0004\u0002\b\u0011!\t%a\u000b\t\u000f\u0005}B\u0001\"\u0011\u0002B!9\u0011Q\u0010\u0003\u0005\u0002\u0005}\u0014!\u0004#fYR\f\u0017J\u001c;fe&l7O\u0003\u0002\u00193\u0005A\u0011N\u001c;fe&l7O\u0003\u0002\u001b7\u0005\u0001R\r_3dkRLwN\\7fiJL7m\u001d\u0006\u00039u\t1a]9m\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001\u0001\t\u0003K\u0005i\u0011a\u0006\u0002\u000e\t\u0016dG/Y%oi\u0016\u0014\u0018.\\:\u0014\u0005\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002I\u0005IA/\u00192mK:\u000bW.\u001a\u000b\u0004euz\u0004CA\u001a;\u001d\t!\u0004\b\u0005\u00026U5\taG\u0003\u00028G\u00051AH]8pizJ!!\u000f\u0016\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s)BQAP\u0002A\u0002I\nA!^:fe\")\u0001i\u0001a\u0001e\u00051\u0001O]3gSb\u001cB\u0001\u0002\u0015C\u000bB\u0011QeQ\u0005\u0003\t^\u0011Q\"\u00138uKJLWn\u001d+bE2,\u0007C\u0001$N\u001b\u00059%B\u0001%J\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tQ5*\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0015aA2p[&\u0011aj\u0012\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0005\u0002Q#6\t1$\u0003\u0002S7\ta1\u000b]1sWN+7o]5p]\u0006\u0011Qm\u0019\t\u0003+bk\u0011A\u0016\u0006\u0003/*\n!bY8oGV\u0014(/\u001a8u\u0013\tIfK\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiR!1LX0a)\taV\f\u0005\u0002&\t!)1+\u0003a\u0002)\")a$\u0003a\u0001\u001f\")a(\u0003a\u0001e!)\u0001)\u0003a\u0001e\u0005IA+\u00192mK:\u000bW.Z\u000b\u0002e\u0005QA+\u00192mK:\u000bW.\u001a\u0011\u0002!%sG/\u001a:j[NdunY1uS>t\u0017!E%oi\u0016\u0014\u0018.\\:M_\u000e\fG/[8oA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0003!\u0004\"!K5\n\u0005)T#\u0001B+oSR\fACR5fY\u0012\u001c8i\u001c7v[:t\u0015-\\3MSN$\u0018!\u0006$jK2$7oQ8mk6tg*Y7f\u0019&\u001cH\u000fI\u0001\u0004C\u0012$GCB8siZD(\u0010E\u0002Va\"L!!\u001d,\u0003\r\u0019+H/\u001e:f\u0011\u0015\u0019\u0018\u00031\u00013\u0003\r)\u0018\u000e\u001a\u0005\u0006kF\u0001\rAM\u0001\bG>tG/\u001a8u\u0011\u00159\u0018\u00031\u00013\u0003%)\b\u000fZ1uK\u0012\u0014\u0015\u0010C\u0003z#\u0001\u0007!'\u0001\u0005gC\n\u0014\u0018nY%e\u0011\u0015Y\u0018\u00031\u0001}\u0003%\u0019'/Z1uK\u0012\fE\u000fE\u0002~\u0003\u0007i\u0011A \u0006\u00039}T!!!\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000bq(!\u0003+j[\u0016\u001cH/Y7q\u0003!\tG\rZ'vYRLG\u0003DA\u0006\u0003?\t\u0019#!\n\u0002(\u0005%\u0002\u0003B+q\u0003\u001b\u0001R!a\u0004\u0002\u001aIrA!!\u0005\u0002\u00169\u0019Q'a\u0005\n\u0003-J1!a\u0006+\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0007\u0002\u001e\t!A*[:u\u0015\r\t9B\u000b\u0005\b\u0003C\u0011\u0002\u0019AA\u0007\u0003\u0011)\u0018\u000eZ:\t\u000bU\u0014\u0002\u0019\u0001\u001a\t\u000b]\u0014\u0002\u0019\u0001\u001a\t\u000be\u0014\u0002\u0019\u0001\u001a\t\u000bm\u0014\u0002\u0019\u0001?\u0015\u0015\u0005-\u0011QFA\u001d\u0003w\ti\u0004C\u0004\u00020M\u0001\r!!\r\u0002%1L7\u000f^(g\u0013\u0012$v.\u00138uKJLWn\u001d\t\u0007\u0003\u001f\tI\"a\r\u0011\u000b%\n)D\r\u001a\n\u0007\u0005]\"F\u0001\u0004UkBdWM\r\u0005\u0006oN\u0001\rA\r\u0005\u0006sN\u0001\rA\r\u0005\u0006wN\u0001\r\u0001`\u0001\u0004O\u0016$HCBA\"\u0003\u0017\ni\u0005\u0005\u0003Va\u0006\u0015\u0003\u0003B\u0015\u0002HIJ1!!\u0013+\u0005\u0019y\u0005\u000f^5p]\")1\u000f\u0006a\u0001e!9\u0011q\n\u000bA\u0002\u0005E\u0013a\u00024jYR,'o\u001d\t\u0005\u0003'\n9H\u0004\u0003\u0002V\u0005Md\u0002BA,\u0003[rA!!\u0017\u0002h9!\u00111LA1\u001d\r)\u0014QL\u0005\u0003\u0003?\n!![8\n\t\u0005\r\u0014QM\u0001\taJ|\u0007\u000f[3ds*\u0011\u0011qL\u0005\u0005\u0003S\nY'\u0001\u0003mS\n\u001c(\u0002BA2\u0003KJA!a\u001c\u0002r\u00059!n]8oeB\u001c'\u0002BA5\u0003WJA!a\u0006\u0002v)!\u0011qNA9\u0013\u0011\tI(a\u001f\u0003\u000f\u0019KG\u000e^3sg*!\u0011qCA;\u0003!9W\r\u001e\"z\u0013\u0012\u001bHCBA\u0006\u0003\u0003\u000b\u0019\tC\u0004\u0002\"U\u0001\r!!\u0004\t\u000f\u0005=S\u00031\u0001\u0002R\u0001")
public class DeltaInterims
implements InterimsTable,
LazyLogging {
    private final SparkSession spark;
    private final String user;
    private final ExecutionContext ec;
    private final String TableName;
    private final String InterimsLocation;
    private final String FieldsColumnNameList;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String tableName(String string, String string2) {
        return DeltaInterims$.MODULE$.tableName(string, string2);
    }

    private Logger logger$lzycompute() {
        DeltaInterims deltaInterims = this;
        synchronized (deltaInterims) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String TableName() {
        return this.TableName;
    }

    public String InterimsLocation() {
        return this.InterimsLocation;
    }

    @Override
    public void initialize() {
        BoxedUnit boxedUnit;
        String createTableQuery = new StringBuilder(207).append("CREATE TABLE IF NOT EXISTS ").append(this.TableName()).append(" (\n        ").append(package$.MODULE$.UID()).append(" STRING NOT NULL,\n        ").append(package$.MODULE$.Interim()).append(" STRING NOT NULL,\n        ").append(package$.MODULE$.CreatedBy()).append(" STRING NOT NULL,\n        ").append(package$.MODULE$.CreatedAt()).append(" TIMESTAMP,\n        ").append(package$.MODULE$.FabricUID()).append(" STRING) USING DELTA\n        PARTITIONED BY (").append(package$.MODULE$.CreatedBy()).append(", ").append(package$.MODULE$.FabricUID()).append(")\n          LOCATION '").append(this.InterimsLocation()).append("' ").toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(createTableQuery);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        package$.MODULE$.LoggingSparkSession(this.spark).sqlWithLogging(createTableQuery);
    }

    public String FieldsColumnNameList() {
        return this.FieldsColumnNameList;
    }

    @Override
    public Future<BoxedUnit> add(String uid, String content, String updatedBy, String fabricId, Timestamp createdAt) {
        String query = new StringBuilder(41).append("INSERT INTO ").append(this.TableName()).append("(").append(this.FieldsColumnNameList()).append(") Values('").append(uid).append("', '").append(StringEscapeUtils.escapeSql((String)content)).append("', '").append(this.user).append("', '").append(createdAt).append("', '").append(fabricId).append("')").toString();
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.LoggingSparkSession($this.spark).sqlWithLogging(query), this.ec);
    }

    @Override
    public Future<List<String>> addMulti(List<String> uids, String content, String updatedBy, String fabricId, Timestamp createdAt) {
        String columnValues = ((TraversableOnce)uids.map((Function1 & Serializable & scala.Serializable)uid -> new StringBuilder(19).append("('").append((String)uid).append("', '").append(StringEscapeUtils.escapeSql((String)content)).append("', '").append(updatedBy).append("','").append(createdAt).append("', '").append(fabricId).append("')").toString(), List$.MODULE$.canBuildFrom())).mkString(",");
        String query = new StringBuilder(28).append("INSERT INTO ").append(this.TableName()).append("(").append(package$.MODULE$.UID()).append(", ").append(package$.MODULE$.Interim()).append(", ").append(package$.MODULE$.CreatedBy()).append(", ").append(package$.MODULE$.FabricUID()).append(") Values ").append(columnValues).toString();
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.LoggingSparkSession($this.spark).sqlWithLogging(query), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> new .colon.colon((Object)content, (List)Nil$.MODULE$), this.ec);
    }

    @Override
    public Future<List<String>> addMulti(List<Tuple2<String, String>> listOfIdToInterims, String updatedBy, String fabricId, Timestamp createdAt) {
        Future future;
        String columnValues = ((TraversableOnce)listOfIdToInterims.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String uid = (String)tuple2._1();
            String interims = (String)tuple2._2();
            String string = new StringBuilder(12).append("('").append(uid).append("', '").append(StringEscapeUtils.escapeJavaScript((String)interims)).append("', '").append(createdAt).append("')").toString();
            return string;
        }, List$.MODULE$.canBuildFrom())).mkString(",");
        if (listOfIdToInterims.nonEmpty()) {
            String partitions = new StringBuilder(24).append("PARTITION (").append(package$.MODULE$.FabricUID()).append(" = '").append(fabricId).append("', ").append(package$.MODULE$.CreatedBy()).append(" = '").append(updatedBy).append("')").toString();
            String query = new StringBuilder(21).append("INSERT INTO ").append(this.TableName()).append(" ").append(partitions).append(" Values ").append(columnValues).toString();
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.LoggingSparkSession($this.spark).sqlWithLogging(query), this.ec).map((Function1 & Serializable & scala.Serializable)x$2 -> (List)listOfIdToInterims.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._2(), List$.MODULE$.canBuildFrom()), this.ec);
        } else {
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, this.ec);
        }
        return future;
    }

    @Override
    public Future<Option<String>> get(String uid, package.Filters filters) {
        String query = new StringBuilder(26).append("SELECT ").append(package$.MODULE$.Interim()).append(" FROM ").append(this.TableName()).append(" where ").append(package$.MODULE$.UID()).append(" = '").append(uid).append("' ").append(package$Filters$.MODULE$.partitionQueries(filters, package$Filters$.MODULE$.partitionQueries$default$2())).toString();
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.LoggingSparkSession($this.spark).sqlWithLogging(query).as($this.spark.implicits().newStringEncoder()).collect())).headOption(), this.ec);
    }

    @Override
    public Future<List<String>> getByIDs(List<String> uids, package.Filters filters) {
        String query = new StringBuilder(27).append("SELECT ").append(package$.MODULE$.UID()).append(" FROM ").append(this.TableName()).append(" where ").append(package$.MODULE$.UID()).append(" IN (").append(((TraversableOnce)uids.map((Function1 & Serializable & scala.Serializable)uid -> new StringBuilder(2).append("'").append((String)uid).append("'").toString(), List$.MODULE$.canBuildFrom())).mkString(",")).append(") ").append(package$Filters$.MODULE$.partitionQueries(filters, package$Filters$.MODULE$.partitionQueries$default$2())).toString();
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.LoggingSparkSession($this.spark).sqlWithLogging(query).as($this.spark.implicits().newStringEncoder()).collect())).toList(), this.ec);
    }

    public DeltaInterims(SparkSession spark, String user, String prefix, ExecutionContext ec) {
        this.spark = spark;
        this.user = user;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.TableName = DeltaInterims$.MODULE$.tableName(user, prefix);
        this.InterimsLocation = new StringBuilder(21).append(DeltaInitializer$.MODULE$.baseLocation(spark, prefix)).append("/interims/created_by=").append(user).toString();
        this.FieldsColumnNameList = new .colon.colon((Object)package$.MODULE$.UID(), (List)new .colon.colon((Object)package$.MODULE$.Interim(), (List)new .colon.colon((Object)package$.MODULE$.CreatedBy(), (List)new .colon.colon((Object)package$.MODULE$.CreatedAt(), (List)new .colon.colon((Object)package$.MODULE$.FabricUID(), (List)Nil$.MODULE$))))).mkString(",");
    }
}

