/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.jsonrpc.package;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.annotation.Py4JWhitelist;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.InterimStore$;
import org.apache.spark.sql.InterimStrategy;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.event.RunType$Interactive$;
import org.apache.spark.sql.event.SparkExecutionMetricsCollector;
import org.apache.spark.sql.event.Succeeded;
import org.apache.spark.sql.event.package;
import org.apache.spark.sql.event.package$PipelineStatus$SUCCEEDED$;
import org.apache.spark.sql.event.package$WorkflowProcessNodeInfo$;
import org.apache.spark.sql.executionmetrics.InMemoryStore;
import org.apache.spark.sql.prophecy.InterimKey;
import org.apache.spark.sql.prophecy.InterimKey$;
import org.apache.spark.sql.prophecy.InterimSummary;
import org.apache.spark.sql.prophecy.JobMetricsMetadata;
import org.apache.spark.sql.prophecy.ProphecyEventSendingListener;
import org.apache.spark.sql.prophecy.ProphecyJobCompleteEvent;
import org.apache.spark.sql.prophecy.package$;
import org.apache.spark.sql.prophecy.util.CommonUtils$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class MetricsCollector$
implements scala.Serializable,
LazyLogging {
    public static MetricsCollector$ MODULE$;
    private final TrieMap<SparkSession, String> sparkSessionToIdMap;
    private final TrieMap<String, ProphecyEventSendingListener> sessionIdToListener;
    private final TrieMap<String, SparkSession> sparkSessionIdToSparkSession;
    private final TrieMap<String, InMemoryStore> sessionDataStore;
    private final String groupIdKey;
    private final String sparkConfPipelineUriKey;
    private final String sparkConfFabricIdKey;
    private final String sparkConfServiceUrlKey;
    private final String sparkConfRunTypeKey;
    private final String sparkConfJobUriKey;
    private final String sparkConfUserIdKey;
    private final String sparkConfPipelineProcessesKey;
    private final String sparkConfPipelineCodeKey;
    private final String DeltaPathPrefix;
    private final String sparkConfPipelineUUIDKey;
    private final String sparkConfExpectedInterims;
    private final String sparkConfJobBranch;
    private final String sparkConfURL;
    private final String sparkConfOffloadForTestEnabled;
    private final String sparkConfTestListenerEnabled;
    private final String sparkConfProjectID;
    private final String sparkConfPackagesPath;
    private final String disableOffload;
    private final String sparkConfPipelineMetricsTable;
    private final String sparkConfComponentMetricsTable;
    private final String sparkConfInterimsTable;
    private final String InstrumentationJobId;
    private final String InstrumentationJobDescription;
    private final String InstrumentationReadJobId;
    private final String InstrumentationReadJobDescription;
    private transient Logger logger;
    private volatile int bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetricsCollector$();
    }

    private Logger logger$lzycompute() {
        MetricsCollector$ metricsCollector$ = this;
        synchronized (metricsCollector$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private TrieMap<SparkSession, String> sparkSessionToIdMap() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 22");
        }
        return this.sparkSessionToIdMap;
    }

    private TrieMap<String, ProphecyEventSendingListener> sessionIdToListener() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 23");
        }
        return this.sessionIdToListener;
    }

    private TrieMap<String, SparkSession> sparkSessionIdToSparkSession() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 24");
        }
        return this.sparkSessionIdToSparkSession;
    }

    public TrieMap<String, InMemoryStore> sessionDataStore() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 25");
        }
        return this.sessionDataStore;
    }

    public Option<ProphecyEventSendingListener> getListenerFromSparkSession(SparkSession sparkSession) {
        return this.sparkSessionToIdMap().get((Object)sparkSession).flatMap((Function1 & Serializable & scala.Serializable)k -> MODULE$.sessionIdToListener().get(k));
    }

    public String groupIdKey() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 32");
        }
        return this.groupIdKey;
    }

    public String sparkConfPipelineUriKey() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 33");
        }
        return this.sparkConfPipelineUriKey;
    }

    public String sparkConfFabricIdKey() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 34");
        }
        return this.sparkConfFabricIdKey;
    }

    public String sparkConfServiceUrlKey() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 35");
        }
        return this.sparkConfServiceUrlKey;
    }

    public String sparkConfRunTypeKey() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 36");
        }
        return this.sparkConfRunTypeKey;
    }

    public String sparkConfJobUriKey() {
        if ((this.bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 37");
        }
        return this.sparkConfJobUriKey;
    }

    public String sparkConfUserIdKey() {
        if ((this.bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 38");
        }
        return this.sparkConfUserIdKey;
    }

    public String sparkConfPipelineProcessesKey() {
        if ((this.bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 39");
        }
        return this.sparkConfPipelineProcessesKey;
    }

    public String sparkConfPipelineCodeKey() {
        if ((this.bitmap$init$0 & 0x1000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 40");
        }
        return this.sparkConfPipelineCodeKey;
    }

    public String DeltaPathPrefix() {
        if ((this.bitmap$init$0 & 0x2000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 41");
        }
        return this.DeltaPathPrefix;
    }

    public String sparkConfPipelineUUIDKey() {
        if ((this.bitmap$init$0 & 0x4000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 42");
        }
        return this.sparkConfPipelineUUIDKey;
    }

    public String sparkConfExpectedInterims() {
        if ((this.bitmap$init$0 & 0x8000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 43");
        }
        return this.sparkConfExpectedInterims;
    }

    public String sparkConfJobBranch() {
        if ((this.bitmap$init$0 & 0x10000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 44");
        }
        return this.sparkConfJobBranch;
    }

    public String sparkConfURL() {
        if ((this.bitmap$init$0 & 0x20000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 45");
        }
        return this.sparkConfURL;
    }

    public String sparkConfOffloadForTestEnabled() {
        if ((this.bitmap$init$0 & 0x40000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 46");
        }
        return this.sparkConfOffloadForTestEnabled;
    }

    public String sparkConfTestListenerEnabled() {
        if ((this.bitmap$init$0 & 0x80000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 47");
        }
        return this.sparkConfTestListenerEnabled;
    }

    public String sparkConfProjectID() {
        if ((this.bitmap$init$0 & 0x100000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 48");
        }
        return this.sparkConfProjectID;
    }

    public String sparkConfPackagesPath() {
        if ((this.bitmap$init$0 & 0x200000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 49");
        }
        return this.sparkConfPackagesPath;
    }

    public String disableOffload() {
        if ((this.bitmap$init$0 & 0x400000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 50");
        }
        return this.disableOffload;
    }

    public String sparkConfPipelineMetricsTable() {
        if ((this.bitmap$init$0 & 0x800000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 51");
        }
        return this.sparkConfPipelineMetricsTable;
    }

    public String sparkConfComponentMetricsTable() {
        if ((this.bitmap$init$0 & 0x1000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 52");
        }
        return this.sparkConfComponentMetricsTable;
    }

    public String sparkConfInterimsTable() {
        if ((this.bitmap$init$0 & 0x2000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 53");
        }
        return this.sparkConfInterimsTable;
    }

    public String InstrumentationJobId() {
        if ((this.bitmap$init$0 & 0x4000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 54");
        }
        return this.InstrumentationJobId;
    }

    public String InstrumentationJobDescription() {
        if ((this.bitmap$init$0 & 0x8000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 55");
        }
        return this.InstrumentationJobDescription;
    }

    public String InstrumentationReadJobId() {
        if ((this.bitmap$init$0 & 0x10000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 56");
        }
        return this.InstrumentationReadJobId;
    }

    public String InstrumentationReadJobDescription() {
        if ((this.bitmap$init$0 & 0x20000000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/MetricsCollector.scala: 57");
        }
        return this.InstrumentationReadJobDescription;
    }

    public String getSessionAppendedKey(String key, String session) {
        return new StringBuilder(1).append(key).append(".").append(session).toString();
    }

    public Option<String> getUniqueSessionId(SparkSession session) {
        return this.sparkSessionToIdMap().get((Object)session);
    }

    public String getSession(String sessionForInteractive) {
        return sessionForInteractive.isEmpty() ? UUID.randomUUID().toString() : sessionForInteractive;
    }

    public String getJobGroup(SparkSession spark) {
        return spark.sparkContext().getLocalProperty(this.groupIdKey());
    }

    public String getTaskIdFromGroup(SparkSession spark) {
        String jobGroup = this.getJobGroup(spark);
        String[] split = new StringOps(Predef$.MODULE$.augmentString(jobGroup)).split('_');
        Option jobAndRun = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).find((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToBoolean((boolean)MetricsCollector$.$anonfun$getTaskIdFromGroup$1(str)));
        return (String)jobAndRun.map((Function1 & Serializable & scala.Serializable)str -> new StringOps(Predef$.MODULE$.augmentString(str)).split('-')[3]).getOrElse((Function0 & Serializable & scala.Serializable)() -> jobGroup);
    }

    @Py4JWhitelist
    public void initializeMetrics(SparkSession spark) {
        InterimStrategy interimStrategy = new InterimStrategy(spark);
        spark.experimental().extraStrategies_$eq((Seq)Nil$.MODULE$.$colon$colon((Object)interimStrategy));
        InterimStore$.MODULE$.reset(spark);
    }

    private void removeExistingListener(SparkSession spark, String session) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("checking if the session already has a listener");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = this.sessionIdToListener().get((Object)session);
        if (option instanceof Some) {
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            ProphecyEventSendingListener l = (ProphecyEventSendingListener)((Object)some.value());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("removing older spark listener for session {}", new Object[]{session});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            spark.sparkContext().removeSparkListener((SparkListenerInterface)l);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No spark listener present for session {}", new Object[]{session});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Py4JWhitelist
    public synchronized void addSparkListener(SparkSession spark, String executionUrl, String session, boolean scheduled) {
        this.removeExistingListener(spark, session);
        ProphecyEventSendingListener listener = new ProphecyEventSendingListener(spark, executionUrl, session, scheduled);
        this.sessionIdToListener().update((Object)session, (Object)listener);
        spark.sparkContext().addSparkListener((SparkListenerInterface)listener);
    }

    @Py4JWhitelist
    public <R> void instrumentExternal(Function0<R> func, SparkSession spark, String pipelineId, String sessionForInteractive, List<Tuple2<Tuple3<String, String, String>, Dataset<Row>>> interimDetailsTupleList) {
        List interimDetailsWithKey = (List)interimDetailsTupleList.map((Function1 & Serializable & scala.Serializable)details -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)new InterimKey((String)((Tuple3)details._1())._1(), (String)((Tuple3)details._1())._2(), (String)((Tuple3)details._1())._3())), details._2()), List$.MODULE$.canBuildFrom());
        this.instrument(spark, pipelineId, sessionForInteractive, (List<Tuple2<InterimKey, Dataset<Row>>>)interimDetailsWithKey, func);
    }

    public <R> void instrument(SparkSession spark, String pipelineId, String sessionForInteractive, List<Tuple2<InterimKey, Dataset<Row>>> interimDetails, Function0<R> func) {
        try {
            BoxedUnit boxedUnit;
            Failure failure;
            Throwable throwable;
            Option option;
            this.start(spark, pipelineId, sessionForInteractive);
            Try try_ = Try$.MODULE$.apply(func);
            if (try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty()) {
                BoxedUnit boxedUnit2;
                Throwable codeException = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("-- Code execution failed --");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.end(spark, interimDetails);
                throw codeException;
            }
            if (try_ instanceof Success) {
                if (CommonUtils$.MODULE$.isBlank(sessionForInteractive)) {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Code executed successfully");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Code executed successfully for session `{}`", new Object[]{sessionForInteractive});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit3 = boxedUnit;
            this.end(spark, interimDetails);
        }
        finally {
            try {
                this.end(spark, interimDetails);
            }
            finally {
                InterimStore$.MODULE$.reset(spark);
            }
        }
    }

    public <R> String instrument$default$3() {
        return "";
    }

    public <R> List<Tuple2<InterimKey, Dataset<Row>>> instrument$default$4() {
        return Nil$.MODULE$;
    }

    @Py4JWhitelist
    public void start(SparkSession spark, String pipelineId, String sessionForInteractive) {
        BoxedUnit boxedUnit;
        String pipelineUri;
        InterimStore$.MODULE$.reset(spark);
        String session = this.getSession(sessionForInteractive);
        String string = pipelineUri = CommonUtils$.MODULE$.isBlank(pipelineId) ? (String)spark.conf().getOption(this.sparkConfPipelineUriKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> pipelineId) : io.prophecy.libs.metadata.package$.MODULE$.addProjectIdToProphecyUri(pipelineId, (Option<String>)spark.conf().getOption(this.sparkConfProjectID()));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n                   |MetricsCollector.start method with spark ").append(session).append(" pipelineId ").append(pipelineUri).append(" and sessionForInteractive ").append(sessionForInteractive).append("\n                   |").toString())).stripMargin());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.sparkSessionIdToSparkSession().put((Object)session, (Object)spark);
        this.sparkSessionToIdMap().put((Object)spark, (Object)session);
        Option<String> executionUrlOption = this.getSparkExecutionUrl(spark);
        executionUrlOption.foreach((Function1 & Serializable & scala.Serializable)executionUrl -> {
            MetricsCollector$.$anonfun$start$2(sessionForInteractive, spark, session, pipelineUri, pipelineId, executionUrl);
            return BoxedUnit.UNIT;
        });
    }

    public String start$default$3() {
        return "";
    }

    @Py4JWhitelist
    public void end(SparkSession spark) {
        this.end(spark, (List<Tuple2<InterimKey, Dataset<Row>>>)List$.MODULE$.empty());
    }

    public void end(SparkSession spark, List<Tuple2<InterimKey, Dataset<Row>>> interimDetails) {
        this.sparkSessionToIdMap().get((Object)spark).flatMap((Function1 & Serializable & scala.Serializable)k -> MODULE$.sessionIdToListener().get(k)).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            String uuid = (String)listener.metricsCollector().recordUID().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            spark.sparkContext().listenerBus().post((SparkListenerEvent)new ProphecyJobCompleteEvent(listener.session(), (Option<InterimSummary>)new Some((Object)InterimStore$.MODULE$.apply(spark).interimSummary())));
            if (listener.scheduled()) {
                listener.endJobMetricsCollection(package$PipelineStatus$SUCCEEDED$.MODULE$);
            } else {
                Succeeded succeededResult = new Succeeded(listener.session(), "", package$PipelineStatus$SUCCEEDED$.MODULE$.entryName());
                SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest stopRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackStopRequest(succeededResult);
                listener.endInteractiveMetricsCollection(stopRequest);
            }
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(new StringBuilder(38).append("In memory state at the end of the run\n").append(MODULE$.sessionDataStore().get((Object)uuid).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "*Couldn't find in memory state*")).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Option option = MODULE$.sparkSessionToIdMap().remove((Object)spark);
            if (option instanceof Some) {
                Some some = (Some)option;
                String session = (String)some.value();
                MODULE$.offloadMetrics(spark, session, (ProphecyEventSendingListener)((Object)listener), uuid, interimDetails);
                boxedUnit = MODULE$.sparkSessionIdToSparkSession().remove((Object)session);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit3;
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("No attached session");
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit3;
            } else {
                throw new MatchError((Object)option);
            }
            return !CommonUtils$.MODULE$.shouldOffloadInTestEnv(spark) ? MODULE$.sessionDataStore().remove((Object)uuid) : BoxedUnit.UNIT;
        });
        InterimStore$.MODULE$.reset(spark);
    }

    private void offloadMetrics(SparkSession spark, String session, ProphecyEventSendingListener listener, String uuid, List<Tuple2<InterimKey, Dataset<Row>>> interimDetails) {
        Some some;
        String string;
        Option isOffloadDisabled = listener.scheduled() ? spark.conf().getOption(this.disableOffload()) : spark.conf().getOption(this.getSessionAppendedKey(this.disableOffload(), session));
        Option option = isOffloadDisabled;
        if (option instanceof Some && "true".equals(string = (String)(some = (Some)option).value())) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Execution metrics are disabled. So not offloading to Metric-Sink");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            package.MetricsTableNames metricsTableNames;
            if (listener.scheduled()) {
                Option providedPipelineMetricsTable = spark.conf().getOption(this.sparkConfPipelineMetricsTable());
                Option providedComponentMetricsTable = spark.conf().getOption(this.sparkConfComponentMetricsTable());
                Option providedInterimsTable = spark.conf().getOption(this.sparkConfInterimsTable());
                metricsTableNames = new package.MetricsTableNames((Option<String>)providedPipelineMetricsTable, (Option<String>)providedComponentMetricsTable, (Option<String>)providedInterimsTable);
            } else {
                Option providedPipelineMetricsTable = spark.conf().getOption(this.getSessionAppendedKey(this.sparkConfPipelineMetricsTable(), session));
                Option providedComponentMetricsTable = spark.conf().getOption(this.getSessionAppendedKey(this.sparkConfComponentMetricsTable(), session));
                Option providedInterimsTable = spark.conf().getOption(this.getSessionAppendedKey(this.sparkConfInterimsTable(), session));
                metricsTableNames = new package.MetricsTableNames((Option<String>)providedPipelineMetricsTable, (Option<String>)providedComponentMetricsTable, (Option<String>)providedInterimsTable);
            }
            package.MetricsTableNames executionMetricTable = metricsTableNames;
            this.sessionDataStore().get((Object)uuid).foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.offload(executionMetricTable, interimDetails));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void end() {
        block0: {
            if (!this.sparkSessionToIdMap().nonEmpty()) break block0;
            ((ProphecyEventSendingListener)((Object)((Tuple2)this.sessionIdToListener().head())._2())).sendJobPipelineEndEvent(package$PipelineStatus$SUCCEEDED$.MODULE$);
            this.sparkSessionToIdMap().remove(((Tuple2)this.sparkSessionToIdMap().head())._1());
        }
    }

    private Option<String> getSparkExecutionUrl(SparkSession spark) {
        return spark.conf().getOption(this.sparkConfServiceUrlKey());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getTaskIdFromGroup$1(String str) {
        return str.contains("job") && str.contains("run");
    }

    public static final /* synthetic */ boolean $anonfun$start$5(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$start$2(String sessionForInteractive$1, SparkSession spark$1, String session$1, String pipelineUri$1, String pipelineId$1, String executionUrl) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Execution ServiceURL: {}", new Object[]{executionUrl});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean isJob = sessionForInteractive$1.isEmpty();
        MODULE$.addSparkListener(spark$1, executionUrl, session$1, isJob);
        long timeStarted = System.currentTimeMillis();
        if (isJob) {
            BoxedUnit boxedUnit2;
            Option jobURI = spark$1.conf().getOption(MODULE$.sparkConfJobUriKey());
            Option fabricId = spark$1.conf().getOption(MODULE$.sparkConfFabricIdKey());
            Option userID = spark$1.conf().getOption(MODULE$.sparkConfUserIdKey());
            Option branch = spark$1.conf().getOption(MODULE$.sparkConfJobBranch());
            Option prophecyUrl = spark$1.conf().getOption(MODULE$.sparkConfURL());
            List expectedInterims = (List)spark$1.conf().getOption(MODULE$.sparkConfExpectedInterims()).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$2 -> (List)Json$.MODULE$.parse(x$2).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InterimKey$.MODULE$.format())));
            String taskRunId = MODULE$.getTaskIdFromGroup(spark$1);
            String uuid = UUID.randomUUID().toString();
            Some x$1 = new Some((Object)uuid);
            Option x$22 = jobURI;
            Some x$32 = new Some((Object)pipelineUri$1);
            Option x$42 = fabricId;
            long x$52 = timeStarted;
            Option x$62 = spark$1.conf().getOption(MODULE$.sparkConfRunTypeKey()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsCollector$.$anonfun$start$5(x$3)));
            String x$72 = taskRunId;
            Option x$8 = userID;
            Option x$9 = branch;
            Option x$10 = prophecyUrl;
            List x$11 = expectedInterims;
            JobMetricsMetadata jobMetricsMetadata = new JobMetricsMetadata((Option<String>)x$1, (Option<String>)x$22, (Option<String>)x$42, x$52, (Option<Object>)x$62, x$72, (Option<String>)x$32, (Option<String>)x$8, (Option<String>)x$9, (Option<String>)x$10, (List<InterimKey>)x$11);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("JobsMetricsEvent {} spark {} with pipelineUri {}", new Object[]{jobMetricsMetadata, session$1, pipelineUri$1});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(spark$1, uuid));
            MODULE$.sessionIdToListener().get((Object)session$1).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.beginJobMetricsCollection(jobMetricsMetadata);
                return BoxedUnit.UNIT;
            });
        } else {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Map map;
            Option fabricId = spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfFabricIdKey(), session$1));
            String pipelineURI = pipelineId$1;
            Option userID = spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfUserIdKey(), session$1));
            Option branch = spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfJobBranch(), session$1));
            Option prophecyURL = spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfURL(), session$1));
            Map pipelineProcesses = (Map)spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfPipelineProcessesKey(), session$1)).map((Function1 & Serializable & scala.Serializable)x$5 -> (Map)Json$.MODULE$.parse(x$5).as(Reads$.MODULE$.mapReads(package$WorkflowProcessNodeInfo$.MODULE$.processWorkflowNodeInfo()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            Option option = spark$1.conf().getOption(new StringBuilder(6).append(MODULE$.getSessionAppendedKey(MODULE$.sparkConfPipelineCodeKey(), session$1)).append("_parts").toString());
            if (option instanceof Some) {
                BoxedUnit boxedUnit5;
                BoxedUnit boxedUnit6;
                Some some = (Some)option;
                String parts = (String)some.value();
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Got code split in {} parts", new Object[]{parts});
                    boxedUnit6 = BoxedUnit.UNIT;
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                StringBuffer compressedCodeBuffer = new StringBuffer();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(parts)).toInt()).map((Function1 & Serializable & scala.Serializable)partID -> compressedCodeBuffer.append(spark$1.conf().get(new StringBuilder(1).append(MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.sparkConfPipelineCodeKey(), session$1)).append("_").append(BoxesRunTime.unboxToInt((Object)partID)).toString())), IndexedSeq$.MODULE$.canBuildFrom());
                Map rdc = (Map)Json$.MODULE$.parse(package$.MODULE$.decompress(compressedCodeBuffer.toString())).as(Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()));
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Final code size = {}", new Object[]{BoxesRunTime.boxToInteger((int)rdc.toString().getBytes().length)});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                map = rdc;
            } else if (None$.MODULE$.equals(option)) {
                map = (Map)spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfPipelineCodeKey(), session$1)).map((Function1 & Serializable & scala.Serializable)compressedCode -> (Map)Json$.MODULE$.parse(package$.MODULE$.decompress((String)compressedCode)).as(Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            } else {
                throw new MatchError((Object)option);
            }
            Map code = map;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Code received contained following files -> {}", new Object[]{code.keySet()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            package.DatabricksJobGroupMatcher jobGroupMatcher = new package.DatabricksJobGroupMatcher("");
            String uuid = spark$1.conf().get(MODULE$.getSessionAppendedKey(MODULE$.sparkConfPipelineUUIDKey(), session$1));
            List expectedInterims = (List)spark$1.conf().getOption(MODULE$.getSessionAppendedKey(MODULE$.sparkConfExpectedInterims(), session$1)).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$6 -> (List)Json$.MODULE$.parse(x$6).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InterimKey$.MODULE$.format())));
            String taskRunId = MODULE$.getTaskIdFromGroup(spark$1);
            Some x$12 = new Some((Object)uuid);
            String x$13 = "";
            String x$14 = pipelineURI;
            String x$15 = (String)fabricId.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            long x$16 = timeStarted;
            RunType$Interactive$ x$17 = RunType$Interactive$.MODULE$;
            String x$18 = taskRunId;
            String x$19 = taskRunId;
            String x$20 = (String)userID.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Option x$21 = branch;
            List x$22 = expectedInterims;
            Map x$23 = code;
            Option x$24 = prophecyURL;
            SparkExecutionMetricsCollector.ExecutionMetricsMetadata executionMetricsMetadata = new SparkExecutionMetricsCollector.ExecutionMetricsMetadata((Option<String>)x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option<String>)x$21, (Option<String>)x$24, (List<InterimKey>)x$22, (Map<String, String>)x$23);
            SparkExecutionMetricsCollector.JobGroupStatusTrackRequest jobGroupStatusTrackRequest = new SparkExecutionMetricsCollector.JobGroupStatusTrackRequest(session$1, MODULE$.getJobGroup(spark$1), jobGroupMatcher, (Option<SparkExecutionMetricsCollector.ExecutionMetricsMetadata>)new Some((Object)executionMetricsMetadata));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                Object[] objectArray = new Object[1];
                String x$25 = executionMetricsMetadata.toString();
                boolean x$26 = true;
                int x$27 = CommonUtils$.MODULE$.truncate$default$2();
                objectArray[0] = CommonUtils$.MODULE$.truncate(x$25, x$27, x$26);
                MODULE$.logger().underlying().info("Interactive metrics collection beginning with metadata {}", objectArray);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            MODULE$.sessionDataStore().putIfAbsent((Object)uuid, (Object)new InMemoryStore(spark$1, uuid));
            ((InMemoryStore)MODULE$.sessionDataStore().apply((Object)uuid)).updateRunUID(taskRunId, taskRunId);
            MODULE$.sessionIdToListener().get((Object)session$1).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.beginInteractiveMetricsCollection(jobGroupStatusTrackRequest, (Map<String, package.WorkflowProcessNodeInfo>)pipelineProcesses);
                return BoxedUnit.UNIT;
            });
        }
    }

    private MetricsCollector$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.sparkSessionToIdMap = new TrieMap();
        this.bitmap$init$0 |= 1;
        this.sessionIdToListener = new TrieMap();
        this.bitmap$init$0 |= 2;
        this.sparkSessionIdToSparkSession = new TrieMap();
        this.bitmap$init$0 |= 4;
        this.sessionDataStore = new TrieMap();
        this.bitmap$init$0 |= 8;
        this.groupIdKey = "spark.jobGroup.id";
        this.bitmap$init$0 |= 0x10;
        this.sparkConfPipelineUriKey = "prophecy.metadata.pipeline.uri";
        this.bitmap$init$0 |= 0x20;
        this.sparkConfFabricIdKey = "prophecy.metadata.fabric.id";
        this.bitmap$init$0 |= 0x40;
        this.sparkConfServiceUrlKey = "prophecy.execution.service.url";
        this.bitmap$init$0 |= 0x80;
        this.sparkConfRunTypeKey = "prophecy.metadata.is.interactive.run";
        this.bitmap$init$0 |= 0x100;
        this.sparkConfJobUriKey = "prophecy.metadata.job.uri";
        this.bitmap$init$0 |= 0x200;
        this.sparkConfUserIdKey = "prophecy.metadata.user.id";
        this.bitmap$init$0 |= 0x400;
        this.sparkConfPipelineProcessesKey = "prophecy.metadata.pipeline.processes";
        this.bitmap$init$0 |= 0x800;
        this.sparkConfPipelineCodeKey = "prophecy.metadata.pipeline.code";
        this.bitmap$init$0 |= 0x1000;
        this.DeltaPathPrefix = "prophecy.delta.path.prefix";
        this.bitmap$init$0 |= 0x2000;
        this.sparkConfPipelineUUIDKey = "prophecy.metadata.pipeline.uuid";
        this.bitmap$init$0 |= 0x4000;
        this.sparkConfExpectedInterims = "prophecy.metadata.expected-interims";
        this.bitmap$init$0 |= 0x8000;
        this.sparkConfJobBranch = "prophecy.metadata.job.branch";
        this.bitmap$init$0 |= 0x10000;
        this.sparkConfURL = "prophecy.metadata.url";
        this.bitmap$init$0 |= 0x20000;
        this.sparkConfOffloadForTestEnabled = "prophecy.execution.offload-for-test.enabled";
        this.bitmap$init$0 |= 0x40000;
        this.sparkConfTestListenerEnabled = "prophecy.execution.test.listener.enabled";
        this.bitmap$init$0 |= 0x80000;
        this.sparkConfProjectID = "prophecy.project.id";
        this.bitmap$init$0 |= 0x100000;
        this.sparkConfPackagesPath = "prophecy.packages.path";
        this.bitmap$init$0 |= 0x200000;
        this.disableOffload = "prophecy.execution.metrics.disabled";
        this.bitmap$init$0 |= 0x400000;
        this.sparkConfPipelineMetricsTable = "prophecy.execution.metrics.pipeline-metrics.table";
        this.bitmap$init$0 |= 0x800000;
        this.sparkConfComponentMetricsTable = "prophecy.execution.metrics.component-metrics.table";
        this.bitmap$init$0 |= 0x1000000;
        this.sparkConfInterimsTable = "prophecy.execution.metrics.interims.table";
        this.bitmap$init$0 |= 0x2000000;
        this.InstrumentationJobId = "instrumentation_write";
        this.bitmap$init$0 |= 0x4000000;
        this.InstrumentationJobDescription = "Prophecy: Write Instrumentation";
        this.bitmap$init$0 |= 0x8000000;
        this.InstrumentationReadJobId = "instrumentation_read";
        this.bitmap$init$0 |= 0x10000000;
        this.InstrumentationReadJobDescription = "Prophecy: Read Instrumentation";
        this.bitmap$init$0 |= 0x20000000;
    }
}

