/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.crosssupport;

import io.prophecy.libs.AbinitioDMLs;
import io.prophecy.libs.AbinitioDMLs$file_information_type$;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ozone.OzoneFileSystem;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class SparkFunctionsCrossSupport$ {
    public static SparkFunctionsCrossSupport$ MODULE$;

    static {
        new SparkFunctionsCrossSupport$();
    }

    public Column string_join(Column column, String delimiter) {
        return functions$.MODULE$.array_join(column, delimiter);
    }

    public Column array_except(Column column1, Column column2) {
        return functions$.MODULE$.array_except(column1, column2);
    }

    public Column array_position(Column column, Object value) {
        return functions$.MODULE$.array_position(column, value);
    }

    public Column element_at(Column input, Column index) {
        return functions$.MODULE$.element_at(input, (Object)index);
    }

    public AbinitioDMLs.file_information_type file_information_def(String inputPath, boolean useLocalFileSystem) {
        FileStatus fileStatus;
        byte readable = 0;
        byte writable = 0;
        byte executable = 0;
        byte found = 0;
        if (inputPath.startsWith("o3fs:")) {
            OzoneFileSystem ozoneFS = new OzoneFileSystem();
            ozoneFS.initialize(new URI(inputPath), new Configuration());
            fileStatus = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ozoneFS.listStatus(new Path(inputPath)))).head();
        } else if (useLocalFileSystem) {
            LocalFileSystem localFS = new LocalFileSystem();
            localFS.initialize(new URI(new StringBuilder(7).append("file://").append(inputPath).toString()), new Configuration());
            fileStatus = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localFS.listStatus(new Path(inputPath)))).head();
        } else if (inputPath.startsWith("hdfs:")) {
            Path sourcePath = new Path(inputPath);
            FileSystem sourceFileSystem = sourcePath.getFileSystem(new Configuration());
            fileStatus = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFileSystem.listStatus(sourcePath))).head();
        } else {
            Configuration configuration = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)configuration);
            String filePath = inputPath.startsWith("mfs/") ? inputPath.substring(3) : inputPath;
            Path curPath = new Path(filePath);
            fileStatus = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(curPath))).head();
        }
        FileStatus status = fileStatus;
        try {
            String userPermission = status.getPermission().getUserAction().SYMBOL;
            String groupPermission = status.getPermission().getGroupAction().SYMBOL;
            String otherPermission = status.getPermission().getOtherAction().SYMBOL;
            found = 1;
            if (userPermission.charAt(0) == 'r' && groupPermission.charAt(0) == 'r' && otherPermission.charAt(0) == 'r') {
                readable = 1;
            }
            if (userPermission.charAt(1) == 'w' && groupPermission.charAt(1) == 'w' && otherPermission.charAt(1) == 'w') {
                writable = 1;
            }
            if (otherPermission.charAt(2) == 'x' && groupPermission.charAt(2) == 'x' && otherPermission.charAt(2) == 'x') {
                executable = 1;
            }
        }
        catch (Throwable throwable) {}
        long x$1 = status.getModificationTime() / 1000L;
        long x$2 = status.getLen();
        String x$3 = status.getGroup();
        String x$4 = status.getOwner();
        long x$5 = status.getLen() / status.getBlockSize();
        String x$6 = status.isDirectory() ? "DIR" : "FILE";
        byte x$7 = readable;
        byte x$8 = writable;
        byte x$9 = executable;
        byte x$10 = found;
        long x$11 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$8();
        long x$12 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$9();
        long x$13 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$10();
        long x$14 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$11();
        long x$15 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$12();
        return new AbinitioDMLs.file_information_type(x$10, x$7, x$8, x$9, x$6, x$2, x$5, x$11, x$12, x$13, x$14, x$15, x$1, x$4, x$3);
    }

    public boolean file_information_def$default$2() {
        return false;
    }

    public Column zip_eventInfo_arrays(Column column1, Column column2) {
        return functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{column1, column2}));
    }

    public Column getFieldFromStructByPosition(Column column, int position) {
        return column.getField(String.valueOf(BoxesRunTime.boxToInteger((int)(position - 1))));
    }

    private SparkFunctionsCrossSupport$() {
        MODULE$ = this;
    }
}

