/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.executionmetrics.evolutions;

import io.prophecy.libs.jsonrpc.package;
import io.prophecy.libs.jsonrpc.package$CreateDbSuffixFromUrl$;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.executionmetrics.evolutions.DeltaMetricsStorageInitializer;
import org.apache.spark.sql.executionmetrics.evolutions.MetricsStorageDetails;
import org.apache.spark.sql.executionmetrics.evolutions.MetricsStore;
import org.apache.spark.sql.executionmetrics.evolutions.MetricsStore$DeltaStore$;
import org.apache.spark.sql.executionmetrics.evolutions.StorageMetadata;
import org.apache.spark.sql.executionmetrics.evolutions.TableMetadata;
import org.apache.spark.sql.executionmetrics.evolutions.TableMetadata$;
import org.apache.spark.sql.executionmetrics.pipelineruns.DeltaStorageMetadata;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.mutable.ArrayOps;

public final class MetricsStorageInitializer$ {
    public static MetricsStorageInitializer$ MODULE$;
    private final String DefaultPipelineRunsTableName;
    private final String DefaultComponentRunsTableName;
    private final String DefaultInterimTableName;
    private volatile byte bitmap$init$0;

    static {
        new MetricsStorageInitializer$();
    }

    private String DefaultPipelineRunsTableName() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/executionmetrics/evolutions/MetricsStorageInitializer.scala: 48");
        }
        return this.DefaultPipelineRunsTableName;
    }

    private String DefaultComponentRunsTableName() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/executionmetrics/evolutions/MetricsStorageInitializer.scala: 49");
        }
        return this.DefaultComponentRunsTableName;
    }

    private String DefaultInterimTableName() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/lib/jenkins/workspace/cloud_team_scala_prophecy_libs_thin/src/main/scala/org/apache/spark/sql/executionmetrics/evolutions/MetricsStorageInitializer.scala: 50");
        }
        return this.DefaultInterimTableName;
    }

    public String schemaName(String suffix) {
        return new StringBuilder(11).append("`prophecy_").append(suffix).append("`").toString();
    }

    private String pipelineRunsTableWithSchema(String suffix) {
        return new StringBuilder(1).append(this.schemaName(suffix)).append(".").append(this.DefaultPipelineRunsTableName()).toString();
    }

    private String componentRunsTableWithSchema(String suffix) {
        return new StringBuilder(1).append(this.schemaName(suffix)).append(".").append(this.DefaultComponentRunsTableName()).toString();
    }

    private String interimsTableWithSchema(String suffix, String user) {
        return new StringBuilder(1).append(this.schemaName(suffix)).append(".").append(this.DefaultInterimTableName()).append(user.replaceAll("[^a-zA-Z0-9]", "_")).toString();
    }

    public StorageMetadata initialize(SparkSession spark, MetricsStorageDetails storageDetails, MetricsStore store, boolean readOnly) {
        MetricsStore metricsStore = store;
        if (!MetricsStore$DeltaStore$.MODULE$.equals(metricsStore)) {
            throw new MatchError((Object)metricsStore);
        }
        DeltaStorageMetadata deltaStorageMetadata = new DeltaMetricsStorageInitializer(spark, storageDetails).initialize(readOnly);
        return deltaStorageMetadata;
    }

    private TableMetadata getTableMetadata(Option<String> providedFQTN, Function0<String> defaultFQTN) {
        TableMetadata tableMetadata;
        Option<String> option = providedFQTN;
        if (option instanceof Some) {
            Some some = (Some)option;
            String fqtn = (String)some.value();
            String[] namespaceSplit = fqtn.split("\\.");
            tableMetadata = new TableMetadata((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaceSplit)).last(), fqtn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaceSplit)).init())).mkString("."), TableMetadata$.MODULE$.apply$default$4());
        } else if (None$.MODULE$.equals(option)) {
            String[] namespaceSplit = ((String)defaultFQTN.apply()).split("\\.");
            tableMetadata = new TableMetadata((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaceSplit)).last(), (String)defaultFQTN.apply(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaceSplit)).init())).mkString("."), true);
        } else {
            throw new MatchError(option);
        }
        return tableMetadata;
    }

    public StorageMetadata createStorageMetadata(SparkSession sparkSession, package.MetricsTableNames executionMetricsTables, Option<String> dbSuffix, String user, MetricsStore metricsStore, boolean readOnly) {
        String suffix = package$CreateDbSuffixFromUrl$.MODULE$.apply(dbSuffix);
        TableMetadata pipelineMetricsTable = this.getTableMetadata(executionMetricsTables.pipelineMetrics(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.pipelineRunsTableWithSchema(suffix));
        TableMetadata componentMetricsTable = this.getTableMetadata(executionMetricsTables.componentMetrics(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.componentRunsTableWithSchema(suffix));
        TableMetadata interimsTable = this.getTableMetadata(executionMetricsTables.interims(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.interimsTableWithSchema(suffix, user));
        MetricsStorageDetails storageDetails = new MetricsStorageDetails(pipelineMetricsTable, componentMetricsTable, interimsTable, executionMetricsTables.isEmpty(), suffix);
        return this.initialize(sparkSession, storageDetails, metricsStore, readOnly);
    }

    private MetricsStorageInitializer$() {
        MODULE$ = this;
        this.DefaultPipelineRunsTableName = "pipeline_runs";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.DefaultComponentRunsTableName = "component_runs";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.DefaultInterimTableName = "interims";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

