/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api.mounts;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.mounts.MountPayload;
import com.bettercloud.vault.api.mounts.MountType;
import com.bettercloud.vault.response.EnterpriseMountResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;

public class EnterpriseMounts {
    private final VaultConfig config;
    private final String internalMountsPath = "v1/sys/internal/ui/mounts";

    public EnterpriseMounts(VaultConfig vaultConfig) {
        this.config = vaultConfig;
    }

    public EnterpriseMountResponse list() throws VaultException {
        int n = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/%s", this.config.getAddress(), "v1/sys/internal/ui/mounts")).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.config.getNameSpace()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(Boolean.valueOf(this.config.getSslConfig().isVerify())).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200) {
                    String string = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + string, restResponse.getStatus());
                }
                return new EnterpriseMountResponse(restResponse, n, true);
            }
            catch (Exception exception) {
                if (n < this.config.getMaxRetries()) {
                    ++n;
                    try {
                        int n2 = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                if (exception instanceof VaultException) {
                    throw (VaultException)exception;
                }
                throw new VaultException((Throwable)exception);
            }
            break;
        }
    }

    public EnterpriseMountResponse enable(String string, MountType mountType, MountPayload mountPayload) throws VaultException {
        int n = 0;
        while (true) {
            try {
                if (mountType == null) {
                    throw new VaultException("Mount type is missing");
                }
                if (mountPayload == null) {
                    throw new VaultException("MountPayload is missing");
                }
                String string2 = mountPayload.toEnableJson(mountType).toString();
                RestResponse restResponse = new Rest().url(String.format("%s/%s/%s", this.config.getAddress(), "v1/sys/internal/ui/mounts", string)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.config.getNameSpace()).body(string2.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(Boolean.valueOf(this.config.getSslConfig().isVerify())).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    String string3 = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + string3, restResponse.getStatus());
                }
                return new EnterpriseMountResponse(restResponse, n, false);
            }
            catch (Exception exception) {
                if (n < this.config.getMaxRetries()) {
                    ++n;
                    try {
                        int n2 = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                if (exception instanceof VaultException) {
                    throw (VaultException)exception;
                }
                throw new VaultException((Throwable)exception);
            }
            break;
        }
    }

    public EnterpriseMountResponse disable(String string) throws VaultException {
        int n = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/%s/%s", this.config.getAddress(), "v1/sys/internal/ui/mounts", string)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.config.getNameSpace()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(Boolean.valueOf(this.config.getSslConfig().isVerify())).sslContext(this.config.getSslConfig().getSslContext()).delete();
                if (restResponse.getStatus() != 204) {
                    String string2 = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + string2, restResponse.getStatus());
                }
                return new EnterpriseMountResponse(restResponse, n, false);
            }
            catch (Exception exception) {
                if (n < this.config.getMaxRetries()) {
                    ++n;
                    try {
                        int n2 = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                if (exception instanceof VaultException) {
                    throw (VaultException)exception;
                }
                throw new VaultException((Throwable)exception);
            }
            break;
        }
    }

    public EnterpriseMountResponse read(String string) throws VaultException {
        int n = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/%s/%s/tune", this.config.getAddress(), "v1/sys/internal/ui/mounts", string)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.config.getNameSpace()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(Boolean.valueOf(this.config.getSslConfig().isVerify())).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                    String string2 = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + string2, restResponse.getStatus());
                }
                return new EnterpriseMountResponse(restResponse, n, false);
            }
            catch (Exception exception) {
                if (n < this.config.getMaxRetries()) {
                    ++n;
                    try {
                        int n2 = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                if (exception instanceof VaultException) {
                    throw (VaultException)exception;
                }
                throw new VaultException((Throwable)exception);
            }
            break;
        }
    }

    public EnterpriseMountResponse tune(String string, MountPayload mountPayload) throws VaultException {
        int n = 0;
        while (true) {
            try {
                if (mountPayload == null) {
                    throw new VaultException("MountPayload is missing");
                }
                String string2 = mountPayload.toTuneJson().toString();
                RestResponse restResponse = new Rest().url(String.format("%s/%s/%s/tune", this.config.getAddress(), "v1/sys/internal/ui/mounts", string)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.config.getNameSpace()).body(string2.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(Boolean.valueOf(this.config.getSslConfig().isVerify())).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    String string3 = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + string3, restResponse.getStatus());
                }
                return new EnterpriseMountResponse(restResponse, n, false);
            }
            catch (Exception exception) {
                if (n < this.config.getMaxRetries()) {
                    ++n;
                    try {
                        int n2 = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                if (exception instanceof VaultException) {
                    throw (VaultException)exception;
                }
                throw new VaultException((Throwable)exception);
            }
            break;
        }
    }
}

