/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.response;

import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.api.mounts.EnterpriseMount;
import com.bettercloud.vault.api.mounts.MountConfig;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.json.JsonValue;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.rest.RestResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class EnterpriseMountResponse
extends LogicalResponse {
    private static final long serialVersionUID = -7066405243425032451L;
    private final EnterpriseMount mount;
    private final Map<String, EnterpriseMount> mounts;

    public EnterpriseMountResponse(RestResponse restResponse, int n, boolean bl) {
        super(restResponse, n, Logical.logicalOperations.mount);
        this.mount = bl ? null : this.buildMount(this.getDataObject());
        this.mounts = bl ? this.buildMountsMap() : null;
    }

    public EnterpriseMount getMount() {
        return this.mount;
    }

    public Map<String, EnterpriseMount> getMounts() {
        return this.mounts;
    }

    private EnterpriseMount buildMount(JsonObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        String string = jsonObject.getString("type");
        String string2 = jsonObject.getString("description");
        MountConfig mountConfig = this.buildMountConfig(jsonObject);
        Boolean bl = jsonObject.getBoolean("local");
        Boolean bl2 = jsonObject.getBoolean("seal_wrap");
        if (string == null && string2 == null && mountConfig == null && bl == null && bl2 == null) {
            return null;
        }
        return new EnterpriseMount().type(string).description(string2).config(mountConfig).local(bl).sealWrap(bl2);
    }

    private MountConfig buildMountConfig(JsonObject jsonObject) {
        JsonObject jsonObject2;
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        JsonValue jsonValue = jsonObject.get("config");
        JsonObject jsonObject3 = jsonObject2 = jsonValue != null ? jsonValue.asObject() : jsonObject;
        if (jsonObject2 == null || jsonObject2.isEmpty()) {
            return null;
        }
        Integer n = jsonObject2.getInt("default_lease_ttl");
        Integer n2 = jsonObject2.getInt("max_lease_ttl");
        String string = jsonObject2.getString("description");
        Boolean bl = jsonObject2.getBoolean("force_no_cache");
        String string2 = jsonObject2.getString("plugin_name");
        if (n == null && n2 == null && string == null && bl == null && string2 == null) {
            return null;
        }
        return new MountConfig().defaultLeaseTtl(n).maxLeaseTtl(n2).description(string).forceNoCache(bl).pluginName(string2);
    }

    private Map<String, EnterpriseMount> buildMountsMap() {
        JsonObject jsonObject = this.getDataObject();
        if (jsonObject == null || jsonObject.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, JsonObject> hashMap = new HashMap<String, JsonObject>();
        for (String string : jsonObject.names()) {
            JsonValue jsonValue = jsonObject.get(string);
            if (jsonValue == null || !jsonValue.isObject()) continue;
            JsonObject jsonObject2 = jsonValue.asObject();
            for (String string2 : jsonObject2.names()) {
                JsonValue jsonValue2 = jsonObject2.get(string2);
                if (jsonValue2 == null || !jsonValue2.isObject()) continue;
                hashMap.put(string2, jsonValue2.asObject());
            }
        }
        return hashMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.buildMount((JsonObject)entry.getValue())));
    }
}

