/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.alteryx.language;

import io.prophecy.abinitio.xfr.ast.BinOpCustomExpression;
import io.prophecy.abinitio.xfr.ast.BooleanLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.ByteLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.ConditionalNullLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.CustomExpression;
import io.prophecy.abinitio.xfr.ast.DoubleLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.ExpressionLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.FloatLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.FunctionCustomExpression;
import io.prophecy.abinitio.xfr.ast.IntLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.LiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.LongLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.NoneLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.NullLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.SimpleCustomExpression;
import io.prophecy.abinitio.xfr.ast.StringLiteralCustomTerm;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.runtime.RichChar$;
import scala.util.Random$;

public final class ExpressionEvaluator$ {
    public static ExpressionEvaluator$ MODULE$;

    static {
        new ExpressionEvaluator$();
    }

    public String getExpressionResult(CustomExpression parsedExpression) {
        String string;
        LiteralCustomTerm evaluatedLiteral = this.evaluateToLiteral(parsedExpression);
        LiteralCustomTerm literalCustomTerm = evaluatedLiteral;
        if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm = (BooleanLiteralCustomTerm)literalCustomTerm;
            string = Boolean.toString(booleanLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
            IntLiteralCustomTerm intLiteralCustomTerm = (IntLiteralCustomTerm)literalCustomTerm;
            string = Integer.toString(intLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
            LongLiteralCustomTerm longLiteralCustomTerm = (LongLiteralCustomTerm)literalCustomTerm;
            string = Long.toString(longLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
            ByteLiteralCustomTerm byteLiteralCustomTerm = (ByteLiteralCustomTerm)literalCustomTerm;
            string = Byte.toString(byteLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
            FloatLiteralCustomTerm floatLiteralCustomTerm = (FloatLiteralCustomTerm)literalCustomTerm;
            string = Float.toString(floatLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
            DoubleLiteralCustomTerm doubleLiteralCustomTerm = (DoubleLiteralCustomTerm)literalCustomTerm;
            string = Double.toString(doubleLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof StringLiteralCustomTerm) {
            StringLiteralCustomTerm stringLiteralCustomTerm = (StringLiteralCustomTerm)literalCustomTerm;
            string = stringLiteralCustomTerm.value();
        } else {
            string = "";
        }
        return string;
    }

    public boolean getBooleanExpressionResult(CustomExpression parsedExpression) {
        boolean bl;
        LiteralCustomTerm evaluatedLiteral = this.evaluateToLiteral(parsedExpression);
        LiteralCustomTerm literalCustomTerm = evaluatedLiteral;
        if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm = (BooleanLiteralCustomTerm)literalCustomTerm;
            bl = booleanLiteralCustomTerm.value();
        } else {
            StringLiteralCustomTerm stringLiteralCustomTerm;
            DoubleLiteralCustomTerm doubleLiteralCustomTerm;
            FloatLiteralCustomTerm floatLiteralCustomTerm;
            ByteLiteralCustomTerm byteLiteralCustomTerm;
            LongLiteralCustomTerm longLiteralCustomTerm;
            IntLiteralCustomTerm intLiteralCustomTerm;
            bl = literalCustomTerm instanceof IntLiteralCustomTerm ? (intLiteralCustomTerm = (IntLiteralCustomTerm)literalCustomTerm).value() != 0 : (literalCustomTerm instanceof LongLiteralCustomTerm ? (longLiteralCustomTerm = (LongLiteralCustomTerm)literalCustomTerm).value() != 0L : (literalCustomTerm instanceof ByteLiteralCustomTerm ? (byteLiteralCustomTerm = (ByteLiteralCustomTerm)literalCustomTerm).value() != 0 : (literalCustomTerm instanceof FloatLiteralCustomTerm ? (double)(floatLiteralCustomTerm = (FloatLiteralCustomTerm)literalCustomTerm).value() != 0.0 : (literalCustomTerm instanceof DoubleLiteralCustomTerm ? (doubleLiteralCustomTerm = (DoubleLiteralCustomTerm)literalCustomTerm).value() != 0.0 : (literalCustomTerm instanceof StringLiteralCustomTerm ? !(stringLiteralCustomTerm = (StringLiteralCustomTerm)literalCustomTerm).value().isEmpty() : false)))));
        }
        return bl;
    }

    private LiteralCustomTerm evaluateToLiteral(CustomExpression parsedExpression) {
        LiteralCustomTerm literalCustomTerm;
        CustomExpression customExpression = parsedExpression;
        if (customExpression instanceof BinOpCustomExpression) {
            BinOpCustomExpression binOpCustomExpression = (BinOpCustomExpression)customExpression;
            literalCustomTerm = this.evaluateBinOp(binOpCustomExpression.op(), this.evaluateToLiteral(binOpCustomExpression.term1()), this.evaluateToLiteral(binOpCustomExpression.term2()));
        } else if (customExpression instanceof FunctionCustomExpression) {
            FunctionCustomExpression functionCustomExpression = (FunctionCustomExpression)customExpression;
            literalCustomTerm = this.evaluateFunc(functionCustomExpression.name(), (Seq<LiteralCustomTerm>)((Seq)functionCustomExpression.arguments().map((Function1 & Serializable & scala.Serializable)arg -> MODULE$.evaluateToLiteral((CustomExpression)arg), Seq$.MODULE$.canBuildFrom())));
        } else if (customExpression instanceof SimpleCustomExpression) {
            SimpleCustomExpression simpleCustomExpression = (SimpleCustomExpression)customExpression;
            literalCustomTerm = simpleCustomExpression.lit().isDefined() ? (LiteralCustomTerm)simpleCustomExpression.lit().get() : new IntLiteralCustomTerm(0);
        } else {
            throw new MatchError((Object)customExpression);
        }
        return literalCustomTerm;
    }

    private LiteralCustomTerm evaluateBinOp(String op, LiteralCustomTerm lhs, LiteralCustomTerm rhs) {
        scala.Serializable serializable;
        Tuple2<LiteralCustomTerm, LiteralCustomTerm> tuple2 = this.castToCommonDatatype(lhs, rhs);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LiteralCustomTerm castLhs = (LiteralCustomTerm)tuple2._1();
        LiteralCustomTerm castRhs = (LiteralCustomTerm)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)castLhs, (Object)castRhs);
        Tuple2 tuple23 = tuple22;
        LiteralCustomTerm castLhs2 = (LiteralCustomTerm)tuple23._1();
        LiteralCustomTerm castRhs2 = (LiteralCustomTerm)tuple23._2();
        Object lhsValue = this.extractValue(castLhs2);
        Object rhsValue = this.extractValue(castRhs2);
        String string = op;
        if ("+".equals(string)) {
            scala.Serializable serializable2;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable2 = new StringLiteralCustomTerm(new StringBuilder(0).append((String)lhsValue).append((String)rhsValue).toString());
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable2 = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) + BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable2 = new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) + BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable2 = new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) + BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable2 = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) + BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable2 = new ByteLiteralCustomTerm((byte)(BoxesRunTime.unboxToByte((Object)lhsValue) + BoxesRunTime.unboxToByte((Object)rhsValue)));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable2 = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) || BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable2;
        } else if ("-".equals(string)) {
            scala.Serializable serializable3;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable3 = new StringLiteralCustomTerm("");
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable3 = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) - BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable3 = new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) - BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable3 = new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) - BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable3 = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) - BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable3 = new ByteLiteralCustomTerm((byte)(BoxesRunTime.unboxToByte((Object)lhsValue) - BoxesRunTime.unboxToByte((Object)rhsValue)));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable3 = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) ^ BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable3;
        } else if ("*".equals(string)) {
            scala.Serializable serializable4;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable4 = new StringLiteralCustomTerm("");
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable4 = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) * BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable4 = new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) * BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable4 = new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) * BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable4 = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) * BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable4 = new ByteLiteralCustomTerm((byte)(BoxesRunTime.unboxToByte((Object)lhsValue) * BoxesRunTime.unboxToByte((Object)rhsValue)));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable4 = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) && BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable4;
        } else if ("/".equals(string)) {
            scala.Serializable serializable5;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable5 = new StringLiteralCustomTerm("");
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable5 = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) / BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable5 = new DoubleLiteralCustomTerm((double)BoxesRunTime.unboxToFloat((Object)lhsValue) / (double)BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable5 = new DoubleLiteralCustomTerm((double)BoxesRunTime.unboxToLong((Object)lhsValue) / (double)BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable5 = new DoubleLiteralCustomTerm((double)BoxesRunTime.unboxToInt((Object)lhsValue) / (double)BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable5 = new DoubleLiteralCustomTerm((double)BoxesRunTime.unboxToByte((Object)lhsValue) / (double)BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable5 = new BooleanLiteralCustomTerm(false);
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable5;
        } else if ("^".equals(string)) {
            scala.Serializable serializable6;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable6 = new StringLiteralCustomTerm("");
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable6 = new DoubleLiteralCustomTerm(Math.pow(BoxesRunTime.unboxToDouble((Object)lhsValue), BoxesRunTime.unboxToDouble((Object)rhsValue)));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable6 = new DoubleLiteralCustomTerm(Math.pow(BoxesRunTime.unboxToFloat((Object)lhsValue), BoxesRunTime.unboxToFloat((Object)rhsValue)));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable6 = new DoubleLiteralCustomTerm(Math.pow(BoxesRunTime.unboxToLong((Object)lhsValue), BoxesRunTime.unboxToLong((Object)rhsValue)));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable6 = new DoubleLiteralCustomTerm(Math.pow(BoxesRunTime.unboxToInt((Object)lhsValue), BoxesRunTime.unboxToInt((Object)rhsValue)));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable6 = new DoubleLiteralCustomTerm(Math.pow(BoxesRunTime.unboxToByte((Object)lhsValue), BoxesRunTime.unboxToByte((Object)rhsValue)));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable6 = new BooleanLiteralCustomTerm(false);
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable6;
        } else if ("&&".equals(string)) {
            scala.Serializable serializable7;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable7 = new StringLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString((String)lhsValue)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString((String)rhsValue)).nonEmpty() ? "1" : "0");
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable7 = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) != 0.0 && BoxesRunTime.unboxToDouble((Object)rhsValue) != 0.0 ? 1.0 : 0.0);
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable7 = new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) != 0.0f && BoxesRunTime.unboxToFloat((Object)rhsValue) != 0.0f ? 1.0f : 0.0f);
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable7 = new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) != 0L && BoxesRunTime.unboxToLong((Object)rhsValue) != 0L ? 1L : 0L);
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable7 = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) != 0 && BoxesRunTime.unboxToInt((Object)rhsValue) != 0 ? 1 : 0);
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable7 = new ByteLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) != 0 && BoxesRunTime.unboxToByte((Object)rhsValue) != 0 ? (byte)1 : 0);
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable7 = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) && BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable7;
        } else if ("||".equals(string)) {
            scala.Serializable serializable8;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                serializable8 = new StringLiteralCustomTerm(((String)lhsValue).isEmpty() && ((String)rhsValue).isEmpty() ? "0" : "1");
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                serializable8 = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) == 0.0 && BoxesRunTime.unboxToDouble((Object)rhsValue) == 0.0 ? 0.0 : 1.0);
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                serializable8 = new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) == 0.0f && BoxesRunTime.unboxToFloat((Object)rhsValue) == 0.0f ? 0.0f : 1.0f);
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                serializable8 = new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) == 0L && BoxesRunTime.unboxToLong((Object)rhsValue) == 0L ? 0L : 1L);
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                serializable8 = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) == 0 && BoxesRunTime.unboxToInt((Object)rhsValue) == 0 ? 0 : 1);
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                serializable8 = new ByteLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) == 0 && BoxesRunTime.unboxToByte((Object)rhsValue) == 0 ? (byte)0 : 1);
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                serializable8 = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) || BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = serializable8;
        } else if (">".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString((String)lhsValue)).$greater((Object)((String)rhsValue)));
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) > BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) > BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) > BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) > BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) > BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new RichBoolean(Predef$.MODULE$.booleanWrapper(BoxesRunTime.unboxToBoolean((Object)lhsValue))).$greater((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)rhsValue))));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = booleanLiteralCustomTerm;
        } else if ("<".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString((String)lhsValue)).$less((Object)((String)rhsValue)));
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) < BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) < BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) < BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) < BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) < BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new RichBoolean(Predef$.MODULE$.booleanWrapper(BoxesRunTime.unboxToBoolean((Object)lhsValue))).$less((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)rhsValue))));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = booleanLiteralCustomTerm;
        } else if (">=".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString((String)lhsValue)).$greater$eq((Object)((String)rhsValue)));
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) >= BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) >= BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) >= BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) >= BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) >= BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new RichBoolean(Predef$.MODULE$.booleanWrapper(BoxesRunTime.unboxToBoolean((Object)lhsValue))).$greater$eq((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)rhsValue))));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = booleanLiteralCustomTerm;
        } else if ("<=".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString((String)lhsValue)).$less$eq((Object)((String)rhsValue)));
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) <= BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) <= BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) <= BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) <= BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) <= BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(new RichBoolean(Predef$.MODULE$.booleanWrapper(BoxesRunTime.unboxToBoolean((Object)lhsValue))).$less$eq((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)rhsValue))));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = booleanLiteralCustomTerm;
        } else if ("==".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                String string2 = (String)lhsValue;
                String string3 = (String)rhsValue;
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(!(string2 != null ? !string2.equals(string3) : string3 != null));
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) == BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) == BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) == BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) == BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) == BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) == BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = booleanLiteralCustomTerm;
        } else if ("!=".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            LiteralCustomTerm literalCustomTerm = castLhs2;
            if (literalCustomTerm instanceof StringLiteralCustomTerm) {
                String string4 = (String)lhsValue;
                String string5 = (String)rhsValue;
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(string4 == null ? string5 != null : !string4.equals(string5));
            } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue) != BoxesRunTime.unboxToDouble((Object)rhsValue));
            } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue) != BoxesRunTime.unboxToFloat((Object)rhsValue));
            } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue) != BoxesRunTime.unboxToLong((Object)rhsValue));
            } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue) != BoxesRunTime.unboxToInt((Object)rhsValue));
            } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue) != BoxesRunTime.unboxToByte((Object)rhsValue));
            } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue) != BoxesRunTime.unboxToBoolean((Object)rhsValue));
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
            serializable = booleanLiteralCustomTerm;
        } else {
            throw new MatchError((Object)string);
        }
        return serializable;
    }

    private Tuple2<LiteralCustomTerm, LiteralCustomTerm> castToCommonDatatype(LiteralCustomTerm lhs, LiteralCustomTerm rhs) {
        Tuple2 tuple2;
        block8: {
            Object lhsValue = this.extractValue(lhs);
            Object rhsValue = this.extractValue(rhs);
            try {
                if (lhsValue instanceof String || rhsValue instanceof String) {
                    tuple2 = new Tuple2((Object)new StringLiteralCustomTerm(lhsValue.toString()), (Object)new StringLiteralCustomTerm(rhsValue.toString()));
                    break block8;
                }
                if (lhsValue instanceof Double || rhsValue instanceof Double) {
                    tuple2 = new Tuple2((Object)new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)lhsValue)), (Object)new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)rhsValue)));
                    break block8;
                }
                if (lhsValue instanceof Float || rhsValue instanceof Float) {
                    tuple2 = new Tuple2((Object)new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)lhsValue)), (Object)new FloatLiteralCustomTerm(BoxesRunTime.unboxToFloat((Object)rhsValue)));
                    break block8;
                }
                if (lhsValue instanceof Long || rhsValue instanceof Long) {
                    tuple2 = new Tuple2((Object)new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)lhsValue)), (Object)new LongLiteralCustomTerm(BoxesRunTime.unboxToLong((Object)rhsValue)));
                    break block8;
                }
                if (lhsValue instanceof Integer || rhsValue instanceof Integer) {
                    tuple2 = new Tuple2((Object)new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)lhsValue)), (Object)new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)rhsValue)));
                    break block8;
                }
                if (lhsValue instanceof Byte || rhsValue instanceof Byte) {
                    tuple2 = new Tuple2((Object)new ByteLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)lhsValue)), (Object)new ByteLiteralCustomTerm(BoxesRunTime.unboxToByte((Object)rhsValue)));
                    break block8;
                }
                tuple2 = new Tuple2((Object)new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue)), (Object)new BooleanLiteralCustomTerm(BoxesRunTime.unboxToBoolean((Object)lhsValue)));
            }
            catch (Throwable throwable) {
                tuple2 = new Tuple2((Object)new StringLiteralCustomTerm(lhsValue.toString()), (Object)new StringLiteralCustomTerm(rhsValue.toString()));
            }
        }
        return tuple2;
    }

    private Object extractValue(LiteralCustomTerm lit) {
        Object object;
        LiteralCustomTerm literalCustomTerm = lit;
        if (literalCustomTerm instanceof StringLiteralCustomTerm) {
            StringLiteralCustomTerm stringLiteralCustomTerm = (StringLiteralCustomTerm)literalCustomTerm;
            object = stringLiteralCustomTerm.value();
        } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
            DoubleLiteralCustomTerm doubleLiteralCustomTerm = (DoubleLiteralCustomTerm)literalCustomTerm;
            object = BoxesRunTime.boxToDouble((double)doubleLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
            FloatLiteralCustomTerm floatLiteralCustomTerm = (FloatLiteralCustomTerm)literalCustomTerm;
            object = BoxesRunTime.boxToFloat((float)floatLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof IntLiteralCustomTerm) {
            IntLiteralCustomTerm intLiteralCustomTerm = (IntLiteralCustomTerm)literalCustomTerm;
            object = BoxesRunTime.boxToInteger((int)intLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
            LongLiteralCustomTerm longLiteralCustomTerm = (LongLiteralCustomTerm)literalCustomTerm;
            object = BoxesRunTime.boxToLong((long)longLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof ByteLiteralCustomTerm) {
            ByteLiteralCustomTerm byteLiteralCustomTerm = (ByteLiteralCustomTerm)literalCustomTerm;
            object = BoxesRunTime.boxToByte((byte)byteLiteralCustomTerm.value());
        } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm = (BooleanLiteralCustomTerm)literalCustomTerm;
            object = BoxesRunTime.boxToBoolean((boolean)booleanLiteralCustomTerm.value());
        } else {
            boolean bl = literalCustomTerm instanceof NoneLiteralCustomTerm ? true : (literalCustomTerm instanceof NullLiteralCustomTerm ? true : (literalCustomTerm instanceof ConditionalNullLiteralCustomTerm ? true : literalCustomTerm instanceof ExpressionLiteralCustomTerm));
            if (bl) {
                object = BoxesRunTime.boxToBoolean((boolean)false);
            } else {
                throw new MatchError((Object)literalCustomTerm);
            }
        }
        return object;
    }

    private LiteralCustomTerm evaluateFunc(String name, Seq<LiteralCustomTerm> args) {
        scala.Serializable serializable;
        Seq argValues = (Seq)args.map((Function1 & Serializable & scala.Serializable)arg -> MODULE$.extractValue((LiteralCustomTerm)arg), Seq$.MODULE$.canBuildFrom());
        String string = name.toLowerCase();
        if ("!".equals(string)) {
            scala.Serializable serializable2;
            Object object = argValues.head();
            if (object instanceof StringLiteralCustomTerm) {
                StringLiteralCustomTerm stringLiteralCustomTerm = (StringLiteralCustomTerm)object;
                serializable2 = new StringLiteralCustomTerm(stringLiteralCustomTerm.value().isEmpty() ? "1" : "");
            } else if (object instanceof DoubleLiteralCustomTerm) {
                DoubleLiteralCustomTerm doubleLiteralCustomTerm = (DoubleLiteralCustomTerm)object;
                serializable2 = new DoubleLiteralCustomTerm(doubleLiteralCustomTerm.value() == 0.0 ? 1.0 : 0.0);
            } else if (object instanceof FloatLiteralCustomTerm) {
                FloatLiteralCustomTerm floatLiteralCustomTerm = (FloatLiteralCustomTerm)object;
                serializable2 = new FloatLiteralCustomTerm(floatLiteralCustomTerm.value() == 0.0f ? 1.0f : 0.0f);
            } else if (object instanceof LongLiteralCustomTerm) {
                LongLiteralCustomTerm longLiteralCustomTerm = (LongLiteralCustomTerm)object;
                serializable2 = new LongLiteralCustomTerm(longLiteralCustomTerm.value() == 0L ? 1L : 0L);
            } else if (object instanceof IntLiteralCustomTerm) {
                IntLiteralCustomTerm intLiteralCustomTerm = (IntLiteralCustomTerm)object;
                serializable2 = new IntLiteralCustomTerm(intLiteralCustomTerm.value() == 0 ? 1 : 0);
            } else if (object instanceof ByteLiteralCustomTerm) {
                ByteLiteralCustomTerm byteLiteralCustomTerm = (ByteLiteralCustomTerm)object;
                serializable2 = new ByteLiteralCustomTerm(byteLiteralCustomTerm.value() == 0 ? (byte)1 : 0);
            } else if (object instanceof BooleanLiteralCustomTerm) {
                BooleanLiteralCustomTerm booleanLiteralCustomTerm = (BooleanLiteralCustomTerm)object;
                serializable2 = new BooleanLiteralCustomTerm(!booleanLiteralCustomTerm.value());
            } else {
                throw new MatchError(object);
            }
            serializable = serializable2;
        } else if ("tostring".equals(string)) {
            serializable = new StringLiteralCustomTerm(argValues.head().toString());
        } else if ("hextonumber".equals(string)) {
            serializable = new IntLiteralCustomTerm(Integer.parseInt(argValues.head().toString(), 16));
        } else if ("bintoint".equals(string)) {
            serializable = new IntLiteralCustomTerm(Integer.parseInt(argValues.head().toString(), 2));
        } else if ("charfromint".equals(string)) {
            serializable = new StringLiteralCustomTerm(Character.toString((char)BoxesRunTime.unboxToInt((Object)argValues.head())));
        } else if ("chartoint".equals(string)) {
            serializable = new IntLiteralCustomTerm(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(argValues.head().toString())).head()));
        } else if ("inttobin".equals(string)) {
            serializable = new StringLiteralCustomTerm(Integer.toBinaryString(BoxesRunTime.unboxToInt((Object)argValues.head())));
        } else if ("inttohex".equals(string)) {
            serializable = new StringLiteralCustomTerm(Integer.toHexString(BoxesRunTime.unboxToInt((Object)argValues.head())));
        } else if ("todegrees".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)argValues.head()) * 57.29577951308232);
        } else if ("toradians".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)argValues.head()) * (Math.PI / 180));
        } else if ("abs".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.abs(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("acos".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.acos(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("asin".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.asin(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("atan".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.atan(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("atan2".equals(string)) {
            double y = BoxesRunTime.unboxToDouble((Object)argValues.apply(0));
            double x = BoxesRunTime.unboxToDouble((Object)argValues.apply(1));
            serializable = new DoubleLiteralCustomTerm(Math.atan2(y, x));
        } else if ("cos".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.cos(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("cosh".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.cosh(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("exp".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.exp(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("factorial".equals(string)) {
            int n = BoxesRunTime.unboxToInt((Object)argValues.head());
            serializable = new LongLiteralCustomTerm(this.factorial$1(n).longValue());
        } else if ("mod".equals(string)) {
            double x = BoxesRunTime.unboxToDouble((Object)argValues.apply(0));
            double y = BoxesRunTime.unboxToDouble((Object)argValues.apply(1));
            serializable = new DoubleLiteralCustomTerm(x % y);
        } else if ("pow".equals(string)) {
            double base = BoxesRunTime.unboxToDouble((Object)argValues.apply(0));
            double exponent = BoxesRunTime.unboxToDouble((Object)argValues.apply(1));
            serializable = new DoubleLiteralCustomTerm(Math.pow(base, exponent));
        } else if ("rand".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Random$.MODULE$.nextDouble());
        } else if ("sin".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.sin(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("sinh".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.sinh(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("sqrt".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.sqrt(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("tan".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.tan(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("tanh".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(Math.tanh(BoxesRunTime.unboxToDouble((Object)argValues.head())));
        } else if ("binaryand".equals(string)) {
            serializable = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)argValues.apply(0)) & BoxesRunTime.unboxToInt((Object)argValues.apply(1)));
        } else if ("binarynot".equals(string)) {
            serializable = new IntLiteralCustomTerm(~BoxesRunTime.unboxToInt((Object)argValues.apply(0)));
        } else if ("binaryor".equals(string)) {
            serializable = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)argValues.apply(0)) | BoxesRunTime.unboxToInt((Object)argValues.apply(1)));
        } else if ("binaryxor".equals(string)) {
            serializable = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)argValues.apply(0)) ^ BoxesRunTime.unboxToInt((Object)argValues.apply(1)));
        } else if ("shiftleft".equals(string)) {
            serializable = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)argValues.apply(0)) << BoxesRunTime.unboxToInt((Object)argValues.apply(1)));
        } else if ("shiftright".equals(string)) {
            serializable = new IntLiteralCustomTerm(BoxesRunTime.unboxToInt((Object)argValues.apply(0)) >> BoxesRunTime.unboxToInt((Object)argValues.apply(1)));
        } else if ("isempty".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(argValues.head().toString().isEmpty());
        } else if ("isnull".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(argValues.head() == null);
        } else if ("isnotnull".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(argValues.head() != null);
        } else if ("isinteger".equals(string)) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm;
            try {
                int _ = BoxesRunTime.unboxToInt((Object)argValues.head());
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(true);
            }
            catch (Throwable throwable) {
                booleanLiteralCustomTerm = new BooleanLiteralCustomTerm(false);
            }
            serializable = booleanLiteralCustomTerm;
        } else if ("islowercase".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString(argValues.head().toString())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$2))))));
        } else if ("isuppercase".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(new StringOps(Predef$.MODULE$.augmentString(argValues.head().toString())).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3))))));
        } else if ("equalstrings".equals(string)) {
            String string2 = argValues.apply(0).toString();
            String string3 = argValues.apply(1).toString();
            serializable = new BooleanLiteralCustomTerm(!(string2 != null ? !string2.equals(string3) : string3 != null));
        } else if ("isstring".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(true);
        } else if ("between".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)argValues.apply(0)) < BoxesRunTime.unboxToDouble((Object)argValues.apply(1)) || BoxesRunTime.unboxToDouble((Object)argValues.apply(0)) > BoxesRunTime.unboxToDouble((Object)argValues.apply(2)));
        } else if ("bound".equals(string)) {
            serializable = new BooleanLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)argValues.apply(0)) > BoxesRunTime.unboxToDouble((Object)argValues.apply(1)) && BoxesRunTime.unboxToDouble((Object)argValues.apply(0)) < BoxesRunTime.unboxToDouble((Object)argValues.apply(2)));
        } else if ("min".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)argValues.map((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToDouble((double)ExpressionEvaluator$.$anonfun$evaluateFunc$4(arg)), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$)));
        } else if ("max".equals(string)) {
            serializable = new DoubleLiteralCustomTerm(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)argValues.map((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToDouble((double)ExpressionEvaluator$.$anonfun$evaluateFunc$5(arg)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$)));
        } else if ("minidx".equals(string)) {
            Seq argDoubles = (Seq)argValues.map((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToDouble((double)ExpressionEvaluator$.$anonfun$evaluateFunc$6(arg)), Seq$.MODULE$.canBuildFrom());
            serializable = new IntLiteralCustomTerm(argDoubles.indexOf(argDoubles.min((Ordering)Ordering.Double$.MODULE$)));
        } else if ("maxidx".equals(string)) {
            Seq argDoubles = (Seq)argValues.map((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToDouble((double)ExpressionEvaluator$.$anonfun$evaluateFunc$7(arg)), Seq$.MODULE$.canBuildFrom());
            serializable = new IntLiteralCustomTerm(argDoubles.indexOf(argDoubles.max((Ordering)Ordering.Double$.MODULE$)));
        } else {
            throw new MatchError((Object)string);
        }
        return serializable;
    }

    private final BigInt factHelper$1(int x, BigInt acc) {
        while (x > 1) {
            acc = acc.$times(BigInt$.MODULE$.int2bigInt(x));
            --x;
        }
        return acc;
    }

    private final BigInt factorial$1(int n) {
        return this.factHelper$1(n, package$.MODULE$.BigInt().apply(1));
    }

    public static final /* synthetic */ double $anonfun$evaluateFunc$4(Object arg) {
        return BoxesRunTime.unboxToDouble((Object)arg);
    }

    public static final /* synthetic */ double $anonfun$evaluateFunc$5(Object arg) {
        return BoxesRunTime.unboxToDouble((Object)arg);
    }

    public static final /* synthetic */ double $anonfun$evaluateFunc$6(Object arg) {
        return BoxesRunTime.unboxToDouble((Object)arg);
    }

    public static final /* synthetic */ double $anonfun$evaluateFunc$7(Object arg) {
        return BoxesRunTime.unboxToDouble((Object)arg);
    }

    private ExpressionEvaluator$() {
        MODULE$ = this;
    }
}

