/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.alteryx.language;

import io.prophecy.abinitio.xfr.ast.BinOpCustomExpression;
import io.prophecy.abinitio.xfr.ast.BooleanFormat;
import io.prophecy.abinitio.xfr.ast.BooleanLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.CustomDataFormat;
import io.prophecy.abinitio.xfr.ast.CustomExpression;
import io.prophecy.abinitio.xfr.ast.DateFormat;
import io.prophecy.abinitio.xfr.ast.DoubleLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.FloatLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.FunctionCustomExpression;
import io.prophecy.abinitio.xfr.ast.GlobalVariableCustomTerm;
import io.prophecy.abinitio.xfr.ast.IfElseCustomExpression;
import io.prophecy.abinitio.xfr.ast.IntLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.LiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.LongLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.NullLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.NumberFormat;
import io.prophecy.abinitio.xfr.ast.SimpleCustomExpression;
import io.prophecy.abinitio.xfr.ast.SimpleVariableCustomTerm;
import io.prophecy.abinitio.xfr.ast.StringFormat;
import io.prophecy.abinitio.xfr.ast.StringLiteralCustomTerm;
import io.prophecy.abinitio.xfr.ast.TypeCastCustomExpression;
import io.prophecy.abinitio.xfr.ast.UnOpCustomExpression;
import io.prophecy.abinitio.xfr.ast.VariableCustomTerm;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;

public final class SparkSqlPrinter$ {
    public static SparkSqlPrinter$ MODULE$;

    static {
        new SparkSqlPrinter$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String apply(CustomExpression customExpression) {
        boolean bl = false;
        SimpleCustomExpression simpleCustomExpression = null;
        CustomExpression customExpression2 = customExpression;
        if (customExpression2 instanceof UnOpCustomExpression) {
            UnOpCustomExpression unOpCustomExpression = (UnOpCustomExpression)customExpression2;
            String op = unOpCustomExpression.op();
            CustomExpression term1 = unOpCustomExpression.term1();
            return new StringBuilder(4).append("(").append(op).append("(").append(this.apply(term1)).append("))").toString();
        }
        if (customExpression2 instanceof BinOpCustomExpression) {
            BinOpCustomExpression binOpCustomExpression = (BinOpCustomExpression)customExpression2;
            String op = binOpCustomExpression.op();
            CustomExpression term1 = binOpCustomExpression.term1();
            CustomExpression term2 = binOpCustomExpression.term2();
            String term1String = this.apply(term1);
            String term2String = this.apply(term2);
            return new StringBuilder(4).append("(").append(term1String).append(" ").append(op).append(" ").append(term2String).append(")").toString();
        }
        if (customExpression2 instanceof FunctionCustomExpression) {
            FunctionCustomExpression functionCustomExpression = (FunctionCustomExpression)customExpression2;
            String name = functionCustomExpression.name();
            Seq<CustomExpression> args = functionCustomExpression.arguments();
            Seq argsSql = (Seq)args.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.apply((CustomExpression)x), Seq$.MODULE$.canBuildFrom());
            String argsString = argsSql.mkString(", ");
            return new StringBuilder(4).append("(").append(name).append("(").append(argsString).append("))").toString();
        }
        if (customExpression2 instanceof IfElseCustomExpression) {
            IfElseCustomExpression ifElseCustomExpression = (IfElseCustomExpression)customExpression2;
            CustomExpression condition = ifElseCustomExpression.condition();
            CustomExpression theIf = ifElseCustomExpression.theIf();
            CustomExpression theElse = ifElseCustomExpression.theElse();
            String ifString = this.apply(theIf);
            String elseString = this.apply(theElse);
            String conditionString = this.apply(condition);
            return new StringBuilder(32).append("case when (").append(conditionString).append(") then (").append(ifString).append(") else (").append(elseString).append(") end").toString();
        }
        if (customExpression2 instanceof SimpleCustomExpression) {
            bl = true;
            simpleCustomExpression = (SimpleCustomExpression)customExpression2;
            Option<LiteralCustomTerm> option = simpleCustomExpression.lit();
            Option<VariableCustomTerm> option2 = simpleCustomExpression.name();
            if (option instanceof Some) {
                Some some = (Some)option;
                LiteralCustomTerm lit = (LiteralCustomTerm)some.value();
                if (None$.MODULE$.equals(option2)) {
                    return this.printLiterals(lit);
                }
            }
        }
        if (bl) {
            Option<LiteralCustomTerm> option = simpleCustomExpression.lit();
            Option<VariableCustomTerm> option3 = simpleCustomExpression.name();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                Some some = (Some)option3;
                VariableCustomTerm variable = (VariableCustomTerm)some.value();
                return this.printVariables(variable);
            }
        }
        if (!(customExpression2 instanceof TypeCastCustomExpression)) return customExpression2.toString();
        TypeCastCustomExpression typeCastCustomExpression = (TypeCastCustomExpression)customExpression2;
        CustomDataFormat theType = typeCastCustomExpression.theType();
        CustomExpression term1 = typeCastCustomExpression.term1();
        String termString = this.apply(term1);
        return new StringBuilder(11).append("cast (").append(termString).append(") as ").append(this.printCustomDataFormat(theType)).toString();
    }

    private String printVariables(VariableCustomTerm variable) {
        String string;
        VariableCustomTerm variableCustomTerm = variable;
        if (variableCustomTerm instanceof SimpleVariableCustomTerm) {
            SimpleVariableCustomTerm simpleVariableCustomTerm = (SimpleVariableCustomTerm)variableCustomTerm;
            String name = simpleVariableCustomTerm.name();
            string = this.getRawColumnName(name);
        } else if (variableCustomTerm instanceof GlobalVariableCustomTerm) {
            GlobalVariableCustomTerm globalVariableCustomTerm = (GlobalVariableCustomTerm)variableCustomTerm;
            String name = globalVariableCustomTerm.name();
            string = new StringBuilder(3).append("${").append(name).append("}").toString();
        } else {
            throw new MatchError((Object)variableCustomTerm);
        }
        return string;
    }

    private String printLiterals(LiteralCustomTerm lit) {
        String string;
        LiteralCustomTerm literalCustomTerm = lit;
        if (literalCustomTerm instanceof IntLiteralCustomTerm) {
            IntLiteralCustomTerm intLiteralCustomTerm = (IntLiteralCustomTerm)literalCustomTerm;
            int value = intLiteralCustomTerm.value();
            string = String.valueOf(BoxesRunTime.boxToInteger((int)value));
        } else if (literalCustomTerm instanceof LongLiteralCustomTerm) {
            LongLiteralCustomTerm longLiteralCustomTerm = (LongLiteralCustomTerm)literalCustomTerm;
            long value = longLiteralCustomTerm.value();
            string = String.valueOf(BoxesRunTime.boxToLong((long)value));
        } else if (literalCustomTerm instanceof FloatLiteralCustomTerm) {
            FloatLiteralCustomTerm floatLiteralCustomTerm = (FloatLiteralCustomTerm)literalCustomTerm;
            float value = floatLiteralCustomTerm.value();
            string = String.valueOf(BoxesRunTime.boxToFloat((float)value));
        } else if (literalCustomTerm instanceof DoubleLiteralCustomTerm) {
            DoubleLiteralCustomTerm doubleLiteralCustomTerm = (DoubleLiteralCustomTerm)literalCustomTerm;
            double value = doubleLiteralCustomTerm.value();
            string = String.valueOf(BoxesRunTime.boxToDouble((double)value));
        } else if (literalCustomTerm instanceof StringLiteralCustomTerm) {
            StringLiteralCustomTerm stringLiteralCustomTerm = (StringLiteralCustomTerm)literalCustomTerm;
            String value = stringLiteralCustomTerm.value();
            string = new StringBuilder(2).append("'").append(value).append("'").toString();
        } else if (literalCustomTerm instanceof BooleanLiteralCustomTerm) {
            BooleanLiteralCustomTerm booleanLiteralCustomTerm = (BooleanLiteralCustomTerm)literalCustomTerm;
            boolean value = booleanLiteralCustomTerm.value();
            string = String.valueOf(BoxesRunTime.boxToBoolean((boolean)value));
        } else {
            string = literalCustomTerm instanceof NullLiteralCustomTerm ? "NULL" : new StringBuilder(2).append("'").append(literalCustomTerm.toString()).append("'").toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getRawColumnName(String inputString) {
        void var2_5;
        String string;
        if (inputString.contains(".")) {
            int indexOfDot = inputString.indexOf(".");
            String namespace = inputString.substring(0, indexOfDot);
            String variableName = inputString.substring(indexOfDot + 1);
            string = variableName.replace("`", "");
        } else {
            string = inputString.replace("`", "");
        }
        String justColName = string;
        return justColName.contains(" ") ? new StringBuilder(2).append("`").append(justColName).append("`").toString() : var2_5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String printCustomDataFormat(CustomDataFormat customDataFormat) {
        boolean bl = false;
        NumberFormat numberFormat = null;
        CustomDataFormat customDataFormat2 = customDataFormat;
        if (customDataFormat2 instanceof NumberFormat) {
            Some some;
            int n;
            bl = true;
            numberFormat = (NumberFormat)customDataFormat2;
            Option<Object> option = numberFormat.precision();
            Option<Object> option2 = numberFormat.scale();
            Option<String> option3 = numberFormat.delimiter();
            String string = numberFormat.theType();
            if (option instanceof Some && 4 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) && None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && "integer".equals(string)) {
                return "INT";
            }
        }
        if (bl) {
            Some some;
            int n;
            Option<Object> option = numberFormat.precision();
            Option<Object> option4 = numberFormat.scale();
            Option<String> option5 = numberFormat.delimiter();
            String string = numberFormat.theType();
            if (option instanceof Some && 38 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) && None$.MODULE$.equals(option4) && None$.MODULE$.equals(option5) && "double".equals(string)) {
                return "DOUBLE";
            }
        }
        if (customDataFormat2 instanceof StringFormat) {
            return "STRING";
        }
        if (customDataFormat2 instanceof BooleanFormat) {
            return "BOOLEAN";
        }
        if (!(customDataFormat2 instanceof DateFormat)) return "STRING";
        DateFormat dateFormat = (DateFormat)customDataFormat2;
        Option<String> option = dateFormat.format();
        if (!(option instanceof Some)) return "STRING";
        Some some = (Some)option;
        String string = (String)some.value();
        if (!"yyyy-MM-dd HH:mm:ss.SSSS".equals(string)) return "STRING";
        return "TIMESTAMP";
    }

    private SparkSqlPrinter$() {
        MODULE$ = this;
    }
}

